/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.maintenance.migration.migrators.scalarMigration;
import com.rusefi.tune.xml.Constant;
import java.util.Optional;

public enum ScalarToArrayMigrator implements TuneMigrator
{
    INSTANCE;

    private static final scalarMigration[] fieldsToMigrate;

    @Override
    public void migrateTune(TuneMigrationContext context) {
        for (scalarMigration field : fieldsToMigrate) {
            Optional<IniField> prevField = context.getPrevIniFile().findIniField(field.getPrevFieldName());
            Optional<IniField> updatedField = context.getUpdatedIniFile().findIniField(field.getUpdatedFieldName());
            Constant prevConst = context.getPrevTune().getConstantsAsMap().get(field.getPrevFieldName());
            Constant updatedConst = context.getUpdatedTune().getConstantsAsMap().get(field.getUpdatedFieldName());
            if (!prevField.isPresent() || !updatedField.isPresent() || prevConst == null || updatedConst == null || !(updatedField.get() instanceof ArrayIniField) || !(prevField.get() instanceof ScalarIniField)) continue;
            ArrayIniField migratedField = (ArrayIniField)updatedField.get();
            String[][] migratedValues = migratedField.getValues(updatedConst.getValue());
            String prevValue = prevConst.getValue();
            for (int row = 0; row < migratedValues.length; ++row) {
                for (int column = 0; column < migratedValues[0].length; ++column) {
                    migratedValues[row][column] = prevValue;
                }
            }
            context.addMigration(migratedField.getName(), new Constant(migratedField.getName(), migratedField.getUnits(), migratedField.formatValue(migratedValues), migratedField.getDigits(), Integer.toString(migratedField.getRows()), Integer.toString(migratedField.getCols())));
        }
    }

    static {
        fieldsToMigrate = new scalarMigration[]{new scalarMigration("afterCrankingIACtaperDuration", "afterCrankingIACtaperDuration")};
    }
}

