/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.sensor_logs;

import com.devexperts.logging.FileLogger;
import com.rusefi.Launcher;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.sensor_logs.BinarySensorLog;
import com.rusefi.sensor_logs.SensorLog;
import com.rusefi.sensor_logs.SensorLogger;
import com.rusefi.ui.UIContext;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class PlainTextSensorLog
implements SensorLog {
    private final UIContext uiContext;
    private Writer logFile;
    private long fileStartTime;

    public PlainTextSensorLog(UIContext uiContext) {
        this.uiContext = uiContext;
    }

    private void startIfNeeded() {
        if (this.logFile == null) {
            this.startSensorLogFile();
        }
    }

    private void startSensorLogFile() {
        FileLogger.createFolderIfNeeded();
        String fileName = "logs/rusEFI_gauges_" + FileLogger.getDate() + ".msl";
        this.fileStartTime = System.currentTimeMillis();
        try {
            this.logFile = new FileWriter(fileName);
            this.logFile.write("\"rusEFI console20260115 firmware " + (String)Launcher.firmwareVersion.get() + "\"\r\n");
            this.logFile.write("Captured " + FileLogger.getDate() + "\r\n");
            BinaryProtocol bp = this.uiContext.getLinkManager().getCurrentStreamState();
            this.logFile.write("Time\t");
            for (Sensor sensor : SensorLogger.SENSORS) {
                this.logFile.write(SensorLogger.getSensorName(sensor, -1) + "\t");
            }
            this.logFile.write("\r\n");
            this.logFile.write("Time\t");
            for (Sensor sensor : SensorLogger.SENSORS) {
                this.logFile.write(sensor.getUnits() + "\t");
            }
            this.logFile.write("\r\n");
            this.logFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logFile = null;
        }
    }

    @Override
    public double getSecondsSinceFileStart() {
        long msSinceFileStart = System.currentTimeMillis() - this.fileStartTime;
        return (double)msSinceFileStart / 1000.0;
    }

    @Override
    public void writeSensorLogLine() {
        this.startIfNeeded();
        if (this.logFile == null) {
            return;
        }
        try {
            this.logFile.write(this.getSecondsSinceFileStart() + "\t");
            for (Sensor sensor : SensorLogger.SENSORS) {
                this.logFile.write(sensor.getLogValue(SensorCentral.getInstance().getValue(sensor)) + "\t");
            }
            this.logFile.write("\r\n");
            this.logFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logFile = null;
        }
    }

    @Override
    public void close() {
        BinarySensorLog.close(this.logFile);
        this.logFile = null;
    }
}

