/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import java.util.ArrayList;
import java.util.List;

public class RpmModel {
    private static final RpmModel INSTANCE = new RpmModel();
    private static final double SMOOTHING_RATIO = 0.05;
    private int displayedValue;
    private int value;
    private final List<RpmListener> listeners = new ArrayList<RpmListener>();
    private long timeAtLastUpdate;

    public static RpmModel getInstance() {
        return INSTANCE;
    }

    private RpmModel() {
        SensorCentral.getInstance().addListener(Sensor.RPMValue, value -> this.setValue((int)value));
    }

    public void setValue(int rpm) {
        this.value = rpm;
        for (RpmListener listener : this.listeners) {
            listener.onRpmChange(this);
        }
    }

    public int getValue() {
        return this.value;
    }

    public int getSmoothedValue() {
        boolean isOlderThenOneSecond;
        int diff = Math.abs(this.displayedValue - this.value);
        boolean bl = isOlderThenOneSecond = System.currentTimeMillis() - this.timeAtLastUpdate > 1000L;
        if ((double)diff > (double)this.value * 0.05 || isOlderThenOneSecond) {
            this.timeAtLastUpdate = System.currentTimeMillis();
            this.displayedValue = this.value;
        }
        return this.displayedValue;
    }

    public void addListener(RpmListener listener) {
        this.listeners.add(listener);
    }

    static interface RpmListener {
        public void onRpmChange(RpmModel var1);
    }
}

