/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.widgets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JPopupMenu;

public class PopupMenuButton
extends JButton {
    private boolean isShowingPopup = false;

    public PopupMenuButton(String text, final JPopupMenu menu) {
        super(text);
        menu.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                System.out.println("LOST FOCUS");
                PopupMenuButton.this.isShowingPopup = false;
            }

            @Override
            public void focusGained(FocusEvent e) {
                System.out.println("GAINED FOCUS");
            }
        });
        menu.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                System.out.println("SHOWN");
            }

            @Override
            public void componentResized(ComponentEvent e) {
                System.out.println("RESIZED");
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                System.out.println("MOVED");
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                System.out.println("HIDDEN");
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("isShowingPopup: " + PopupMenuButton.this.isShowingPopup);
                if (PopupMenuButton.this.isShowingPopup) {
                    menu.requestFocus();
                    PopupMenuButton.this.isShowingPopup = false;
                } else {
                    Component c = (Component)e.getSource();
                    menu.show(c, -1, c.getHeight());
                    PopupMenuButton.this.isShowingPopup = true;
                }
            }
        });
        this.setFocusable(true);
        menu.setFocusable(true);
    }
}

