/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.FrameType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public class Horizon
extends AbstractRadial {
    private double roll;
    private double oldRoll;
    private double pitch;
    private double oldPitch;
    private double pitchPixel;
    private boolean upsidedown = false;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage horizonImage;
    private BufferedImage horizonForegroundImage;
    private boolean customColors = false;
    private Color customSkyColor;
    private Color customGroundColor;
    private BufferedImage disabledImage;
    private final Ellipse2D CLIP = new Ellipse2D.Double();
    private Timeline timelineRoll = new Timeline(this);
    private Timeline timelinePitch = new Timeline(this);

    public Horizon() {
        this.customSkyColor = new Color(127, 213, 240, 255);
        this.customGroundColor = new Color(60, 68, 57, 255);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.pitch = 0.0;
        this.roll = 0.0;
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        this.CLIP.setFrame((double)GAUGE_WIDTH * 0.08411215245723724, (double)GAUGE_WIDTH * 0.08411215245723724, (double)GAUGE_WIDTH * 0.8317756652832031, (double)GAUGE_WIDTH * 0.8317756652832031);
        this.pitchPixel = (double)((int)(Math.PI * (double)GAUGE_WIDTH)) / 360.0;
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(GAUGE_WIDTH, GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.horizonImage != null) {
            this.horizonImage.flush();
        }
        this.horizonImage = this.create_HORIZON_Image(GAUGE_WIDTH);
        this.create_INDICATOR_Image(GAUGE_WIDTH, this.fImage);
        if (this.horizonForegroundImage != null) {
            this.horizonForegroundImage.flush();
        }
        this.horizonForegroundImage = this.create_HORIZON_FOREGROUND_Image(GAUGE_WIDTH);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(GAUGE_WIDTH, GAUGE_WIDTH, false, this.fImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(GAUGE_WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterX());
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        Shape OLD_CLIP = G2.getClip();
        G2.setClip(this.CLIP);
        G2.rotate(-Math.toRadians(this.roll), this.CENTER.getX(), this.CENTER.getY());
        G2.translate(0.0, -(this.pitch * this.pitchPixel) - this.getFramelessOffset().getY());
        G2.drawImage((Image)this.horizonImage, 0, (int)((double)(this.getHeight() - this.horizonImage.getHeight()) / 2.0), null);
        G2.translate(-this.getFramelessOffset().getX(), this.pitch * this.pitchPixel + this.getFramelessOffset().getY());
        G2.drawImage((Image)this.horizonForegroundImage, (int)((double)this.getWidth() * 0.5 - (double)this.horizonForegroundImage.getWidth() / 2.0), (int)((double)this.getWidth() * 0.10747663551401869), null);
        G2.setTransform(OLD_TRANSFORM);
        G2.setClip(OLD_CLIP);
        G2.drawImage((Image)this.bImage, 0, 0, null);
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.dispose();
    }

    public double getRoll() {
        return this.roll;
    }

    public void setRoll(double ROLL) {
        this.oldRoll = this.roll = ROLL % 360.0;
        this.fireStateChanged();
        this.repaint();
    }

    public void setRollAnimated(double ROLL) {
        if (this.isEnabled()) {
            if (this.timelineRoll.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timelineRoll.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timelineRoll.abort();
            }
            this.timelineRoll = new Timeline(this);
            this.timelineRoll.addPropertyToInterpolate("roll", this.oldRoll, ROLL);
            this.timelineRoll.setEase(new Spline(0.5f));
            this.timelineRoll.setDuration(800L);
            this.timelineRoll.play();
        }
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double PITCH) {
        this.pitch = PITCH % 180.0;
        if (this.pitch > 90.0) {
            this.pitch = 90.0 - (this.pitch - 90.0);
            if (!this.upsidedown) {
                this.setRoll(this.roll - 180.0);
            }
            this.upsidedown = true;
        } else if (this.pitch < -90.0) {
            this.pitch = -90.0 + (-90.0 - this.pitch);
            if (!this.upsidedown) {
                this.setRoll(this.roll + 180.0);
            }
            this.upsidedown = true;
        } else {
            this.upsidedown = false;
            this.oldPitch = this.pitch;
        }
        this.fireStateChanged();
        this.repaint();
    }

    public void setPitchAnimated(double PITCH) {
        if (this.isEnabled()) {
            if (this.timelinePitch.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timelinePitch.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timelinePitch.abort();
            }
            this.timelinePitch = new Timeline(this);
            this.timelinePitch.addPropertyToInterpolate("pitch", this.oldPitch, PITCH);
            this.timelinePitch.setEase(new Spline(0.5f));
            this.timelinePitch.setDuration(800L);
            this.timelinePitch.play();
        }
    }

    public boolean isCustomColors() {
        return this.customColors;
    }

    public void setCustomColors(boolean CUSTOM_COLORS) {
        this.customColors = CUSTOM_COLORS;
        if (this.customColors) {
            this.init(this.getInnerBounds().width, this.getInnerBounds().height);
            this.repaint(this.getInnerBounds());
        }
    }

    public Color getCustomSkyColor() {
        return this.customSkyColor;
    }

    public void setCustomSkyColor(Color CUSTOM_SKY_COLOR) {
        this.customSkyColor = CUSTOM_SKY_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomGroundColor() {
        return this.customGroundColor;
    }

    public void setCustomGroundColor(Color CUSTOM_GROUND_COLOR) {
        this.customGroundColor = CUSTOM_GROUND_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setFrameType(FrameType FRAME_TYPE) {
        super.setFrameType(FrameType.ROUND);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_HORIZON_Image(int WIDTH) {
        TextLayout valueLayout;
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        int HORIZON_HEIGHT = (int)(Math.PI * (double)WIDTH);
        BufferedImage IMAGE = UTIL.createImage(WIDTH, HORIZON_HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Rectangle2D.Double HORIZON = new Rectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, HORIZON_HEIGHT);
        Point2D.Double HORIZON_START = new Point2D.Double(0.0, ((Rectangle2D)HORIZON).getBounds2D().getMinY());
        Point2D.Double HORIZON_STOP = new Point2D.Double(0.0, ((Rectangle2D)HORIZON).getBounds2D().getMaxY());
        float[] HORIZON_FRACTIONS = new float[]{0.0f, 0.49999f, 0.5f, 1.0f};
        Color[] HORIZON_COLORS = this.customColors ? new Color[]{this.customSkyColor, this.customSkyColor, this.customGroundColor, this.customGroundColor} : new Color[]{new Color(127, 213, 240, 255), new Color(127, 213, 240, 255), new Color(60, 68, 57, 255), new Color(60, 68, 57, 255)};
        LinearGradientPaint HORIZON_GRADIENT = new LinearGradientPaint(HORIZON_START, HORIZON_STOP, HORIZON_FRACTIONS, HORIZON_COLORS);
        G2.setPaint(HORIZON_GRADIENT);
        G2.fill(HORIZON);
        G2.setColor(UTIL.setBrightness(HORIZON_COLORS[0], 0.5f));
        Line2D.Double LINE = new Line2D.Double();
        double STEPSIZE_Y = (double)HORIZON_HEIGHT / 360.0 * 5.0;
        boolean stepTen = false;
        int step = 0;
        G2.setFont(new Font("Verdana", 0, (int)((double)WIDTH * 0.04)));
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        Rectangle2D.Double VALUE_BOUNDARY = new Rectangle2D.Double();
        for (double y = (double)IMAGE_HEIGHT / 2.0 - STEPSIZE_Y; y > 0.0; y -= STEPSIZE_Y) {
            if (step <= 80) {
                if (stepTen) {
                    ((Line2D)LINE).setLine(((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.2) / 2.0, y, (double)IMAGE_WIDTH - ((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.2) / 2.0, y);
                    valueLayout = new TextLayout(Integer.toString(step += 10), G2.getFont(), RENDER_CONTEXT);
                    VALUE_BOUNDARY.setFrame(valueLayout.getBounds());
                    G2.drawString(Integer.toString(step), (float)(((Line2D)LINE).getX1() - ((RectangularShape)VALUE_BOUNDARY).getWidth() - 5.0), (float)(y + ((RectangularShape)VALUE_BOUNDARY).getHeight() / 2.0));
                    G2.drawString(Integer.toString(step), (float)(((Line2D)LINE).getX2() + 5.0), (float)(y + ((RectangularShape)VALUE_BOUNDARY).getHeight() / 2.0));
                } else {
                    ((Line2D)LINE).setLine(((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.1) / 2.0, y, (double)IMAGE_WIDTH - ((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.1) / 2.0, y);
                }
                G2.draw(LINE);
            }
            stepTen ^= true;
        }
        stepTen = false;
        step = 0;
        G2.setColor(Color.WHITE);
        Stroke FORMER_STROKE = G2.getStroke();
        G2.setStroke(new BasicStroke(1.5f));
        ((Line2D)LINE).setLine(0.0, (double)IMAGE_HEIGHT / 2.0, IMAGE_WIDTH, (double)IMAGE_HEIGHT / 2.0);
        G2.draw(LINE);
        G2.setStroke(FORMER_STROKE);
        for (double y = (double)IMAGE_HEIGHT / 2.0 + STEPSIZE_Y; y <= (double)IMAGE_HEIGHT; y += STEPSIZE_Y) {
            if (step >= -80) {
                if (stepTen) {
                    ((Line2D)LINE).setLine(((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.2) / 2.0, y, (double)IMAGE_WIDTH - ((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.2) / 2.0, y);
                    valueLayout = new TextLayout(Integer.toString(step -= 10), G2.getFont(), RENDER_CONTEXT);
                    VALUE_BOUNDARY.setFrame(valueLayout.getBounds());
                    G2.drawString(Integer.toString(step), (float)(((Line2D)LINE).getX1() - ((RectangularShape)VALUE_BOUNDARY).getWidth() - 5.0), (float)(y + ((RectangularShape)VALUE_BOUNDARY).getHeight() / 2.0));
                    G2.drawString(Integer.toString(step), (float)(((Line2D)LINE).getX2() + 5.0), (float)(y + ((RectangularShape)VALUE_BOUNDARY).getHeight() / 2.0));
                } else {
                    ((Line2D)LINE).setLine(((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.1) / 2.0, y, (double)IMAGE_WIDTH - ((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.1) / 2.0, y);
                }
                G2.draw(LINE);
            }
            stepTen ^= true;
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_INDICATOR_Image(int WIDTH, BufferedImage image) {
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        Point2D.Double LOCAL_CENTER = new Point2D.Double((double)IMAGE_WIDTH / 2.0, (double)IMAGE_HEIGHT / 2.0);
        G2.setFont(new Font("Verdana", 0, (int)((double)IMAGE_WIDTH * 0.035)));
        Line2D.Double SCALE_MARK_SMALL = new Line2D.Double((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.08878504672897196, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.0937850467);
        Line2D.Double SCALE_MARK = new Line2D.Double((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.08878504672897196, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1037850467);
        Line2D.Double SCALE_MARK_BIG = new Line2D.Double((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.08878504672897196, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.113);
        BasicStroke SMALL_STROKE = new BasicStroke(0.5f, 1, 1);
        BasicStroke STROKE = new BasicStroke(1.0f, 1, 1);
        BasicStroke BIG_STROKE = new BasicStroke(2.0f, 1, 1);
        int STEP = 5;
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.rotate(-1.5707963267948966, ((Point2D)LOCAL_CENTER).getX(), ((Point2D)LOCAL_CENTER).getY());
        for (int angle = -90; angle <= 90; angle += 5) {
            if (angle % 45 == 0 || angle == 0) {
                G2.setColor(this.getPointerColor().MEDIUM);
                G2.setStroke(BIG_STROKE);
                G2.draw(SCALE_MARK_BIG);
            } else if (angle % 15 == 0) {
                G2.setColor(Color.WHITE);
                G2.setStroke(STROKE);
                G2.draw(SCALE_MARK);
            } else {
                G2.setColor(Color.WHITE);
                G2.setStroke(SMALL_STROKE);
                G2.draw(SCALE_MARK_SMALL);
            }
            G2.rotate(Math.toRadians(5.0), ((Point2D)LOCAL_CENTER).getX(), ((Point2D)LOCAL_CENTER).getY());
        }
        G2.setTransform(OLD_TRANSFORM);
        GeneralPath CENTER_PLANE = new GeneralPath();
        CENTER_PLANE.setWindingRule(0);
        CENTER_PLANE.moveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5233644859813084);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4766355140186916);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5);
        CENTER_PLANE.closePath();
        CENTER_PLANE.moveTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5046728971962616);
        CENTER_PLANE.lineTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.4953271028037383);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.4953271028037383);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4672897196261682);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4158878504672897);
        CENTER_PLANE.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4158878504672897);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4672897196261682);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4953271028037383);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.4953271028037383);
        CENTER_PLANE.lineTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.5046728971962616);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5046728971962616);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5046728971962616);
        CENTER_PLANE.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5046728971962616);
        CENTER_PLANE.closePath();
        G2.setPaint(this.getPointerColor().LIGHT);
        G2.fill(CENTER_PLANE);
        G2.dispose();
        return image;
    }

    private BufferedImage create_HORIZON_FOREGROUND_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = UTIL.createImage((int)((double)WIDTH * 0.0373831776), (int)((double)WIDTH * 0.0560747664), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath TRIANGLE = new GeneralPath();
        TRIANGLE.setWindingRule(0);
        TRIANGLE.moveTo((double)IMAGE_WIDTH * 0.5, 0.0);
        TRIANGLE.lineTo(0.0f, IMAGE_HEIGHT);
        TRIANGLE.lineTo(IMAGE_WIDTH, IMAGE_HEIGHT);
        TRIANGLE.closePath();
        G2.setColor(this.getPointerColor().LIGHT);
        G2.fill(TRIANGLE);
        G2.setColor(this.getPointerColor().MEDIUM);
        G2.draw(TRIANGLE);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "Horizon";
    }
}

