/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.Section;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public class WindDirection
extends AbstractRadial {
    private double visibleValue = 0.0;
    private double angleStep;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage pointerImage;
    private BufferedImage pointer2Image;
    private BufferedImage disabledImage;
    private ColorDef pointer2Color = ColorDef.BLUE;
    private CustomColorDef customPointer2Color = new CustomColorDef(Color.BLUE);
    private PointerType pointer2Type = PointerType.TYPE3;
    private boolean pointer2Visible;
    private double value2;
    private Timeline timeline = new Timeline(this);
    private final Spline EASE = new Spline(0.5f);
    private long easingDuration = 250L;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public WindDirection() {
        this.setMinValue(-360.0);
        this.setMaxValue(360.0);
        this.setPointerType(PointerType.TYPE5);
        this.setLcdColor(LcdColor.BLACK_LCD);
        this.setValueCoupled(false);
        this.setLcdDecimals(1);
        this.setLcdVisible(true);
        this.calcAngleStep();
        this.value2 = 0.0;
        this.pointer2Visible = true;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.isDigitalFont()) {
            this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)GAUGE_WIDTH * 0.15f));
        } else {
            this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)GAUGE_WIDTH * 0.15f));
        }
        if (this.isCustomLcdUnitFontEnabled()) {
            this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)GAUGE_WIDTH * 0.15f));
        } else {
            this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)GAUGE_WIDTH * 0.15f));
        }
        this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)GAUGE_WIDTH * 0.15f));
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(GAUGE_WIDTH, GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(GAUGE_WIDTH, "", "", this.bImage);
        }
        this.create_SHIP_Image(GAUGE_WIDTH, this.bImage);
        this.create_TITLE_Image(GAUGE_WIDTH, this.getTitle(), this.getUnitString(), this.bImage);
        if (!this.getSections().isEmpty()) {
            this.createSections(this.bImage);
        }
        this.create_TICKMARKS_Image(GAUGE_WIDTH, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0, true, true, null, this.bImage);
        this.createLcdImage(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)GAUGE_WIDTH * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)GAUGE_WIDTH * 0.4, (double)GAUGE_WIDTH * 0.15), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
        this.LCD.setRect(((double)this.getGaugeBounds().width - (double)GAUGE_WIDTH * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)GAUGE_WIDTH * 0.4, (double)GAUGE_WIDTH * 0.15);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(GAUGE_WIDTH, this.getPointerType());
        if (this.pointer2Image != null) {
            this.pointer2Image.flush();
        }
        this.pointer2Image = this.create_POINTER_Image(GAUGE_WIDTH, this.pointer2Type, this.pointer2Color, this.customPointer2Color);
        this.createPostsImage(GAUGE_WIDTH, this.fImage, PostPosition.CENTER);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(GAUGE_WIDTH, GAUGE_WIDTH, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(GAUGE_WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterX());
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isLcdVisible()) {
            double UNIT_STRING_WIDTH;
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                G2.setColor(this.getCustomLcdForeground());
            } else {
                G2.setColor(this.getLcdColor().TEXT_COLOR);
            }
            G2.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), G2.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                G2.drawString(this.getLcdUnitString(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)(this.LCD.getY() + this.LCD.getHeight() * (double)0.76f));
                UNIT_STRING_WIDTH = this.UNIT_BOUNDARY.getWidth();
            } else {
                UNIT_STRING_WIDTH = 0.0;
            }
            G2.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (int)(this.LCD.getX() + (this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * (double)0.76f));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toOctalString((int)this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * (double)0.76f));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(this.formatLcdValue(this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * (double)0.76f));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                G2.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), G2.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                G2.drawString(this.getLcdInfoString(), this.LCD.getBounds().x + 5, this.LCD.getBounds().y + (int)this.INFO_BOUNDARY.getHeight() + 5);
            }
        }
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.rotate(this.value2 * this.angleStep, this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.pointer2Image, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(this.getValue() * this.angleStep, this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.pointerImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    @Override
    public void setValue(double VALUE) {
        if (this.isEnabled()) {
            super.setValue(VALUE % 360.0);
            if (VALUE % 360.0 == 0.0) {
                this.visibleValue = 90.0;
            }
            if (VALUE % 360.0 > 0.0 && VALUE % 360.0 <= 180.0) {
                this.visibleValue = VALUE % 360.0;
            }
            if (VALUE % 360.0 > 180.0 && VALUE % 360.0 <= 360.0) {
                this.visibleValue = 360.0 - VALUE % 360.0;
            }
            if (this.isValueCoupled()) {
                this.setLcdValue(this.visibleValue);
            }
            this.fireStateChanged();
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public void setValueAnimated(double value) {
        if (this.isEnabled()) {
            if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline(this);
            this.timeline.addPropertyToInterpolate("value", this.getValue(), value);
            this.timeline.setEase(this.EASE);
            this.timeline.setDuration(this.easingDuration);
            this.timeline.play();
        }
    }

    @Override
    public double getMinValue() {
        return -360.0;
    }

    @Override
    public double getMaxValue() {
        return 360.0;
    }

    public long getEasingDuration() {
        return this.easingDuration;
    }

    public void setEasingDuration(long EASING_DURATION) {
        this.easingDuration = EASING_DURATION;
    }

    public ColorDef getPointer2Color() {
        return this.pointer2Color;
    }

    public void setPointer2Color(ColorDef POINTER2_COLOR) {
        this.pointer2Color = POINTER2_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public double getValue2() {
        return this.value2;
    }

    public void setValue2(double VALUE2) {
        if (this.isEnabled()) {
            this.value2 = VALUE2 % 360.0;
            this.fireStateChanged();
            this.repaint(this.getInnerBounds());
        }
    }

    public boolean isPointer2Visible() {
        return this.pointer2Visible;
    }

    public void setPointer2Visible(boolean POINTER2_VISIBLE) {
        this.pointer2Visible = POINTER2_VISIBLE;
        this.repaint(this.getInnerBounds());
    }

    public PointerType getPointer2Type() {
        return this.pointer2Type;
    }

    public void setPointer2Type(PointerType POINTER2_TYPE) {
        this.pointer2Type = POINTER2_TYPE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomPointer2Color() {
        return this.customPointer2Color.COLOR;
    }

    public void setCustomPointer2Color(Color COLOR) {
        this.customPointer2Color = new CustomColorDef(COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomPointer2ColorObject() {
        return this.customPointer2Color;
    }

    private void calcAngleStep() {
        this.angleStep = Math.PI / 180;
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_STOP;
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (FOREGROUND_START.equals(FOREGROUND_STOP = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private void createSections(BufferedImage IMAGE) {
        if (this.bImage != null) {
            double ORIGIN_CORRECTION = 90.0;
            double ANGLE_STEP = 1.0;
            double OUTER_RADIUS = (float)this.bImage.getWidth() * 0.38f;
            double INNER_RADIUS = (float)this.bImage.getWidth() * 0.38f - (float)this.bImage.getWidth() * 0.04f;
            double FREE_AREA_OUTER_RADIUS = (double)this.bImage.getWidth() / 2.0 - OUTER_RADIUS;
            double FREE_AREA_INNER_RADIUS = (double)this.bImage.getWidth() / 2.0 - INNER_RADIUS;
            Ellipse2D.Double INNER = new Ellipse2D.Double((double)this.bImage.getMinX() + FREE_AREA_INNER_RADIUS, (double)this.bImage.getMinY() + FREE_AREA_INNER_RADIUS, 2.0 * INNER_RADIUS, 2.0 * INNER_RADIUS);
            for (Section section : this.getSections()) {
                double ANGLE_START = ORIGIN_CORRECTION - section.getStart() * ANGLE_STEP + this.getMinValue() * ANGLE_STEP;
                double ANGLE_EXTEND = -(section.getStop() - section.getStart()) * ANGLE_STEP;
                Arc2D.Double OUTER_ARC = new Arc2D.Double(2);
                OUTER_ARC.setFrame((double)this.bImage.getMinX() + FREE_AREA_OUTER_RADIUS, (double)this.bImage.getMinY() + FREE_AREA_OUTER_RADIUS, 2.0 * OUTER_RADIUS, 2.0 * OUTER_RADIUS);
                ((Arc2D)OUTER_ARC).setAngleStart(ANGLE_START);
                ((Arc2D)OUTER_ARC).setAngleExtent(ANGLE_EXTEND);
                Area SECTION = new Area(OUTER_ARC);
                SECTION.subtract(new Area(INNER));
                section.setSectionArea(SECTION);
            }
            if (this.isSectionsVisible() && IMAGE != null) {
                Graphics2D G2 = IMAGE.createGraphics();
                G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getSections()) {
                    G2.setColor(section.getColor());
                    G2.fill(section.getSectionArea());
                }
                G2.dispose();
            }
        }
    }

    protected BufferedImage create_TICKMARKS_Image(int WIDTH, double FREE_AREA_ANGLE, double OFFSET, double MIN_VALUE, double MAX_VALUE, double ANGLE_STEP, int TICK_LABEL_PERIOD, int SCALE_DIVIDER_POWER, boolean DRAW_TICKS, boolean DRAW_TICK_LABELS, ArrayList<Section> tickmarkSections, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, (int)(1.0 * (double)WIDTH), 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        Font STD_FONT = new Font("Verdana", 0, (int)(0.04 * (double)WIDTH));
        BasicStroke MEDIUM_STROKE = new BasicStroke(1.0f, 1, 2);
        BasicStroke THIN_STROKE = new BasicStroke(0.5f, 1, 2);
        int TEXT_DISTANCE = (int)(0.08 * (double)WIDTH);
        int MED_LENGTH = (int)(0.02 * (double)WIDTH);
        int MAX_LENGTH = (int)(0.04 * (double)WIDTH);
        float RADIUS = (float)IMAGE_WIDTH * 0.38f;
        Point2D.Double GAUGE_CENTER = new Point2D.Double((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_HEIGHT / 2.0f);
        Point2D.Double INNER_POINT = new Point2D.Double(0.0, 0.0);
        Point2D.Double OUTER_POINT = new Point2D.Double(0.0, 0.0);
        Point2D.Double TEXT_POINT = new Point2D.Double(0.0, 0.0);
        Line2D.Double TICK_LINE = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
        Ellipse2D.Double TICK_CIRCLE = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        int MINOR_DIAMETER = (int)(0.0186915888 * (double)WIDTH);
        int MAJOR_DIAMETER = (int)(0.03 * (double)WIDTH);
        int counter = 0;
        int tickCounter = 0;
        float valueCounter = 90.0f;
        boolean countUp = false;
        float valueStep = 1.0f;
        G2.setFont(STD_FONT);
        double sinValue = 0.0;
        double cosValue = 0.0;
        double STEP = Math.PI / 180;
        for (double alpha = Math.PI * 2; alpha >= Math.PI / 180; alpha -= Math.PI / 180) {
            G2.setStroke(THIN_STROKE);
            sinValue = Math.sin(alpha - 1.5707963267948966);
            cosValue = Math.cos(alpha - 1.5707963267948966);
            if (counter % 5 == 0) {
                G2.setColor(super.getBackgroundColor().LABEL_COLOR);
                G2.setStroke(THIN_STROKE);
                ((Point2D)INNER_POINT).setLocation(((Point2D)GAUGE_CENTER).getX() + (double)(RADIUS - (float)MED_LENGTH) * sinValue, ((Point2D)GAUGE_CENTER).getY() + (double)(RADIUS - (float)MED_LENGTH) * cosValue);
                ((Point2D)OUTER_POINT).setLocation(((Point2D)GAUGE_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)GAUGE_CENTER).getY() + (double)RADIUS * cosValue);
                switch (this.getMinorTickmarkType()) {
                    case LINE: {
                        TICK_LINE.setLine(INNER_POINT, OUTER_POINT);
                        G2.draw(TICK_LINE);
                        break;
                    }
                    case CIRCLE: {
                        ((RectangularShape)TICK_CIRCLE).setFrame(((Point2D)OUTER_POINT).getX() - (double)MINOR_DIAMETER / 2.0, ((Point2D)OUTER_POINT).getY() - (double)MINOR_DIAMETER / 2.0, MINOR_DIAMETER, MINOR_DIAMETER);
                        G2.fill(TICK_CIRCLE);
                        break;
                    }
                    default: {
                        TICK_LINE.setLine(INNER_POINT, OUTER_POINT);
                        G2.draw(TICK_LINE);
                    }
                }
            }
            if (counter == 30 || counter == 0) {
                G2.setColor(super.getBackgroundColor().LABEL_COLOR);
                G2.setStroke(MEDIUM_STROKE);
                ((Point2D)INNER_POINT).setLocation(((Point2D)GAUGE_CENTER).getX() + (double)(RADIUS - (float)MAX_LENGTH) * sinValue, ((Point2D)GAUGE_CENTER).getY() + (double)(RADIUS - (float)MAX_LENGTH) * cosValue);
                ((Point2D)OUTER_POINT).setLocation(((Point2D)GAUGE_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)GAUGE_CENTER).getY() + (double)RADIUS * cosValue);
                ((Point2D)TEXT_POINT).setLocation(((Point2D)GAUGE_CENTER).getX() + (double)(RADIUS - (float)TEXT_DISTANCE) * sinValue, ((Point2D)GAUGE_CENTER).getY() + (double)(RADIUS - (float)TEXT_DISTANCE) * cosValue);
                G2.setFont(STD_FONT);
                G2.fill(UTIL.rotateTextAroundCenter(G2, String.valueOf((int)valueCounter), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), 0.0));
                counter = 0;
                ++tickCounter;
                switch (this.getMajorTickmarkType()) {
                    case LINE: {
                        TICK_LINE.setLine(INNER_POINT, OUTER_POINT);
                        G2.draw(TICK_LINE);
                        break;
                    }
                    case CIRCLE: {
                        ((RectangularShape)TICK_CIRCLE).setFrame(((Point2D)OUTER_POINT).getX() - (double)MAJOR_DIAMETER / 2.0, ((Point2D)OUTER_POINT).getY() - (double)MAJOR_DIAMETER / 2.0, MAJOR_DIAMETER, MAJOR_DIAMETER);
                        G2.fill(TICK_CIRCLE);
                        break;
                    }
                    default: {
                        TICK_LINE.setLine(INNER_POINT, OUTER_POINT);
                        G2.draw(TICK_LINE);
                    }
                }
            }
            ++counter;
            if (valueCounter == 0.0f) {
                countUp = true;
            }
            if (valueCounter == 180.0f) {
                countUp = false;
            }
            if (countUp) {
                valueCounter += valueStep;
                continue;
            }
            valueCounter -= valueStep;
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_SHIP_Image(int WIDTH, BufferedImage image) {
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        GeneralPath SHIP = new GeneralPath();
        SHIP.setWindingRule(0);
        SHIP.moveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.7242990654205608);
        SHIP.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.7383177570093458, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7383177570093458);
        SHIP.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.7383177570093458, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.7242990654205608);
        SHIP.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.6962616822429907, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.48598130841121495);
        SHIP.curveTo((double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.2336448598130841, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.2336448598130841);
        SHIP.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.2336448598130841, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.48598130841121495);
        SHIP.curveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.719626168224299, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.7242990654205608);
        SHIP.closePath();
        G2.setColor(this.getBackgroundColor().LABEL_COLOR);
        G2.setStroke(new BasicStroke(1.0f, 0, 0));
        G2.draw(SHIP);
        G2.dispose();
        return image;
    }

    @Override
    public String toString() {
        return "WindDirection";
    }
}

