/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Section;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Linear
extends AbstractLinear {
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage lcdThresholdImage;
    private BufferedImage disabledImage;
    private final Rectangle2D VALUE_BACKGROUND_TRACK;
    private final Point2D VALUE_BACKGROUND_START;
    private final Point2D VALUE_BACKGROUND_STOP;
    private final float[] VALUE_BACKGROUND_TRACK_FRACTIONS;
    private final Rectangle2D VALUE_LEFT_BORDER;
    private final Rectangle2D VALUE_RIGHT_BORDER;
    private final Point2D VALUE_BORDER_START;
    private final Point2D VALUE_BORDER_STOP;
    private final float[] VALUE_BORDER_FRACTIONS;
    private final Rectangle2D VALUE_BACKGROUND;
    private final Point2D VALUE_START;
    private final Point2D VALUE_STOP;
    private static final int BASE = 10;
    private final Rectangle2D VALUE_FOREGROUND;
    private final Point2D VALUE_FOREGROUND_START;
    private final Point2D VALUE_FOREGROUND_STOP;
    private final float[] VALUE_FOREGROUND_FRACTIONS;
    private final Color[] VALUE_FOREGROUND_COLORS;
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private double unitStringWidth;
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public Linear() {
        this.VALUE_BACKGROUND_TRACK = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BACKGROUND_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_TRACK_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_LEFT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_RIGHT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BORDER_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_BACKGROUND = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_FOREGROUND_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
        this.VALUE_FOREGROUND_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.7f), new Color(1.0f, 1.0f, 1.0f, 0.05f)};
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Linear(Model MODEL) {
        this.setModel(MODEL);
        this.VALUE_BACKGROUND_TRACK = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BACKGROUND_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_TRACK_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_LEFT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_RIGHT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BORDER_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_BACKGROUND = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_FOREGROUND_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_FOREGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
        this.VALUE_FOREGROUND_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.7f), new Color(1.0f, 1.0f, 1.0f, 0.05f)};
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return this;
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(WIDTH, HEIGHT, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(WIDTH, HEIGHT, 3);
        if (this.isLcdVisible()) {
            float LCD_TEXT_HEIGHT_BASE = this.getOrientation() == Orientation.HORIZONTAL ? (float)HEIGHT * 0.15f : (float)HEIGHT * 0.055f;
            if (this.isDigitalFont()) {
                this.setLcdValueFont(LCD_DIGITAL_FONT.deriveFont(0.7f * LCD_TEXT_HEIGHT_BASE));
            } else {
                this.setLcdValueFont(LCD_STANDARD_FONT.deriveFont(0.625f * LCD_TEXT_HEIGHT_BASE));
            }
            if (this.isCustomLcdUnitFontEnabled()) {
                this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * LCD_TEXT_HEIGHT_BASE));
            } else {
                this.setLcdUnitFont(LCD_STANDARD_FONT.deriveFont(0.25f * LCD_TEXT_HEIGHT_BASE));
            }
            this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * LCD_TEXT_HEIGHT_BASE));
        }
        if (this.isFrameVisible()) {
            this.create_FRAME_Image(WIDTH, HEIGHT, this.bImage);
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(WIDTH, HEIGHT, this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(WIDTH, HEIGHT, this.getGlowColor(), false);
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(WIDTH, HEIGHT, this.getGlowColor(), true);
        } else {
            this.setGlowPulsating(false);
        }
        if (this.isTrackVisible()) {
            this.create_TRACK_Image(WIDTH, HEIGHT, this.getMinValue(), this.getMaxValue(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.bImage);
        }
        TICKMARK_FACTORY.create_LINEAR_TICKMARKS_Image(WIDTH, HEIGHT, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), new Point2D.Double(0.0, 0.0), this.getOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        if (this.isTitleVisible()) {
            this.create_TITLE_Image(WIDTH, HEIGHT, this.getModel().isUnitVisible(), this.bImage);
        }
        if (this.isLcdVisible()) {
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    if (this.isLcdBackgroundVisible()) {
                        this.create_LCD_Image(new Rectangle2D.Double((double)WIDTH * 0.695, (double)HEIGHT * 0.22, (double)WIDTH * 0.18, (double)HEIGHT * 0.15), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
                    }
                    this.LCD.setRect((double)WIDTH * 0.695, (double)HEIGHT * 0.22, (double)WIDTH * 0.18, (double)HEIGHT * 0.15);
                    break;
                }
                case VERTICAL: {
                    if (this.isLcdBackgroundVisible()) {
                        this.create_LCD_Image(new Rectangle2D.Double(((double)WIDTH - (double)WIDTH * 0.5714285714) / 2.0, (double)HEIGHT * 0.875, (double)WIDTH * 0.5714285714, (double)HEIGHT * 0.055), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
                    }
                    this.LCD.setRect(((double)WIDTH - (double)WIDTH * 0.5714285714) / 2.0, (double)HEIGHT * 0.875, (double)WIDTH * 0.5714285714, (double)HEIGHT * 0.055);
                }
            }
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        }
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(WIDTH, HEIGHT);
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(WIDTH, HEIGHT, new Color(0, 23, 252, 255));
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(WIDTH, HEIGHT, new Color(252, 29, 0, 255));
        if (this.isForegroundVisible()) {
            FOREGROUND_FACTORY.createLinearForeground(WIDTH, HEIGHT, false, this.fImage);
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(WIDTH, HEIGHT);
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        double VALUE_POS;
        AffineTransform OLD_TRANSFORM;
        double PIXEL_SCALE;
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (!this.isFrameVisible()) {
            G2.translate(this.getInnerBounds().x - 17, this.getInnerBounds().y - 17);
        } else {
            G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        }
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.getInnerBounds().width < this.getInnerBounds().height) {
            double PIXEL_RANGE = (double)this.getInnerBounds().height * 0.8567961165048543 - (double)this.getInnerBounds().height * 0.12864077669902912;
            double RANGE = this.getMaxValue() - this.getMinValue();
            PIXEL_SCALE = PIXEL_RANGE / RANGE;
        } else {
            double PIXEL_RANGE = (double)this.getInnerBounds().width * 0.8567961165048543 - (double)this.getInnerBounds().width * 0.12864077669902912;
            double RANGE = this.getMaxValue() - this.getMinValue();
            PIXEL_SCALE = PIXEL_RANGE / RANGE;
        }
        if (this.isThresholdVisible()) {
            OLD_TRANSFORM = G2.getTransform();
            if (this.getInnerBounds().width < this.getInnerBounds().height) {
                VALUE_POS = this.getMinValue() < 0.0 ? (double)this.getInnerBounds().height * 0.8567961165048543 + this.getMinValue() * PIXEL_SCALE - this.getThreshold() * PIXEL_SCALE : (double)this.getInnerBounds().height * 0.8567961165048543 - this.getMinValue() * PIXEL_SCALE - this.getThreshold() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.4357142857142857 - (double)this.thresholdImage.getWidth() - 2.0 + (double)this.getInnerBounds().x, VALUE_POS - (double)this.thresholdImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
            } else {
                VALUE_POS = this.getThreshold() * PIXEL_SCALE - this.getMinValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.14285714285714285 - (double)this.thresholdImage.getWidth() / 2.0 + VALUE_POS + (double)this.getInnerBounds().x, (double)this.getInnerBounds().height * 0.5714285714 + 2.0 + (double)this.getInnerBounds().y);
            }
            G2.drawImage((Image)this.thresholdImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMinMeasuredValueVisible()) {
            OLD_TRANSFORM = G2.getTransform();
            if (this.getInnerBounds().width < this.getInnerBounds().height) {
                VALUE_POS = this.getMinValue() < 0.0 ? (double)this.getInnerBounds().height * 0.8567961165048543 + this.getMinValue() * PIXEL_SCALE - this.getMinMeasuredValue() * PIXEL_SCALE : (double)this.getInnerBounds().height * 0.8567961165048543 - this.getMinValue() * PIXEL_SCALE - this.getMinMeasuredValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.37 - (double)this.minMeasuredImage.getWidth() - 2.0 + (double)this.getInnerBounds().x, VALUE_POS - (double)this.minMeasuredImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
            } else {
                VALUE_POS = this.getMinMeasuredValue() * PIXEL_SCALE - this.getMinValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.14285714285714285 - (double)this.minMeasuredImage.getWidth() / 2.0 + VALUE_POS + (double)this.getInnerBounds().x, (double)this.getInnerBounds().height * 0.63 + 2.0 + (double)this.getInnerBounds().y);
            }
            G2.drawImage((Image)this.minMeasuredImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMaxMeasuredValueVisible()) {
            OLD_TRANSFORM = G2.getTransform();
            if (this.getInnerBounds().width < this.getInnerBounds().height) {
                VALUE_POS = this.getMinValue() < 0.0 ? (double)this.getInnerBounds().height * 0.8567961165048543 + this.getMinValue() * PIXEL_SCALE - this.getMaxMeasuredValue() * PIXEL_SCALE : (double)this.getInnerBounds().height * 0.8567961165048543 - this.getMinValue() * PIXEL_SCALE - this.getMaxMeasuredValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.37 - (double)this.maxMeasuredImage.getWidth() - 2.0 + (double)this.getInnerBounds().x, VALUE_POS - (double)this.maxMeasuredImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
            } else {
                VALUE_POS = this.getMaxMeasuredValue() * PIXEL_SCALE - this.getMinValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.14285714285714285 - (double)this.maxMeasuredImage.getWidth() / 2.0 + VALUE_POS + (double)this.getInnerBounds().x, (double)this.getInnerBounds().height * 0.63 + 2.0 + (double)this.getInnerBounds().y);
            }
            G2.drawImage((Image)this.maxMeasuredImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isLedVisible()) {
            G2.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getInnerBounds().width * this.getLedPosition().getX()), (int)((double)this.getInnerBounds().height * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            G2.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getInnerBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getInnerBounds().height * this.getUserLedPosition().getY()), null);
        }
        if (this.isLcdVisible()) {
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                G2.setColor(this.getCustomLcdForeground());
            } else {
                G2.setColor(this.getLcdColor().TEXT_COLOR);
            }
            G2.setFont(this.getLcdUnitFont());
            if (this.isLcdTextVisible()) {
                if (this.isLcdUnitStringVisible()) {
                    this.unitLayout = new TextLayout(this.getLcdUnitString(), G2.getFont(), this.RENDER_CONTEXT);
                    this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                    G2.drawString(this.getLcdUnitString(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    this.unitStringWidth = this.UNIT_BOUNDARY.getWidth();
                } else {
                    this.unitStringWidth = 0.0;
                }
                G2.setFont(this.getLcdValueFont());
                switch (this.getModel().getNumberSystem()) {
                    case HEX: {
                        this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                        this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                        G2.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                        break;
                    }
                    case OCT: {
                        this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                        this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                        G2.drawString(Integer.toOctalString((int)this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                        break;
                    }
                    default: {
                        this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                        this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                        G2.drawString(this.formatLcdValue(this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    }
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                G2.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), G2.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                G2.drawString(this.getLcdInfoString(), (float)this.LCD.getBounds().x + 5.0f, (float)this.LCD.getBounds().y + (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
            }
            if (this.getLcdNumberSystem() == NumberSystem.DEC && this.isLcdThresholdVisible() && this.getLcdValue() >= this.getLcdThreshold()) {
                G2.drawImage((Image)this.lcdThresholdImage, (int)(this.LCD.getX() + this.LCD.getHeight() * 0.0568181818), (int)(this.LCD.getY() + this.LCD.getHeight() - (double)this.lcdThresholdImage.getHeight() - this.LCD.getHeight() * 0.0568181818), null);
            }
        }
        this.drawValue(G2, this.getInnerBounds().width, this.getInnerBounds().height, PIXEL_SCALE);
        if (this.isForegroundVisible()) {
            G2.drawImage((Image)this.fImage, 0, 0, null);
        }
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                G2.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                G2.drawImage((Image)this.glowImageOn, 0, 0, null);
                G2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                G2.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.dispose();
    }

    private void drawValue(Graphics2D G2, int WIDTH, int HEIGHT, double PIXEL_SCALE) {
        double SIZE_FACTOR;
        double START_OF_VALUE;
        double VALUE_SIZE;
        double FULL_SIZE;
        double MIN_POS_OF_BAR;
        double MAX_POS_OF_BAR;
        boolean VERTICAL;
        boolean bl = VERTICAL = WIDTH < HEIGHT;
        if (VERTICAL) {
            MAX_POS_OF_BAR = (double)HEIGHT * 0.12864077669902912;
            MIN_POS_OF_BAR = (double)HEIGHT * 0.8567961165048543;
            FULL_SIZE = MIN_POS_OF_BAR - MAX_POS_OF_BAR;
            if (this.isStartingFromZero()) {
                VALUE_SIZE = FULL_SIZE * Math.abs(this.getValue()) / (this.getMaxValue() - this.getMinValue());
                START_OF_VALUE = this.getValue() < 0.0 ? -this.getMinValue() * PIXEL_SCALE + MIN_POS_OF_BAR + this.getValue() * PIXEL_SCALE : -this.getMinValue() * PIXEL_SCALE + MIN_POS_OF_BAR;
            } else if (this.isLogScale()) {
                SIZE_FACTOR = Math.abs(MAX_POS_OF_BAR - MIN_POS_OF_BAR) / UTIL.logOfBase(10.0, this.getMaxValue());
                VALUE_SIZE = SIZE_FACTOR * UTIL.logOfBase(10.0, this.getValue());
                START_OF_VALUE = MAX_POS_OF_BAR + FULL_SIZE - VALUE_SIZE;
            } else {
                VALUE_SIZE = FULL_SIZE * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
                START_OF_VALUE = MAX_POS_OF_BAR + FULL_SIZE - VALUE_SIZE;
            }
            this.VALUE_BACKGROUND_TRACK.setRect((double)WIDTH * 0.4357142857142857, MAX_POS_OF_BAR, (double)WIDTH * 0.14285714285714285, FULL_SIZE);
            this.VALUE_BACKGROUND_START.setLocation(0.0, this.VALUE_BACKGROUND_TRACK.getBounds2D().getMinY());
            this.VALUE_BACKGROUND_STOP.setLocation(0.0, this.VALUE_BACKGROUND_TRACK.getBounds2D().getMaxY());
        } else {
            MAX_POS_OF_BAR = (double)WIDTH * 0.8567961165048543;
            MIN_POS_OF_BAR = (double)WIDTH * 0.14285714285714285;
            FULL_SIZE = MAX_POS_OF_BAR - (double)WIDTH * 0.12864077669902912;
            if (this.isStartingFromZero()) {
                VALUE_SIZE = FULL_SIZE * Math.abs(this.getValue()) / (this.getMaxValue() - this.getMinValue());
                START_OF_VALUE = this.getValue() < 0.0 ? -this.getMinValue() * PIXEL_SCALE + MIN_POS_OF_BAR + this.getValue() * PIXEL_SCALE : -this.getMinValue() * PIXEL_SCALE + MIN_POS_OF_BAR;
            } else if (this.isLogScale()) {
                SIZE_FACTOR = FULL_SIZE / UTIL.logOfBase(10.0, this.getMaxValue());
                VALUE_SIZE = SIZE_FACTOR * UTIL.logOfBase(10.0, this.getValue());
                START_OF_VALUE = MIN_POS_OF_BAR;
            } else {
                VALUE_SIZE = FULL_SIZE * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
                START_OF_VALUE = MIN_POS_OF_BAR;
            }
            this.VALUE_BACKGROUND_TRACK.setRect((double)WIDTH * 0.14285714285714285, (double)HEIGHT * 0.4357142857142857, FULL_SIZE, (double)HEIGHT * 0.14285714285714285);
            this.VALUE_BACKGROUND_START.setLocation(MAX_POS_OF_BAR, 0.0);
            this.VALUE_BACKGROUND_STOP.setLocation(MIN_POS_OF_BAR, 0.0);
        }
        Color[] VALUE_BACKGROUND_TRACK_COLORS = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.047058824f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.14509805f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.14901961f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.047058824f)};
        LinearGradientPaint VALUE_BACKGROUND_TRACK_GRADIENT = new LinearGradientPaint(this.VALUE_BACKGROUND_START, this.VALUE_BACKGROUND_STOP, this.VALUE_BACKGROUND_TRACK_FRACTIONS, VALUE_BACKGROUND_TRACK_COLORS);
        G2.setPaint(VALUE_BACKGROUND_TRACK_GRADIENT);
        G2.fill(this.VALUE_BACKGROUND_TRACK);
        if (VERTICAL) {
            this.VALUE_LEFT_BORDER.setRect((double)WIDTH * 0.4357142857142857, MAX_POS_OF_BAR, (double)WIDTH * 0.007142857142857143, FULL_SIZE);
            this.VALUE_RIGHT_BORDER.setRect((double)WIDTH * 0.5714285714285714, MAX_POS_OF_BAR, (double)WIDTH * 0.007142857142857143, FULL_SIZE);
            this.VALUE_BORDER_START.setLocation(0.0, this.VALUE_LEFT_BORDER.getBounds2D().getMinY());
            this.VALUE_BORDER_STOP.setLocation(0.0, this.VALUE_LEFT_BORDER.getBounds2D().getMaxY());
        } else {
            this.VALUE_LEFT_BORDER.setRect((double)WIDTH * 0.14285714285714285, (double)HEIGHT * 0.4357142857, FULL_SIZE, (double)HEIGHT * 0.007142857142857143);
            this.VALUE_RIGHT_BORDER.setRect((double)WIDTH * 0.14285714285714285, (double)HEIGHT * 0.5714285714, FULL_SIZE, (double)HEIGHT * 0.007142857142857143);
            this.VALUE_BORDER_START.setLocation(this.VALUE_LEFT_BORDER.getBounds2D().getMaxX(), 0.0);
            this.VALUE_BORDER_STOP.setLocation(this.VALUE_LEFT_BORDER.getBounds2D().getMinX(), 0.0);
        }
        Color[] VALUE_BORDER_COLORS = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.29803923f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.6862745f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.69803923f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.4f)};
        LinearGradientPaint VALUE_BORDER_GRADIENT = new LinearGradientPaint(this.VALUE_BORDER_START, this.VALUE_BORDER_STOP, this.VALUE_BORDER_FRACTIONS, VALUE_BORDER_COLORS);
        G2.setPaint(VALUE_BORDER_GRADIENT);
        G2.fill(this.VALUE_LEFT_BORDER);
        G2.fill(this.VALUE_RIGHT_BORDER);
        if (VERTICAL) {
            this.VALUE_BACKGROUND.setRect((double)WIDTH * 0.45, START_OF_VALUE, (double)WIDTH * 0.1142857143, VALUE_SIZE);
            this.VALUE_START.setLocation(this.VALUE_BACKGROUND.getBounds2D().getMinX(), 0.0);
            this.VALUE_STOP.setLocation(this.VALUE_BACKGROUND.getBounds2D().getMaxX(), 0.0);
        } else {
            this.VALUE_BACKGROUND.setRect(START_OF_VALUE, (double)HEIGHT * 0.45, VALUE_SIZE, (double)HEIGHT * 0.1142857143);
            this.VALUE_START.setLocation(0.0, this.VALUE_BACKGROUND.getBounds2D().getMinY());
            this.VALUE_STOP.setLocation(0.0, this.VALUE_BACKGROUND.getBounds2D().getMaxY());
        }
        float[] VALUE_BACKGROUND_FRACTIONS = new float[]{0.0f, 0.99f, 1.0f};
        Color[] valueBackgroundColors = this.getValueColor() != ColorDef.CUSTOM ? new Color[]{this.getValueColor().MEDIUM, this.getValueColor().LIGHT, this.getValueColor().LIGHT} : new Color[]{this.getCustomValueColorObject().MEDIUM, this.getCustomValueColorObject().LIGHT, this.getCustomValueColorObject().LIGHT};
        if (this.isSectionsVisible()) {
            for (Section section : this.getSections()) {
                if (Double.compare(this.getValue(), section.getStart()) < 0 || Double.compare(this.getValue(), section.getStop()) > 0) continue;
                valueBackgroundColors = new Color[]{this.isTransparentSectionsEnabled() ? section.getTransparentColor() : section.getColor(), this.isTransparentSectionsEnabled() ? section.getTransparentColor() : section.getColor(), this.isTransparentSectionsEnabled() ? section.getTransparentColor() : section.getColor()};
                G2.setColor(section.getColor());
                break;
            }
        }
        LinearGradientPaint VALUE_BACKGROUND_GRADIENT = new LinearGradientPaint(this.VALUE_START, this.VALUE_STOP, VALUE_BACKGROUND_FRACTIONS, valueBackgroundColors);
        G2.setPaint(VALUE_BACKGROUND_GRADIENT);
        G2.fill(this.VALUE_BACKGROUND);
        if (VERTICAL) {
            this.VALUE_FOREGROUND.setRect((double)WIDTH * 0.45, START_OF_VALUE, (double)WIDTH * 0.05, VALUE_SIZE);
            this.VALUE_FOREGROUND_START.setLocation(this.VALUE_FOREGROUND.getBounds2D().getMinX(), 0.0);
            this.VALUE_FOREGROUND_STOP.setLocation(this.VALUE_FOREGROUND.getBounds2D().getMaxX(), 0.0);
        } else {
            this.VALUE_FOREGROUND.setRect(START_OF_VALUE, (double)HEIGHT * 0.45, VALUE_SIZE, (double)HEIGHT * 0.05);
            this.VALUE_FOREGROUND_START.setLocation(0.0, this.VALUE_FOREGROUND.getBounds2D().getMinY());
            this.VALUE_FOREGROUND_STOP.setLocation(0.0, this.VALUE_FOREGROUND.getBounds2D().getMaxY());
        }
        LinearGradientPaint VALUE_FOREGROUND_GRADIENT = new LinearGradientPaint(this.VALUE_FOREGROUND_START, this.VALUE_FOREGROUND_STOP, this.VALUE_FOREGROUND_FRACTIONS, this.VALUE_FOREGROUND_COLORS);
        G2.setPaint(VALUE_FOREGROUND_GRADIENT);
        if (this.VALUE_FOREGROUND.getWidth() > 0.0 && this.VALUE_FOREGROUND.getHeight() > 0.0) {
            G2.fill(this.VALUE_FOREGROUND);
        }
    }

    @Override
    public void setValue(double value) {
        if (this.isValueCoupled()) {
            this.setLcdValue(value);
        }
        super.setValue(value);
    }

    public boolean isTitleVisible() {
        return this.getModel().isTitleVisible();
    }

    public void setTitleVisible(boolean TITLE_VISIBLE) {
        this.getModel().setTitleVisible(TITLE_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isTickmarksVisible() {
        return this.getModel().isTickmarksVisible();
    }

    @Override
    public void setTickmarksVisible(boolean TICKMARKS_VISIBLE) {
        this.getModel().setTickmarksVisible(TICKMARKS_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isUnitStringVisible() {
        return this.getModel().isUnitVisible();
    }

    public void setUnitStringVisible(boolean UNIT_STRING_VISIBLE) {
        this.getModel().setUnitVisible(UNIT_STRING_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_STOP;
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (FOREGROUND_START.equals(FOREGROUND_STOP = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    protected Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    protected Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    @Override
    public String toString() {
        return "Linear";
    }
}

