/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.Color;

public class HsbColor {
    private final float mHue;
    private final float mSaturation;
    private final float mBrightness;
    private final Color mColor;

    private HsbColor(Builder builder) {
        this.mHue = builder.getHue();
        this.mSaturation = builder.getSaturation();
        this.mBrightness = builder.getBrightness();
        Color TMP_COLOR = new Color(Color.HSBtoRGB(this.mHue, this.mSaturation, this.mBrightness));
        this.mColor = new Color(TMP_COLOR.getRed(), TMP_COLOR.getGreen(), TMP_COLOR.getBlue(), builder.getAlpha());
    }

    public float getHue() {
        return this.mHue;
    }

    public float getSaturation() {
        return this.mSaturation;
    }

    public float getBrightness() {
        return this.mBrightness;
    }

    public Color getColor() {
        return this.mColor;
    }

    public static class Builder {
        private float hue = 0.0f;
        private float saturation = 0.0f;
        private float brightness = 0.0f;
        private int alpha = 255;

        public Builder(Color color) {
            float[] HSB_VALUES = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.hue = HSB_VALUES[0];
            this.saturation = HSB_VALUES[1];
            this.brightness = HSB_VALUES[2];
            this.alpha = color.getAlpha();
        }

        public Builder hue(float HUE) {
            this.hue = HUE < 0.0f ? 0.0f : (HUE > 1.0f ? 1.0f : HUE);
            return this;
        }

        public Builder relHue(float REL_HUE) {
            this.hue = this.hue + REL_HUE < 0.0f ? 0.0f : (this.hue + REL_HUE > 360.0f ? 360.0f : this.hue + REL_HUE);
            return this;
        }

        public float getHue() {
            return this.hue;
        }

        public Builder saturation(float SATURATION) {
            this.saturation = SATURATION < 0.0f ? 0.0f : (SATURATION > 1.0f ? 1.0f : SATURATION);
            return this;
        }

        public Builder relSaturation(float REL_SATURATION) {
            this.saturation = this.saturation + REL_SATURATION < 0.0f ? 0.0f : (this.saturation + REL_SATURATION > 1.0f ? 1.0f : this.saturation + REL_SATURATION);
            return this;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public Builder brightness(float BRIGHTNESS) {
            this.brightness = BRIGHTNESS < 0.0f ? 0.0f : (BRIGHTNESS > 1.0f ? 1.0f : BRIGHTNESS);
            return this;
        }

        public Builder relBrightness(float REL_BRIGHTNESS) {
            this.brightness = this.brightness + REL_BRIGHTNESS < 0.0f ? 0.0f : (this.brightness + REL_BRIGHTNESS > 1.0f ? 1.0f : this.brightness + REL_BRIGHTNESS);
            return this;
        }

        public float getBrightness() {
            return this.brightness;
        }

        public Builder alpha(int ALPHA) {
            this.alpha = ALPHA < 0 ? 0 : (ALPHA > 255 ? 255 : ALPHA);
            return this;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public HsbColor build() {
            return new HsbColor(this);
        }
    }
}

