/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.SymbolType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public enum SymbolImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private final Shadow SHADOW = Shadow.INSTANCE;
    private int widthBuffer = 0;
    private SymbolType symbolTypeBuffer = SymbolType.HORN;
    private ColorDef symbolColorBuffer = null;
    private CustomColorDef customSymbolColorBuffer = new CustomColorDef(Color.RED);
    private BufferedImage symbolImageBuffer = this.UTIL.createImage(1, 1, 3);
    private BufferedImage clipImageSymbol = this.UTIL.createImage(1, 1, 3);

    /*
     * Opcode count of 21105 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public BufferedImage createSymbol(int WIDTH, SymbolType SYMBOL_TYPE, ColorDef SYMBOL_COLOR, CustomColorDef CUSTOM_SYMBOL_COLOR, boolean GLOW) {
        Color GLOW_COLOR;
        Color STROKE_COLOR;
        Color FILL_COLOR;
        GeneralPath SYMBOL;
        if (WIDTH <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.widthBuffer == WIDTH && this.symbolTypeBuffer == SYMBOL_TYPE && this.symbolColorBuffer == SYMBOL_COLOR && this.customSymbolColorBuffer == CUSTOM_SYMBOL_COLOR) {
            return this.symbolImageBuffer;
        }
        this.symbolImageBuffer.flush();
        this.symbolImageBuffer = this.UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = this.symbolImageBuffer.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = this.symbolImageBuffer.getWidth();
        int IMAGE_HEIGHT = this.symbolImageBuffer.getHeight();
        switch (SYMBOL_TYPE) {
            case FUEL: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.3130841121495327, (double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.3130841121495327, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.7102803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.7102803738317757, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.7383177570093458, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.7383177570093458, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.7102803738317757, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.7102803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.6962616822429907, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.7102803738317757, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.7102803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.7102803738317757, (double)IMAGE_WIDTH * 0.7383177570093458, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.7476635514018691, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7523364485981309, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.7523364485981309, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.7523364485981309, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7476635514018691, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.7429906542056075, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.719626168224299, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.3878504672897196);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.7429906542056075, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.7476635514018691, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7570093457943925, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.7523364485981309, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.7523364485981309, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7476635514018691, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.308411214953271, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.2850467289719626, (double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.27102803738317754, (double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.2897196261682243);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.29439252336448596, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.3177570093457944, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.3411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7009345794392523, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.40186915887850466);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.719626168224299, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.6308411214953271, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.2850467289719626, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.27102803738317754, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.27102803738317754, (double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.27102803738317754, (double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.27102803738317754, (double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.2850467289719626, (double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.closePath();
                break;
            }
            case ENGINE: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.32710280373831774);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.32710280373831774);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.677570093457944);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.677570093457944);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.closePath();
                break;
            }
            case OIL: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.7009345794392523, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.7009345794392523, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.7383177570093458, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4672897196261682);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.2803738317757009, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3317757009345794, (double)IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.719626168224299, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.7009345794392523, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3317757009345794, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.closePath();
                break;
            }
            case FULL_BEAM: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.43457943925233644, (double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.40654205607476634, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.closePath();
                break;
            }
            case LOW_BEAM: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6308411214953271, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5607476635514018);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5373831775700935);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.3644859813084112, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.40654205607476634);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.40654205607476634, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6962616822429907, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6962616822429907);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6682242990654206);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.40654205607476634, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.closePath();
                break;
            }
            case FOG_LIGHT: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.397196261682243, (double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.34579439252336447, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.34579439252336447, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.34579439252336447, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.40654205607476634, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.closePath();
                break;
            }
            case BATTERY: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.308411214953271, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.6308411214953271, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.308411214953271, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.6308411214953271, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.2897196261682243, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.2897196261682243, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2757009345794392, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.40186915887850466);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.2757009345794392, (double)IMAGE_HEIGHT * 0.6728971962616822, (double)IMAGE_WIDTH * 0.2897196261682243, (double)IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2897196261682243, (double)IMAGE_HEIGHT * 0.6728971962616822, (double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.6728971962616822, (double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.6728971962616822, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.40186915887850466);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3411214953271028, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.closePath();
                break;
            }
            case TEMPERATURE: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7009345794392523, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.719626168224299, (double)IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2616822429906542, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.2616822429906542, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.6728971962616822, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6915887850467289);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3411214953271028, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.6728971962616822, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.7009345794392523);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.7009345794392523);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.7009345794392523);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.6728971962616822, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.29906542056074764, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.29906542056074764);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2803738317757009, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2803738317757009);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.2803738317757009, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.29906542056074764);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.29906542056074764, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4485981308411215, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4485981308411215, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4485981308411215, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.43457943925233644);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4252336448598131);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.closePath();
                break;
            }
            case TURN_LIGHT: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.24299065420560748, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.7523364485981309, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5700934579439252);
                SYMBOL.closePath();
                break;
            }
            case GLAZE: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.2897196261682243);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.3177570093457944, (double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.3177570093457944, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.32710280373831774, (double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3878504672897196);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.3644859813084112, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.397196261682243, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.397196261682243, (double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.3644859813084112, (double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.308411214953271, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.397196261682243, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.3317757009345794, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3317757009345794, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.3317757009345794, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.3317757009345794, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.308411214953271, (double)IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.677570093457944, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.7149532710280374, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.7149532710280374);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.7383177570093458, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7383177570093458);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.7383177570093458, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7149532710280374);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7149532710280374, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.677570093457944, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.6869158878504673, (double)IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.4392523364485981);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.397196261682243, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.6869158878504673, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.3644859813084112, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.397196261682243, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.397196261682243);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.397196261682243, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.3644859813084112, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.3598130841121495, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.3878504672897196);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.32710280373831774, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.3177570093457944, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.3177570093457944, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.2897196261682243);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.2803738317757009, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.27102803738317754, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.27102803738317754, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.2803738317757009, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.2897196261682243);
                SYMBOL.closePath();
                break;
            }
            case BREAK: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.6074766355140186, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.34579439252336447, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.308411214953271, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.3411214953271028, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.34579439252336447, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                break;
            }
            case ABS: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5373831775700935);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.34579439252336447, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.308411214953271, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.3411214953271028, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.34579439252336447, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                break;
            }
            case ESP: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.6822429906542056);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.32242990654205606);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5373831775700935);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.34579439252336447, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.308411214953271, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.3411214953271028, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.6448598130841121);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.35514018691588783);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.34579439252336447, (double)IMAGE_HEIGHT * 0.3364485981308411);
                SYMBOL.closePath();
                break;
            }
            case ATTENTION: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.2850467289719626);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.24299065420560748);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5841121495327103);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.closePath();
                break;
            }
            case WIPER: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.43457943925233644, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.43457943925233644);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.43457943925233644);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.43457943925233644, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.40654205607476634, (double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.308411214953271, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.3130841121495327, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.42990654205607476);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.602803738317757);
                SYMBOL.closePath();
                break;
            }
            case AIRBAG: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.5607476635514018);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.43457943925233644);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.43457943925233644, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.4953271028037383);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.48130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6869158878504673, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.7383177570093458, (double)IMAGE_HEIGHT * 0.4205607476635514, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.719626168224299, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.6962616822429907, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.6869158878504673, (double)IMAGE_HEIGHT * 0.4205607476635514);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.4485981308411215, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.677570093457944);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.677570093457944, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.7102803738317757, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.6962616822429907);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.6728971962616822, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6308411214953271);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5560747663551402);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.35514018691588783, (double)IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.6448598130841121, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.308411214953271, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.7149532710280374, (double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.7149532710280374);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.35046728971962615, (double)IMAGE_HEIGHT * 0.7149532710280374, (double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.6588785046728972);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.4158878504672897, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.6074766355140186);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5654205607476636, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.32710280373831774, (double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.3037383177570093);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.32710280373831774, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.3598130841121495);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.40654205607476634);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.40654205607476634);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.2803738317757009, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.2803738317757009);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.32242990654205606, (double)IMAGE_HEIGHT * 0.2803738317757009, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.40654205607476634);
                SYMBOL.closePath();
                break;
            }
            case SEATBELT: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.2897196261682243, (double)IMAGE_HEIGHT * 0.719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.719626168224299, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6682242990654206);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.2897196261682243, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.2897196261682243, (double)IMAGE_HEIGHT * 0.6915887850467289);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2803738317757009, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.2803738317757009, (double)IMAGE_HEIGHT * 0.7102803738317757, (double)IMAGE_WIDTH * 0.2897196261682243, (double)IMAGE_HEIGHT * 0.719626168224299);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.6962616822429907, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.7102803738317757, (double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.719626168224299, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.705607476635514);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.6682242990654206, (double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.677570093457944, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.3925233644859813, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.4485981308411215, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37383177570093457, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.705607476635514);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.705607476635514);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.6962616822429907, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.6261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.6635514018691588);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6495327102803738);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5934579439252337);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.6542056074766355);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.2570093457943925, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2570093457943925);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.2570093457943925, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.3411214953271028, (double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.34579439252336447);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.closePath();
                break;
            }
            case AIR_CONDITION: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.5514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.411214953271028, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.3317757009345794, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.5420560747663551);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2570093457943925, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.6869158878504673);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.6869158878504673, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6214953271028038);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.5794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5747663551401869);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5887850467289719);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6214953271028038, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.7289719626168224);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.7429906542056075, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.7289719626168224, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.616822429906542);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.5093457943925234);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5654205607476636, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5794392523364486, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.4719626168224299);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.5);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.4953271028037383, (double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.45794392523364486);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7429906542056075, (double)IMAGE_HEIGHT * 0.42990654205607476, (double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.3130841121495327, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.3130841121495327);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.3130841121495327, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.308411214953271, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.4485981308411215, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4485981308411215, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.4485981308411215, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.4485981308411215, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4485981308411215);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.4252336448598131, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.411214953271028);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.32710280373831774);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.308411214953271, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.29439252336448596, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.27102803738317754);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.2570093457943925, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.27102803738317754, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.38317757009345793);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.4766355140186916);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.4766355140186916, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.43457943925233644, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.514018691588785);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.5233644859813084);
                SYMBOL.closePath();
                break;
            }
            case SLICKNESS: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6355140186915887, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.6962616822429907, (double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5700934579439252, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.6308411214953271, (double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.26635514018691586, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.7242990654205608);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.37850467289719625, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.6962616822429907, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6728971962616822);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.6495327102803738, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6308411214953271, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5981308411214953);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5700934579439252, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.3411214953271028);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.3130841121495327);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.3130841121495327);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.3317757009345794);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.3411214953271028);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.42990654205607476, (double)IMAGE_HEIGHT * 0.3411214953271028);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.37383177570093457);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.37383177570093457);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6074766355140186, (double)IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.4532710280373832);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.4158878504672897);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.3925233644859813);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.397196261682243, (double)IMAGE_HEIGHT * 0.37383177570093457);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6261682242990654, (double)IMAGE_HEIGHT * 0.49065420560747663);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6869158878504673, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6869158878504673, (double)IMAGE_HEIGHT * 0.37850467289719625);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.719626168224299, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.602803738317757, (double)IMAGE_HEIGHT * 0.2803738317757009);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.2803738317757009);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.35046728971962615);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.3691588785046729);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.37383177570093457);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.3598130841121495, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SYMBOL.closePath();
                break;
            }
            case ARROW_NORTH: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo(0.616822429906542 * (double)IMAGE_WIDTH, 0.6962616822429907 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3878504672897196 * (double)IMAGE_WIDTH, 0.6962616822429907 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3878504672897196 * (double)IMAGE_WIDTH, 0.5794392523364486 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.26635514018691586 * (double)IMAGE_WIDTH, 0.5794392523364486 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5046728971962616 * (double)IMAGE_WIDTH, 0.3130841121495327 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.7336448598130841 * (double)IMAGE_WIDTH, 0.5794392523364486 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.616822429906542 * (double)IMAGE_WIDTH, 0.5794392523364486 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.616822429906542 * (double)IMAGE_WIDTH, 0.6962616822429907 * (double)IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;
            }
            case ARROW_NORTH_EAST: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo(0.49065420560747663 * (double)IMAGE_WIDTH, 0.6822429906542056 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32710280373831774 * (double)IMAGE_WIDTH, 0.5186915887850467 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.411214953271028 * (double)IMAGE_WIDTH, 0.43457943925233644 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32710280373831774 * (double)IMAGE_WIDTH, 0.35046728971962615 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6728971962616822 * (double)IMAGE_WIDTH, 0.32242990654205606 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6542056074766355 * (double)IMAGE_WIDTH, 0.6822429906542056 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * (double)IMAGE_WIDTH, 0.5981308411214953 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.49065420560747663 * (double)IMAGE_WIDTH, 0.6822429906542056 * (double)IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;
            }
            case ARROW_EAST: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo(0.308411214953271 * (double)IMAGE_WIDTH, 0.616822429906542 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.308411214953271 * (double)IMAGE_WIDTH, 0.3878504672897196 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * (double)IMAGE_WIDTH, 0.3878504672897196 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * (double)IMAGE_WIDTH, 0.26635514018691586 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6915887850467289 * (double)IMAGE_WIDTH, 0.4953271028037383 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * (double)IMAGE_WIDTH, 0.7336448598130841 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * (double)IMAGE_WIDTH, 0.616822429906542 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.308411214953271 * (double)IMAGE_WIDTH, 0.616822429906542 * (double)IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;
            }
            case ARROW_SOUTH_EAST: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo(0.32242990654205606 * (double)IMAGE_WIDTH, 0.49065420560747663 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.48598130841121495 * (double)IMAGE_WIDTH, 0.3317757009345794 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5654205607476636 * (double)IMAGE_WIDTH, 0.411214953271028 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6495327102803738 * (double)IMAGE_WIDTH, 0.32710280373831774 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.677570093457944 * (double)IMAGE_WIDTH, 0.677570093457944 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32242990654205606 * (double)IMAGE_WIDTH, 0.6588785046728972 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.40654205607476634 * (double)IMAGE_WIDTH, 0.5747663551401869 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32242990654205606 * (double)IMAGE_WIDTH, 0.49065420560747663 * (double)IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;
            }
            case ARROW_SOUTH: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo(0.616822429906542 * (double)IMAGE_WIDTH, 0.3130841121495327 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3878504672897196 * (double)IMAGE_WIDTH, 0.3130841121495327 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3878504672897196 * (double)IMAGE_WIDTH, 0.42990654205607476 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.26635514018691586 * (double)IMAGE_WIDTH, 0.42990654205607476 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5046728971962616 * (double)IMAGE_WIDTH, 0.6962616822429907 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.7336448598130841 * (double)IMAGE_WIDTH, 0.42990654205607476 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.616822429906542 * (double)IMAGE_WIDTH, 0.42990654205607476 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.616822429906542 * (double)IMAGE_WIDTH, 0.3130841121495327 * (double)IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;
            }
            case ARROW_SOUTH_WEST: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo(0.677570093457944 * (double)IMAGE_WIDTH, 0.49065420560747663 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.514018691588785 * (double)IMAGE_WIDTH, 0.3317757009345794 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.43457943925233644 * (double)IMAGE_WIDTH, 0.411214953271028 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.35046728971962615 * (double)IMAGE_WIDTH, 0.32710280373831774 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32242990654205606 * (double)IMAGE_WIDTH, 0.677570093457944 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.677570093457944 * (double)IMAGE_WIDTH, 0.6588785046728972 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5934579439252337 * (double)IMAGE_WIDTH, 0.5747663551401869 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.677570093457944 * (double)IMAGE_WIDTH, 0.49065420560747663 * (double)IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;
            }
            case ARROW_WEST: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo(0.6915887850467289 * (double)IMAGE_WIDTH, 0.616822429906542 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6915887850467289 * (double)IMAGE_WIDTH, 0.3878504672897196 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * (double)IMAGE_WIDTH, 0.3878504672897196 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * (double)IMAGE_WIDTH, 0.26635514018691586 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.3130841121495327 * (double)IMAGE_WIDTH, 0.4953271028037383 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * (double)IMAGE_WIDTH, 0.7336448598130841 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5747663551401869 * (double)IMAGE_WIDTH, 0.616822429906542 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6915887850467289 * (double)IMAGE_WIDTH, 0.616822429906542 * (double)IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;
            }
            case ARROW_NORTH_WEST: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.6822429906542056 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6728971962616822 * (double)IMAGE_WIDTH, 0.5186915887850467 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5887850467289719 * (double)IMAGE_WIDTH, 0.43457943925233644 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.6728971962616822 * (double)IMAGE_WIDTH, 0.35046728971962615 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.32710280373831774 * (double)IMAGE_WIDTH, 0.32710280373831774 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.34579439252336447 * (double)IMAGE_WIDTH, 0.6822429906542056 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.4252336448598131 * (double)IMAGE_WIDTH, 0.5981308411214953 * (double)IMAGE_HEIGHT);
                SYMBOL.lineTo(0.5093457943925234 * (double)IMAGE_WIDTH, 0.6822429906542056 * (double)IMAGE_HEIGHT);
                SYMBOL.closePath();
                break;
            }
            default: {
                SYMBOL = new GeneralPath();
                SYMBOL.setWindingRule(0);
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.4205607476635514, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5186915887850467);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.5607476635514018, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.5233644859813084, (double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.6121495327102804);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.40654205607476634, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.closePath();
                SYMBOL.moveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6915887850467289, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.7383177570093458, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.7383177570093458, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.46261682242990654);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6214953271028038, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5981308411214953, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.4439252336448598);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.48598130841121495);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.2803738317757009, (double)IMAGE_HEIGHT * 0.3644859813084112, (double)IMAGE_WIDTH * 0.2803738317757009, (double)IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.3644859813084112);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.lineTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6401869158878505);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.6401869158878505, (double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.40186915887850466, (double)IMAGE_HEIGHT * 0.5327102803738317);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.3878504672897196, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.5514018691588785, (double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.38317757009345793, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.4485981308411215, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.6355140186915887);
                SYMBOL.curveTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.6355140186915887, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.602803738317757, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.5654205607476636);
                SYMBOL.closePath();
                break;
            }
        }
        if (SYMBOL_COLOR == ColorDef.CUSTOM && CUSTOM_SYMBOL_COLOR != null) {
            FILL_COLOR = CUSTOM_SYMBOL_COLOR.LIGHT;
            STROKE_COLOR = this.UTIL.setAlpha(CUSTOM_SYMBOL_COLOR.DARK, 0.5f);
            GLOW_COLOR = CUSTOM_SYMBOL_COLOR.LIGHT;
        } else {
            FILL_COLOR = SYMBOL_COLOR.LIGHT;
            STROKE_COLOR = this.UTIL.setAlpha(SYMBOL_COLOR.DARK, 0.5f);
            GLOW_COLOR = SYMBOL_COLOR.LIGHT;
        }
        if (GLOW) {
            if (this.clipImageSymbol != null) {
                this.clipImageSymbol.flush();
            }
            this.clipImageSymbol = this.SHADOW.createSoftClipImage(SYMBOL, FILL_COLOR);
            double OFFSET = 0.12 * (double)IMAGE_WIDTH;
            G2.translate(-OFFSET, -OFFSET);
            G2.drawImage((Image)Shadow.INSTANCE.createDropShadow(this.clipImageSymbol, 0, 0.65f, (int)OFFSET, 315, GLOW_COLOR), SYMBOL.getBounds().x, SYMBOL.getBounds().y, null);
            G2.translate(OFFSET, OFFSET);
        } else {
            G2.setPaint(FILL_COLOR);
            G2.fill(SYMBOL);
            G2.setStroke(new BasicStroke(0.5f));
            G2.setColor(STROKE_COLOR);
            G2.draw(SYMBOL);
        }
        G2.dispose();
        this.widthBuffer = WIDTH;
        this.symbolTypeBuffer = SYMBOL_TYPE;
        this.symbolColorBuffer = SYMBOL_COLOR;
        this.customSymbolColorBuffer = CUSTOM_SYMBOL_COLOR;
        return this.symbolImageBuffer;
    }
}

