/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.lua;

import java.util.Arrays;
import java.util.List;
import neoe.formatter.lua.LuaTokenType;

public class LuaTokens {
    private String txt;
    private int p;
    private LuaTokenType type;
    StringBuilder sb = new StringBuilder();
    static final List<String> longOperaters = Arrays.asList("<=", ">=", "==", "~=", "//", ">>", "<<");

    public LuaTokens(String txt) {
        this.txt = txt;
        this.p = 0;
    }

    public TypeAndValue next() {
        if (this.p >= this.txt.length()) {
            return null;
        }
        this.sb.setLength(0);
        char c = this.txt.charAt(this.p);
        if (this.isSpace(c)) {
            char c2;
            this.type = LuaTokenType.SPACE;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length() && this.isSpace(c2 = this.txt.charAt(this.p))) {
                this.sb.append(c2);
                ++this.p;
            }
            return this.submit(this.type, this.sb.toString());
        }
        if (this.isIdentifier(c) || c == '-' && Character.isDigit(this.peek(1))) {
            char c2;
            this.type = LuaTokenType.IDENTIFIER;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length() && this.isIdentifier(c2 = this.txt.charAt(this.p))) {
                this.sb.append(c2);
                ++this.p;
            }
            return this.submit(this.type, this.sb.toString());
        }
        if (c == '-' && this.peek(1) == '-') {
            this.type = LuaTokenType.COMMENT;
            this.sb.append("--");
            this.p += 2;
            int level = this.peekLongBrackets();
            if (level < 0) {
                this.readUntil("\n");
                if (this.p < this.txt.length()) {
                    this.sb.setLength(this.sb.length() - 1);
                    --this.p;
                }
            } else {
                this.readUntilLongBrackets(level);
            }
            return this.submit(this.type, this.sb.toString());
        }
        if (c == '\'' || c == '\"') {
            this.type = LuaTokenType.STRING;
            this.sb.append(c);
            ++this.p;
            while (this.p < this.txt.length()) {
                char c2 = this.txt.charAt(this.p++);
                this.sb.append(c2);
                if (c2 == c) break;
                if (c2 != '\\') continue;
                this.sb.append(this.txt.charAt(this.p++));
            }
            return this.submit(this.type, this.sb.toString());
        }
        int level = this.peekLongBrackets();
        if (level < 0) {
            String t;
            this.type = LuaTokenType.OPERATOR;
            this.sb.append(c);
            ++this.p;
            while (longOperaters.contains(t = this.sb.toString() + this.peek(0))) {
                this.sb.append(this.txt.charAt(this.p++));
            }
            return this.submit(this.type, this.sb.toString());
        }
        this.type = LuaTokenType.STRING;
        this.readUntilLongBrackets(level);
        return this.submit(this.type, this.sb.toString());
    }

    private TypeAndValue submit(LuaTokenType type, String s) {
        return new TypeAndValue(type, s);
    }

    private void readUntilLongBrackets(int level) {
        StringBuilder sb = new StringBuilder("]");
        for (int i = 0; i < level; ++i) {
            sb.append('=');
        }
        sb.append(']');
        this.readUntil(sb.toString());
    }

    private int peekLongBrackets() {
        if (this.peek(0) == '[') {
            int lv = 0;
            while (this.peek(lv + 1) == '=') {
                ++lv;
            }
            if (this.peek(1 + lv) == '[') {
                return lv;
            }
        }
        return -1;
    }

    private void readUntil(String s) {
        int p1 = this.txt.indexOf(s, this.p);
        if (p1 < 0) {
            this.sb.append(this.txt.substring(this.p));
            this.p = this.txt.length();
        } else {
            this.sb.append(this.txt.substring(this.p, p1 + s.length()));
            this.p = p1 + s.length();
        }
    }

    private char peek(int i) {
        if (this.p + i >= this.txt.length()) {
            return '\u0000';
        }
        return this.txt.charAt(this.p + i);
    }

    private boolean isIdentifier(char c) {
        return Character.isDigit(c) || Character.isLetter(c) || c == '_';
    }

    private boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }

    public static class TypeAndValue {
        private final LuaTokenType type;
        private final String value;

        public TypeAndValue(LuaTokenType type, String value) {
            this.type = type;
            this.value = value;
        }

        public LuaTokenType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "TypeAndValue{type=" + (Object)((Object)this.type) + ", value='" + this.value + '\'' + '}';
        }
    }
}

