/*
 * Decompiled with CFR 0.152.
 */
package peak.can.basic;

import java.util.EnumSet;
import peak.can.basic.TPCANMessageType;

public class TPCANMsgFD
implements Cloneable {
    private int _id;
    private EnumSet<TPCANMessageType> _type;
    private byte _dlc;
    private byte _len;
    private byte[] _data;

    public TPCANMsgFD() {
        this._data = new byte[64];
    }

    public TPCANMsgFD(int id, EnumSet<TPCANMessageType> type, byte dlc, byte[] data) {
        this._id = id;
        this._type = type;
        this._dlc = dlc;
        this._len = TPCANMsgFD.getLengthFromDLC(dlc);
        this._data = new byte[64];
        System.arraycopy(data, 0, this._data, 0, this._len);
    }

    public void setID(int id) {
        this._id = id;
    }

    public void setData(byte[] data, byte dlc) {
        this.setDlc(dlc);
        System.arraycopy(data, 0, this._data, 0, this._len);
    }

    public void setDlc(byte dlc) {
        this._dlc = dlc;
        this._len = TPCANMsgFD.getLengthFromDLC(dlc);
    }

    public void setType(EnumSet<TPCANMessageType> type) {
        this._type = type;
    }

    public void setType(byte type) {
        EnumSet<TPCANMessageType> eset = EnumSet.noneOf(TPCANMessageType.class);
        for (TPCANMessageType t : TPCANMessageType.values()) {
            if ((type & t.getValue()) != t.getValue()) continue;
            eset.add(t);
        }
        if (eset.contains((Object)TPCANMessageType.PCAN_MESSAGE_EXTENDED) || eset.contains((Object)TPCANMessageType.PCAN_MESSAGE_STATUS) || eset.contains((Object)TPCANMessageType.PCAN_MESSAGE_RTR) || eset.contains((Object)TPCANMessageType.PCAN_MESSAGE_BRS) || eset.contains((Object)TPCANMessageType.PCAN_MESSAGE_ESI)) {
            eset.remove((Object)TPCANMessageType.PCAN_MESSAGE_STANDARD);
        }
        this._type = eset;
    }

    public int getID() {
        return this._id;
    }

    public byte[] getData() {
        return this._data;
    }

    public byte getDlc() {
        return this._dlc;
    }

    public byte getLengthFromDLC() {
        return TPCANMsgFD.getLengthFromDLC(this._dlc);
    }

    public static byte getLengthFromDLC(byte dlc) {
        switch (dlc) {
            case 9: {
                return 12;
            }
            case 10: {
                return 16;
            }
            case 11: {
                return 20;
            }
            case 12: {
                return 24;
            }
            case 13: {
                return 32;
            }
            case 14: {
                return 48;
            }
            case 15: {
                return 64;
            }
        }
        return dlc;
    }

    public EnumSet<TPCANMessageType> getTypeEnum() {
        return this._type;
    }

    public byte getType() {
        byte res = 0;
        for (TPCANMessageType t : this._type) {
            res = (byte)(res | t.getValue());
        }
        return res;
    }

    public Object clone() {
        TPCANMsgFD msg = null;
        try {
            msg = (TPCANMsgFD)super.clone();
            msg._data = (byte[])this._data.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e.getMessage());
        }
        return msg;
    }
}

