/*
 * Decompiled with CFR 0.152.
 */
package peak.can.basic;

import java.util.EnumSet;

public enum TPCANParameterValue {
    PCAN_PARAMETER_OFF(0),
    PCAN_PARAMETER_ON(1),
    PCAN_FILTER_CLOSE(0),
    PCAN_FILTER_OPEN(1),
    PCAN_FILTER_CUSTOM(2),
    PCAN_CHANNEL_UNAVAILABLE(0),
    PCAN_CHANNEL_AVAILABLE(1),
    PCAN_CHANNEL_OCCUPIED(2),
    PCAN_CHANNEL_PCANVIEW(TPCANParameterValue.PCAN_CHANNEL_AVAILABLE.value | TPCANParameterValue.PCAN_CHANNEL_OCCUPIED.value),
    LOG_FUNCTION_DEFAULT(0),
    LOG_FUNCTION_ENTRY(1),
    LOG_FUNCTION_PARAMETERS(2),
    LOG_FUNCTION_LEAVE(4),
    LOG_FUNCTION_WRITE(8),
    LOG_FUNCTION_READ(16),
    LOG_FUNCTION_ALL(65535),
    TRACE_FILE_SINGLE(0),
    TRACE_FILE_SEGMENTED(1),
    TRACE_FILE_DATE(2),
    TRACE_FILE_TIME(4),
    TRACE_FILE_OVERWRITE(128),
    FEATURE_FD_CAPABLE(1),
    FEATURE_DELAY_CAPABLE(2),
    FEATURE_IO_CAPABLE(4),
    SERVICE_STATUS_STOPPED(1),
    SERVICE_STATUS_RUNNING(4);

    public static final int MAX_LENGTH_HARDWARE_NAME = 33;
    public static final int MAX_LENGTH_VERSION_STRING = 18;
    public static final int MIN_LENGTH_ERROR_STRING = 256;
    private final int value;

    private TPCANParameterValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TPCANParameterValue parseOnOff(int value) {
        if (value == PCAN_PARAMETER_ON.getValue()) {
            return PCAN_PARAMETER_ON;
        }
        if (value == PCAN_PARAMETER_OFF.getValue()) {
            return PCAN_PARAMETER_OFF;
        }
        return null;
    }

    public static TPCANParameterValue parseCondition(int value) {
        if (value == PCAN_CHANNEL_AVAILABLE.getValue()) {
            return PCAN_CHANNEL_AVAILABLE;
        }
        if (value == PCAN_CHANNEL_UNAVAILABLE.getValue()) {
            return PCAN_CHANNEL_UNAVAILABLE;
        }
        if (value == PCAN_CHANNEL_OCCUPIED.getValue()) {
            return PCAN_CHANNEL_OCCUPIED;
        }
        if (value == PCAN_CHANNEL_PCANVIEW.getValue()) {
            return PCAN_CHANNEL_PCANVIEW;
        }
        return null;
    }

    public static TPCANParameterValue parseFilterStatus(int value) {
        if (value == PCAN_FILTER_CLOSE.getValue()) {
            return PCAN_FILTER_CLOSE;
        }
        if (value == PCAN_FILTER_OPEN.getValue()) {
            return PCAN_FILTER_OPEN;
        }
        if (value == PCAN_FILTER_CUSTOM.getValue()) {
            return PCAN_FILTER_CUSTOM;
        }
        return null;
    }

    public static EnumSet<TPCANParameterValue> parseFeatures(int value) {
        EnumSet<TPCANParameterValue> result = EnumSet.noneOf(TPCANParameterValue.class);
        if ((value & FEATURE_DELAY_CAPABLE.getValue()) != 0) {
            result.add(FEATURE_DELAY_CAPABLE);
        }
        if ((value & FEATURE_FD_CAPABLE.getValue()) != 0) {
            result.add(FEATURE_FD_CAPABLE);
        }
        if ((value & FEATURE_IO_CAPABLE.getValue()) != 0) {
            result.add(FEATURE_IO_CAPABLE);
        }
        return result;
    }
}

