/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.livedata;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public class Range {
    private final int start;
    private final int stop;

    public Range(int start, int stop) {
        if (start < 0) {
            throw new IllegalArgumentException("Negative start " + start);
        }
        if (stop < 0) {
            throw new IllegalArgumentException("Negative stop " + stop);
        }
        this.start = start;
        this.stop = stop;
        if (this.getLength() < 0) {
            throw new IllegalArgumentException("Negative length " + start + "/" + stop);
        }
    }

    public Range(Token start, Token stop) {
        this(start.getStartIndex(), stop.getStopIndex() + 1);
    }

    public Range(ParserRuleContext context) {
        this(context.start, context.stop);
    }

    public static Range create(Token startToken, Token stopToken) {
        int start = startToken.getStartIndex();
        int stop = stopToken.getStopIndex() + 1;
        if (stop < start) {
            return null;
        }
        return new Range(startToken, stopToken);
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public int getLength() {
        return this.stop - this.start;
    }

    public String toString() {
        return "Range{start=" + this.start + ", stop=" + this.stop + "}";
    }
}

