/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.FileLog;
import com.rusefi.autodetect.SerialAutoChecker;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.core.RusEfiSignature;
import com.rusefi.core.SignatureHelper;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkManager;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.io.serial.BufferedSerialIoStream;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.MaintenanceUtil;
import com.rusefi.maintenance.StLinkFlasher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public enum SerialPortScanner {
    INSTANCE;

    private static final Logging log;
    private volatile boolean isRunning = true;
    private static final boolean SHOW_SOCKETCAN;
    private final Object lock = new Object();
    @NotNull
    private AvailableHardware knownHardware = new AvailableHardware(Collections.emptyList(), false, false, false);
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private static final Map<String, PortResult> portCache;

    public void addListener(Listener listener) {
        boolean shouldStart = this.listeners.isEmpty();
        this.listeners.add(listener);
        if (shouldStart) {
            this.startTimer();
        }
    }

    private static PortResult inspectPort(String serialPort) {
        log.info("Determining type of serial port: " + serialPort);
        boolean isOpenblt = SerialPortScanner.isPortOpenblt(serialPort);
        log.info("Port " + serialPort + (isOpenblt ? " looks like" : " does not look like") + " an OpenBLT bootloader");
        if (isOpenblt) {
            return new PortResult(serialPort, SerialPortType.OpenBlt);
        }
        String signature = SerialPortScanner.getEcuSignature(serialPort);
        boolean isEcu = signature != null;
        log.info("Port " + serialPort + (isEcu ? " looks like" : " does not look like") + " an ECU");
        if (isEcu) {
            boolean ecuHasOpenblt = SerialPortScanner.ecuHasOpenblt(serialPort);
            log.info("ECU at " + serialPort + (ecuHasOpenblt ? " has" : " does not have") + " an OpenBLT bootloader");
            return new PortResult(serialPort, ecuHasOpenblt ? SerialPortType.EcuWithOpenblt : SerialPortType.Ecu, signature);
        }
        return new PortResult(serialPort, SerialPortType.Unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PortResult> inspectPorts(List<String> ports) {
        if (ports.isEmpty()) {
            return new ArrayList<PortResult>();
        }
        Iterator<String> resultsLock = new Iterator<String>();
        HashMap<String, PortResult> results = new HashMap<String, PortResult>();
        Thread callingThread = Thread.currentThread();
        List threads = ports.stream().map(p -> {
            Thread t = new Thread(() -> {
                PortResult r = SerialPortScanner.inspectPort(p);
                Object object = resultsLock;
                synchronized (object) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    results.put((String)p, r);
                    if (results.size() == ports.size()) {
                        callingThread.interrupt();
                    }
                }
            });
            t.setName("SerialPortScanner inspectPort " + p);
            t.setDaemon(true);
            t.start();
            return t;
        }).collect(Collectors.toList());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Iterator<String> iterator = resultsLock;
        synchronized (iterator) {
            for (Thread t : threads) {
                t.interrupt();
            }
        }
        for (String port : ports) {
            if (results.containsKey(port)) continue;
            log.info("Port " + port + " timed out, adding as Unknown.");
            results.put(port, new PortResult(port, SerialPortType.Unknown));
        }
        return new ArrayList<PortResult>(results.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAllAvailablePorts(boolean includeSlowLookup) {
        boolean isListUpdated;
        boolean PCANConnected;
        boolean stLinkConnected;
        boolean dfuConnected;
        ArrayList<PortResult> ports = new ArrayList<PortResult>();
        String[] serialPorts = LinkManager.getCommPorts();
        ArrayList<String> portsToInspect = new ArrayList<String>();
        for (String serialPort : serialPorts) {
            if (portCache.containsKey(serialPort)) {
                PortResult cached = portCache.get(serialPort);
                ports.add(cached);
                continue;
            }
            portsToInspect.add(serialPort);
        }
        for (PortResult p2 : SerialPortScanner.inspectPorts(portsToInspect)) {
            log.info("Port " + p2.port + " detected as: " + p2.type.friendlyString);
            ports.add(p2);
            portCache.put(p2.port, p2);
        }
        ArrayList toRemove = new ArrayList();
        for (String x : portCache.keySet()) {
            if (!Arrays.stream(serialPorts).noneMatch(x::equals)) continue;
            toRemove.add(x);
        }
        toRemove.forEach(p -> {
            portCache.remove(p);
            log.info("Removing port " + p);
        });
        ports.sort(Comparator.comparingInt(a -> a.type.sortOrder));
        if (includeSlowLookup) {
            for (String tcpPort : TcpConnector.getAvailablePorts()) {
                ports.add(new PortResult(tcpPort, SerialPortType.Ecu));
            }
            dfuConnected = DfuFlasher.detectSTM32BootloaderDriverState(UpdateOperationCallbacks.DUMMY);
            stLinkConnected = StLinkFlasher.detectStLink(UpdateOperationCallbacks.DUMMY);
            PCANConnected = MaintenanceUtil.detectPcan(UpdateOperationCallbacks.DUMMY);
        } else {
            dfuConnected = false;
            stLinkConnected = false;
            PCANConnected = false;
        }
        if (PCANConnected) {
            ports.add(new PortResult("PCAN", SerialPortType.CAN));
        }
        if (SHOW_SOCKETCAN) {
            ports.add(new PortResult("SocketCAN", SerialPortType.CAN));
        }
        AvailableHardware currentHardware = new AvailableHardware(ports, dfuConnected, stLinkConnected, PCANConnected);
        Iterator<Listener> iterator = this.lock;
        synchronized (iterator) {
            isListUpdated = !this.knownHardware.equals(currentHardware);
            this.knownHardware = currentHardware;
        }
        if (isListUpdated) {
            for (Listener listener : this.listeners) {
                listener.onChange(currentHardware);
            }
        }
    }

    private void startTimer() {
        Thread portsScanner = new Thread(() -> {
            boolean isFirstTime = true;
            while (this.isRunning) {
                this.findAllAvailablePorts(!isFirstTime);
                isFirstTime = false;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    log.error("sleep interrupted", e);
                }
            }
        }, "Ports Scanner");
        portsScanner.setDaemon(true);
        portsScanner.start();
    }

    public void stopTimer() {
        this.isRunning = false;
    }

    public static String getEcuSignature(String port) {
        IoStream stream = BufferedSerialIoStream.openPort(port);
        try {
            String string = SerialAutoChecker.checkResponse(stream, callbackContext -> null);
            if (stream != null) {
                stream.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ecuHasOpenblt(String port) {
        try (IoStream stream = BufferedSerialIoStream.openPort(port);){
            if (stream == null) {
                boolean bl = false;
                return bl;
            }
            stream.sendPacket(new byte[]{76});
            byte[] response = stream.getDataBuffer().getPacket(500, "ecuHasOpenblt");
            if (!IoHelper.checkResponseCode(response, (byte)0)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = response[1] == 1;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortOpenblt(String port) {
        try (IoStream stream = BufferedSerialIoStream.openPort(port);){
            if (stream == null) {
                boolean bl = false;
                return bl;
            }
            byte[] request = new byte[]{2, -1, 0};
            stream.write(request);
            IncomingDataBuffer idb = stream.getDataBuffer();
            byte responseLength = idb.readByte(250);
            if (responseLength != 8) {
                boolean bl = false;
                return bl;
            }
            byte[] response = new byte[responseLength];
            idb.waitForBytes(100, "isPortOpenblt", System.currentTimeMillis(), responseLength);
            idb.read(response);
            boolean bl = response[0] == -1;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    static {
        log = Logging.getLogging(SerialPortScanner.class);
        SHOW_SOCKETCAN = FileLog.isLinux();
        portCache = new HashMap<String, PortResult>();
    }

    public static class AvailableHardware {
        private final List<PortResult> ports;
        private final boolean dfuFound;
        private final boolean stLinkConnected;
        private final boolean PCANConnected;

        public <T> AvailableHardware(List<PortResult> ports, boolean dfuFound, boolean stLinkConnected, boolean PCANConnected) {
            this.ports = ports;
            this.dfuFound = dfuFound;
            this.stLinkConnected = stLinkConnected;
            this.PCANConnected = PCANConnected;
        }

        @NotNull
        public List<PortResult> getKnownPorts() {
            return new ArrayList<PortResult>(this.ports);
        }

        public boolean isDfuFound() {
            return this.dfuFound;
        }

        public boolean isStLinkConnected() {
            return this.stLinkConnected;
        }

        public boolean isPCANConnected() {
            return this.PCANConnected;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AvailableHardware that = (AvailableHardware)o;
            return this.dfuFound == that.dfuFound && this.stLinkConnected == that.stLinkConnected && this.PCANConnected == that.PCANConnected && this.ports.equals(that.ports);
        }

        public boolean isEmpty() {
            return !this.dfuFound && !this.stLinkConnected && !this.PCANConnected && this.ports.isEmpty();
        }
    }

    public static interface Listener {
        public void onChange(AvailableHardware var1);
    }

    public static class PortResult {
        public final String port;
        public final SerialPortType type;
        public final RusEfiSignature signature;

        public PortResult(String port, SerialPortType type, String signature) {
            this.port = port;
            this.type = type;
            this.signature = SignatureHelper.parse(signature);
        }

        public PortResult(String port, SerialPortType type) {
            this(port, type, null);
        }

        public String toString() {
            if (this.type.friendlyString == null) {
                return this.port;
            }
            return this.port + " (" + this.type.friendlyString + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            PortResult other = (PortResult)o;
            return this.port.equals(other.port) && this.type.equals((Object)other.type);
        }

        public boolean isEcu() {
            return this.type == SerialPortType.Ecu || this.type == SerialPortType.EcuWithOpenblt;
        }
    }

    public static enum SerialPortType {
        Ecu("ECU", 20),
        EcuWithOpenblt("ECU w/ BL", 20),
        OpenBlt("OpenBLT Bootloader", 10),
        CAN("CAN", 30),
        Unknown("Unknown", 100);

        public final String friendlyString;
        public final int sortOrder;

        private SerialPortType(String friendlyString, int sortOrder) {
            this.friendlyString = friendlyString;
            this.sortOrder = sortOrder;
        }
    }
}

