/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.FileLog;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.ExecHelper;
import com.rusefi.maintenance.UpdateStatusWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class DriverInstall {
    private static final String FOLDER = "../drivers";
    private static final String SELF_UNCOMPRESSING_ARCHIVE = "silent_st_drivers2.exe";
    private static final String YES = " -y";
    private static final String UNPACKED_FOLDER = "../drivers" + File.separator + "silent_st_drivers";
    private static final String WINDOWS7_BATCH = "silent_install_windows7.bat";
    private static final String WINDOWS8_BATCH = "silent_install_windows8.bat";

    public static Component createButton() {
        final JButton button = new JButton("Install Drivers");
        button.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int dialogResult = JOptionPane.showConfirmDialog(button, "Do you really want to install ST drivers?", "Please disconnect from vehicle", 0);
                if (dialogResult != 0) {
                    return;
                }
                UpdateStatusWindow wnd = new UpdateStatusWindow("Windows rusEFI ST Drivers");
                ExecHelper.submitAction(() -> DriverInstall.installDrivers(wnd), this.getClass() + " thread");
            }
        });
        return button;
    }

    private static void installDrivers(UpdateOperationCallbacks wnd) {
        FileLog.MAIN.logLine("IsWindows=" + FileLog.isWindows());
        if (!new File(FOLDER).exists()) {
            String message = "../drivers not found";
            wnd.append(message);
            FileLog.MAIN.logLine(message);
            return;
        }
        try {
            ExecHelper.executeCommand(FOLDER, FOLDER + File.separator + "silent_st_drivers2.exe -y", SELF_UNCOMPRESSING_ARCHIVE, wnd);
            String batch = DriverInstall.isWindows7orBelow() ? WINDOWS7_BATCH : WINDOWS8_BATCH;
            ExecHelper.executeCommand(UNPACKED_FOLDER, ExecHelper.getBatchCommand(batch), batch, wnd);
        }
        catch (FileNotFoundException e) {
            wnd.append(e.toString());
            wnd.error();
        }
    }

    private static boolean isWindows7orBelow() {
        String version = System.getProperty("os.version");
        return version.startsWith("5.") || version.startsWith("6.0") || version.startsWith("6.1");
    }
}

