/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.enum_reader;

import com.rusefi.VariableRegistry;
import java.util.Objects;

public class Value
implements Comparable<Value> {
    private final String name;
    private final String value;

    public Value(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getIntValue() {
        return Value.parseInt(this.value);
    }

    public static int parseInt(String value) {
        String trimmed = value.trim();
        if (trimmed.toLowerCase().startsWith("0x")) {
            return Integer.parseInt(trimmed.substring(2), 16);
        }
        return Integer.parseInt(trimmed);
    }

    @Override
    public int compareTo(Value o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "Value{name='" + this.name + "', value='" + this.value + "'}";
    }

    public int getIntValueMaybeResolve(VariableRegistry registry) {
        try {
            return this.getIntValue();
        }
        catch (NumberFormatException e) {
            return this.handleNotInteger(registry);
        }
    }

    private int handleNotInteger(VariableRegistry registry) {
        String resolvedValue = registry.get(this.value);
        Objects.requireNonNull(resolvedValue, this.value);
        return Value.parseInt(resolvedValue);
    }
}

