/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.can.elm;

import com.opensr5.io.DataListener;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.io.can.elm.Elm327Connector;
import com.rusefi.io.can.isotp.IsoTpCanDecoder;
import com.rusefi.io.serial.AbstractIoStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class Elm327IoStream
extends AbstractIoStream {
    private final Elm327Connector con;
    @NotNull
    private final IncomingDataBuffer dataBuffer;
    private DataListener dataListener;
    private static final int OUT_BUFFER_SIZE = 4095;
    private final ByteBuffer outBuf;
    private static final boolean sendShortPacketsInOneFrame = false;
    private static final boolean receiveShortPacketsInOneFrame = false;
    private final IsoTpCanDecoder canDecoder = new IsoTpCanDecoder();

    public Elm327IoStream(Elm327Connector con) {
        this.con = con;
        this.dataBuffer = this.createDataBuffer();
        this.outBuf = ByteBuffer.allocate(4095);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Elm327IoStream elm327IoStream = this;
        synchronized (elm327IoStream) {
            if (!this.isClosed()) {
                super.close();
            }
        }
    }

    @Override
    @NotNull
    public IncomingDataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        super.write(bytes);
        int offset = 0;
        int numBytes = bytes.length;
        while (numBytes > this.outBuf.remaining()) {
            int remaining = this.outBuf.remaining();
            this.outBuf.put(bytes, offset, remaining);
            numBytes -= remaining;
            offset += remaining;
            this.flush();
        }
        this.outBuf.put(bytes, offset, numBytes);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        byte[] bytes = Arrays.copyOf(this.outBuf.array(), this.outBuf.position());
        this.con.sendBytesToSerial(bytes);
        this.outBuf.clear();
    }

    @Override
    public void setInputListener(DataListener listener) {
        this.dataListener = listener;
    }

    public void sendDataToClient(byte[] data) {
        byte[] packet = data;
        this.dataListener.onDataArrived(packet);
    }

    public void processCanPacket(byte[] data) {
        byte[] rawData = this.canDecoder.decodePacket(data);
        if (rawData.length != 0) {
            this.sendDataToClient(rawData);
        }
    }
}

