/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.common;

import com.rusefi.IoUtil;
import com.rusefi.RusefiTestBase;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class MiscTest
extends RusefiTestBase {
    @Test
    public void burn() {
        BinaryProtocol bp = this.ecu.getLinkManager().getCurrentStreamState();
        bp.burn();
    }

    @Test
    public void testGetAllOutputs() throws InterruptedException {
        CountDownLatch responseLatch = new CountDownLatch(1);
        this.ecu.getLinkManager().execute(() -> {
            boolean result = this.ecu.getLinkManager().getBinaryProtocol().requestOutputChannels();
            System.out.println("requestOutputChannels=" + result);
            responseLatch.countDown();
        });
        responseLatch.await(1L, TimeUnit.MINUTES);
    }

    @Test
    public void testMcuTemperature() throws InterruptedException {
        double mcuTemp = Double.NaN;
        long start = System.currentTimeMillis();
        while (Double.isNaN(mcuTemp) && System.currentTimeMillis() - start < 5000L) {
            Thread.sleep(100L);
            mcuTemp = SensorCentral.getInstance().getValue(Sensor.INT_TEMP);
        }
        System.out.println("MCU temperature is " + mcuTemp + " deg C");
        BinaryProtocol bp = this.ecu.getLinkManager().getCurrentStreamState();
        Assert.assertTrue("Happy OutputChannels expected", bp.isGoodOutputChannels);
        String message = "mcuTemp is " + mcuTemp;
        Assert.assertTrue(message, mcuTemp > 10.0);
        Assert.assertTrue(message, mcuTemp < 52.0);
    }

    @Test
    public void testSetDate() {
        this.ecu.sendCommand("set date 2022-12-07T11:14:22");
        IoUtil.sleepSeconds(5);
    }
}

