/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Locale;

public final class OpenbltJni {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ROOT);
    private static final boolean IS_MAC;

    public static void flashSerial(String filename, String serialPort, OpenbltCallbacks callbacks) {
        if (!OS_NAME.contains("win") && !((String)serialPort).startsWith("/dev/")) {
            serialPort = "/dev/" + (String)serialPort;
        }
        OpenbltJni.flashSerialNative(filename, (String)serialPort, callbacks);
    }

    public static void flashCan(String filename, OpenbltCallbacks callbacks) {
        OpenbltJni.flashCanNative(filename, callbacks);
    }

    public static void stop(OpenbltCallbacks callbacks) {
        OpenbltJni.stopNative(callbacks);
    }

    private static native void flashSerialNative(String var0, String var1, OpenbltCallbacks var2);

    private static native void flashCanNative(String var0, OpenbltCallbacks var1);

    private static native void stopNative(OpenbltCallbacks var0);

    static {
        boolean bl = IS_MAC = OS_NAME.contains("mac") || OS_NAME.contains("darwin");
        if (IS_MAC) {
            String targetDir = System.getProperty("user.home") + "/Library/Java/Extensions";
            new File(targetDir).mkdirs();
            String[] libs = new String[]{"libopenblt.dylib", "libopenblt_jni.dylib"};
            try {
                for (String l : libs) {
                    Files.copy(Paths.get(l, new String[0]), Paths.get(targetDir + "/" + l, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            System.loadLibrary("openblt");
        }
        System.loadLibrary("openblt_jni");
    }

    public static interface OpenbltCallbacks {
        public void log(String var1);

        public void updateProgress(int var1);

        public void error(String var1);

        public void setPhase(String var1, boolean var2);
    }
}

