/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.rusefi.FileLog;
import com.rusefi.SerialPortScanner;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.Pair;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.io.LinkManager;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.ExecHelper;
import com.rusefi.maintenance.OpenbltJni;
import com.rusefi.maintenance.StLinkFlasher;
import com.rusefi.maintenance.UpdateStatusWindow;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ProgramSelector {
    private static final Logging log = Logging.getLogging(ProgramSelector.class);
    private static final String AUTO_DFU = "Auto Update";
    private static final String MANUAL_DFU = "Manual DFU Update";
    private static final String DFU_SWITCH = "Switch to DFU Mode";
    private static final String OPENBLT_SWITCH = "Switch to OpenBLT Mode";
    public static final String OPENBLT_MANUAL = "Manual OpenBLT Update";
    public static final String OPENBLT_AUTO = "Auto OpenBLT Update";
    private static final String DFU_ERASE = "Full Chip Erase";
    private static final String INSTALL_OPENBLT = "Install OpenBLT";
    private static final String ST_LINK = "ST-LINK Update";
    private static final String OPENBLT_CAN = "OpenBLT via CAN";
    private static final String HELP = "https://github.com/rusefi/rusefi/wiki/HOWTO-Update-Firmware";
    private final JPanel content = new JPanel(new BorderLayout());
    private final JLabel noHardware = new JLabel("Nothing detected");
    private final JPanel updateModeAndButton = new JPanel(new FlowLayout());
    private final JComboBox<String> updateModeComboBox = new JComboBox();

    public ProgramSelector(final JComboBox<SerialPortScanner.PortResult> comboPorts) {
        this.content.add((Component)this.updateModeAndButton, "North");
        this.content.add((Component)this.noHardware, "South");
        String persistedMode = PersistentConfiguration.getConfig().getRoot().getProperty(this.getClass().getSimpleName());
        if (Arrays.asList(AUTO_DFU, MANUAL_DFU, OPENBLT_CAN, OPENBLT_SWITCH, OPENBLT_MANUAL, OPENBLT_AUTO, DFU_ERASE, DFU_SWITCH).contains(persistedMode)) {
            this.updateModeComboBox.setSelectedItem(persistedMode);
        }
        JButton updateFirmwareButton = ProgramSelector.createUpdateFirmwareButton();
        this.updateModeAndButton.setVisible(false);
        this.updateModeAndButton.add(this.updateModeComboBox);
        this.updateModeAndButton.add(updateFirmwareButton);
        updateFirmwareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedMode = (String)ProgramSelector.this.updateModeComboBox.getSelectedItem();
                SerialPortScanner.PortResult selectedPort = (SerialPortScanner.PortResult)comboPorts.getSelectedItem();
                PersistentConfiguration.getConfig().getRoot().setProperty(this.getClass().getSimpleName(), selectedMode);
                ProgramSelector.executeJob(comboPorts, selectedMode, selectedPort);
            }
        });
    }

    public static void executeJob(JComponent parent, String selectedMode, SerialPortScanner.PortResult selectedPort) {
        Consumer<UpdateOperationCallbacks> job;
        log.info("ProgramSelector " + selectedMode + " " + selectedPort);
        String jobName = null;
        Objects.requireNonNull(selectedMode);
        switch (selectedMode) {
            case "Auto Update": {
                jobName = "DFU update";
                job = callbacks -> DfuFlasher.doAutoDfu(parent, selectedPort.port, callbacks);
                break;
            }
            case "Manual DFU Update": {
                jobName = "DFU update";
                job = DfuFlasher::runDfuProgramming;
                break;
            }
            case "Install OpenBLT": {
                jobName = "OpenBLT Initial Programming";
                job = DfuFlasher::runOpenBltInitialProgramming;
                break;
            }
            case "ST-LINK Update": {
                job = updateOperationCallbacks -> StLinkFlasher.doUpdateFirmware(FindFileHelper.FIRMWARE_BIN_FILE, parent);
                break;
            }
            case "Switch to DFU Mode": {
                jobName = "DFU switch";
                job = callbacks -> ProgramSelector.rebootToDfu(parent, selectedPort.port, callbacks);
                break;
            }
            case "Switch to OpenBLT Mode": {
                jobName = "OpenBLT switch";
                job = callbacks -> ProgramSelector.rebootToOpenblt(parent, selectedPort.port, callbacks);
                break;
            }
            case "OpenBLT via CAN": {
                jobName = OPENBLT_CAN;
                job = callbacks -> ProgramSelector.flashOpenBltCan(parent, callbacks);
                break;
            }
            case "Manual OpenBLT Update": {
                jobName = "OpenBLT via Serial";
                job = callbacks -> ProgramSelector.flashOpenbltSerialJni(parent, selectedPort.port, callbacks);
                break;
            }
            case "Auto OpenBLT Update": {
                jobName = "OpenBLT via Serial";
                job = callbacks -> ProgramSelector.flashOpenbltSerialAutomatic(parent, selectedPort.port, callbacks);
                break;
            }
            case "Full Chip Erase": {
                jobName = "DFU erase";
                job = DfuFlasher::runDfuEraseAsync;
                break;
            }
            default: {
                throw new IllegalArgumentException("How did you " + selectedMode);
            }
        }
        UpdateStatusWindow callbacks2 = new UpdateStatusWindow(FrameHelper.appendBundleName(jobName + " 20240708"));
        Consumer<UpdateOperationCallbacks> job2 = job;
        ExecHelper.submitAction(() -> job2.accept(callbacks2), "mx");
    }

    private static void rebootToDfu(JComponent parent, String selectedPort, UpdateOperationCallbacks callbacks) {
        String port = selectedPort == null ? "auto" : selectedPort;
        DfuFlasher.rebootToDfu(parent, port, callbacks, "reboot_dfu");
    }

    private static void rebootToOpenblt(JComponent parent, String selectedPort, UpdateOperationCallbacks callbacks) {
        String port = selectedPort == null ? "auto" : selectedPort;
        DfuFlasher.rebootToDfu(parent, port, callbacks, "reboot_openblt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flashOpenBltCan(JComponent parent, UpdateOperationCallbacks callbacks) {
        if (FileLog.is32bitJava()) {
            ProgramSelector.showError32bitJava(parent);
            return;
        }
        OpenbltJni.OpenbltCallbacks cb = ProgramSelector.makeOpenbltCallbacks(callbacks);
        try {
            OpenbltJni.flashCan(FindFileHelper.findSrecFile(), cb);
            callbacks.logLine("Update completed successfully!");
            callbacks.done();
        }
        catch (Throwable e) {
            callbacks.logLine("Error: " + e);
            callbacks.error();
        }
        finally {
            OpenbltJni.stop(cb);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Pair<Boolean, String[]> waitForEcuPortDisappeared(String ecuPort, JComponent parent, UpdateOperationCallbacks callbacks) {
        callbacks.log("Waiting for ECU to reboot to OpenBlt...", false, true);
        currentPorts = null;
        for (attemptsCount = 0; attemptsCount < 150; ++attemptsCount) {
            BinaryProtocol.sleep(200L);
            currentPorts = LinkManager.getCommPorts();
            ProgramSelector.log.info("currentPorts: [" + String.join((CharSequence)",", currentPorts) + "]");
            if ("auto".equals(ecuPort)) ** GOTO lbl-1000
            if (Arrays.stream(currentPorts).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)ecuPort))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = ecuPortStillAlive = false;
            }
            if (!ecuPortStillAlive) {
                return new Pair<Boolean, CharSequence[]>(true, currentPorts);
            }
            callbacks.log(".", false, false);
        }
        callbacks.log("", true, false);
        return new Pair<Boolean, CharSequence[]>(false, currentPorts);
    }

    private static void flashOpenbltSerialAutomatic(JComponent parent, String ecuPort, UpdateOperationCallbacks callbacks) {
        String[] portsBefore = LinkManager.getCommPorts();
        ProgramSelector.rebootToOpenblt(parent, ecuPort, callbacks);
        Pair<Boolean, String[]> rebootResult = ProgramSelector.waitForEcuPortDisappeared(ecuPort, parent, callbacks);
        boolean ecuPrtDisappeared = (Boolean)rebootResult.first;
        String[] portsAfter = (String[])rebootResult.second;
        if (!ecuPrtDisappeared) {
            callbacks.logLine("Looks like your ECU still haven't rebooted to OpenBLT");
            callbacks.logLine("");
            callbacks.logLine("Try closing and opening console again");
            callbacks.logLine("");
            callbacks.error();
            return;
        }
        ArrayList<String> newItems = new ArrayList<String>();
        for (String s : portsAfter) {
            if (Arrays.stream(portsBefore).anyMatch(s::equals)) continue;
            newItems.add(s);
        }
        if (newItems.isEmpty()) {
            callbacks.logLine("Looks like your ECU disappeared during the update process. Please try again.");
            callbacks.error();
            return;
        }
        if (newItems.size() > 1) {
            callbacks.logLine("Unable to find ECU after reboot as multiple serial ports appeared. Before: " + portsBefore.length + " After: " + portsAfter.length);
            callbacks.error();
            return;
        }
        String openbltPort = (String)newItems.get(0);
        callbacks.logLine("Serial port " + openbltPort + " appeared, programming firmware...");
        ProgramSelector.flashOpenbltSerialJni(parent, openbltPort, callbacks);
    }

    private static OpenbltJni.OpenbltCallbacks makeOpenbltCallbacks(final UpdateOperationCallbacks callbacks) {
        return new OpenbltJni.OpenbltCallbacks(){

            @Override
            public void log(String line) {
                callbacks.logLine(line);
            }

            @Override
            public void updateProgress(int percent) {
                callbacks.logLine("Progress: " + percent + "%");
            }

            @Override
            public void error(String line) {
                throw new RuntimeException(line);
            }

            @Override
            public void setPhase(String title, boolean hasProgress) {
                callbacks.logLine("Phase: " + title);
            }
        };
    }

    private static void showError32bitJava(JComponent parent) {
        JOptionPane.showMessageDialog(parent, "64 bit java required. 32 bit java not supported!", "Error", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flashOpenbltSerialJni(JComponent parent, String port, UpdateOperationCallbacks callbacks) {
        if (FileLog.is32bitJava()) {
            ProgramSelector.showError32bitJava(parent);
            return;
        }
        OpenbltJni.OpenbltCallbacks cb = ProgramSelector.makeOpenbltCallbacks(callbacks);
        try {
            String fileName = FindFileHelper.findSrecFile();
            callbacks.logLine("flashSerial " + fileName);
            OpenbltJni.flashSerial(fileName, port, cb);
            callbacks.logLine("Update completed successfully!");
            callbacks.done();
        }
        catch (Throwable e) {
            callbacks.logLine("Error: " + e.toString());
            callbacks.error();
        }
        finally {
            OpenbltJni.stop(cb);
        }
    }

    @NotNull
    public static JComponent createHelpButton() {
        return new URLLabel("HOWTO Update Firmware", HELP);
    }

    public JPanel getControl() {
        return this.content;
    }

    public void apply(SerialPortScanner.AvailableHardware currentHardware) {
        this.noHardware.setVisible(currentHardware.isEmpty());
        this.updateModeAndButton.setVisible(!currentHardware.isEmpty());
        boolean hasSerialPorts = !currentHardware.getKnownPorts().isEmpty();
        boolean hasDfuDevice = currentHardware.isDfuFound();
        this.updateModeComboBox.removeAllItems();
        if (FileLog.isWindows()) {
            boolean requireBlt = FindFileHelper.isObfuscated();
            if (hasSerialPorts && !requireBlt) {
                this.updateModeComboBox.addItem(AUTO_DFU);
            }
            if (hasDfuDevice && !requireBlt) {
                this.updateModeComboBox.addItem(MANUAL_DFU);
                this.updateModeComboBox.addItem(DFU_ERASE);
                if (DfuFlasher.haveBootloaderBinFile()) {
                    this.updateModeComboBox.addItem(INSTALL_OPENBLT);
                }
            }
            if (!requireBlt) {
                this.updateModeComboBox.addItem(DFU_SWITCH);
            }
            if (currentHardware.isStLinkConnected()) {
                this.updateModeComboBox.addItem(ST_LINK);
            }
            if (currentHardware.isPCANConnected()) {
                this.updateModeComboBox.addItem(OPENBLT_CAN);
            }
        }
        if (hasSerialPorts) {
            this.updateModeComboBox.addItem(OPENBLT_AUTO);
            this.updateModeComboBox.addItem(OPENBLT_SWITCH);
            this.updateModeComboBox.addItem(OPENBLT_MANUAL);
            List listOfBootloaders = currentHardware.getKnownPorts().stream().filter(portResult -> portResult.type == SerialPortScanner.SerialPortType.OpenBlt).collect(Collectors.toList());
            if (!listOfBootloaders.isEmpty()) {
                this.updateModeComboBox.setSelectedItem(OPENBLT_MANUAL);
            }
        }
        UiUtils.trueLayout(this.updateModeComboBox);
        UiUtils.trueLayout(this.content);
    }

    @NotNull
    public static JButton createUpdateFirmwareButton() {
        return new JButton("Update Firmware", AutoupdateUtil.loadIcon("upload48.png"));
    }
}

