/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.NotYetBoundException;
import tel.schich.javacan.AbstractCanChannel;
import tel.schich.javacan.BcmMessage;
import tel.schich.javacan.JavaCAN;
import tel.schich.javacan.NetworkDevice;
import tel.schich.javacan.SocketCAN;
import tel.schich.javacan.platform.linux.LinuxNativeOperationException;
import tel.schich.javacan.platform.linux.LinuxNetworkDevice;

public class BcmCanChannel
extends AbstractCanChannel {
    public static final int MAX_FRAMES_PER_MESSAGE = 256;
    public static final int MTU = BcmMessage.HEADER_LENGTH + 18432;
    private volatile NetworkDevice device;

    BcmCanChannel(int sock) {
        super(sock);
    }

    @Override
    public NetworkDevice getDevice() {
        if (!this.isBound()) {
            throw new NotYetBoundException();
        }
        return this.device;
    }

    @Override
    public boolean isBound() {
        return this.device != null;
    }

    public BcmCanChannel connect(NetworkDevice device) throws IOException {
        if (!(device instanceof LinuxNetworkDevice)) {
            throw new IllegalArgumentException("Unsupported network device given!");
        }
        try {
            SocketCAN.connectSocket(this.getSocket(), ((LinuxNetworkDevice)device).getIndex(), 0, 0);
        }
        catch (LinuxNativeOperationException e) {
            throw BcmCanChannel.checkForClosedChannel(e);
        }
        this.device = device;
        return this;
    }

    public BcmMessage read() throws IOException {
        ByteBuffer frameBuf = JavaCAN.allocateOrdered(MTU);
        return this.read(frameBuf);
    }

    public BcmMessage read(ByteBuffer buffer) throws IOException {
        buffer.order(ByteOrder.nativeOrder());
        this.readSocket(buffer);
        buffer.flip();
        return new BcmMessage(buffer);
    }

    public BcmCanChannel write(BcmMessage message) throws IOException {
        ByteBuffer buffer = message.getBuffer();
        int bytesToWrite = buffer.remaining();
        long written = this.writeSocket(buffer);
        if (written != (long)bytesToWrite) {
            throw new IOException("message incompletely written");
        }
        return this;
    }
}

