/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5;

import com.rusefi.core.FileUtil;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class ConfigurationImage {
    public static final String BIN_HEADER = "OPEN_SR5_0.1";
    private final byte[] content;

    public ConfigurationImage(int size) {
        this.content = new byte[size];
    }

    public ConfigurationImage(byte[] content) {
        this.content = content;
    }

    @NotNull
    public ByteBuffer getByteBuffer(int offset, int size) {
        return FileUtil.littleEndianWrap(this.content, offset, size);
    }

    public int getSize() {
        return this.content.length;
    }

    public static byte[] extractContent(byte[] rom) {
        if (rom.length < BIN_HEADER.length()) {
            return null;
        }
        byte[] result = new byte[rom.length - BIN_HEADER.length()];
        System.arraycopy(rom, BIN_HEADER.length(), result, 0, result.length);
        return result;
    }

    public byte[] getContent() {
        return this.content;
    }

    public ConfigurationImage clone() {
        byte[] copy = (byte[])this.content.clone();
        return new ConfigurationImage(copy);
    }

    public byte[] getRange(int offset, int size) {
        byte[] r = new byte[size];
        System.arraycopy(this.content, offset, r, 0, size);
        return r;
    }

    public String toString() {
        return "ConfigurationImage{size=" + this.content.length + "}";
    }
}

