/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.logview;

import com.rusefi.ConsoleUI;
import com.rusefi.FileLog;
import com.rusefi.core.EngineState;
import com.rusefi.file.FileUtils;
import com.rusefi.ui.ChartRepository;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.engine.EngineSnifferPanel;
import com.rusefi.ui.logview.FileItem;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LogViewer
extends JPanel {
    public static final FileFilter FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().contains("MAIN_rfi_report");
        }
    };
    public static final String DEFAULT_LOG_LOCATION = "logs/";
    private final JLabel folderLabel = new JLabel();
    private final JLabel fileLabel = new JLabel();
    private final DefaultListModel<FileItem> fileListModel = new DefaultListModel();
    private final JList<FileItem> fileList = new JList<FileItem>(this.fileListModel);
    private final UIContext uiContext;
    private final EngineSnifferPanel engineSnifferPanel;
    private String currentFolder;
    private static JPanel descPanel = new JPanel();

    public LogViewer(UIContext uiContext, EngineSnifferPanel engineSnifferPanel) {
        super(new BorderLayout());
        this.uiContext = uiContext;
        this.engineSnifferPanel = engineSnifferPanel;
        this.setBackground(Color.green);
        this.openFolder(DEFAULT_LOG_LOCATION);
        JPanel folderPanel = new JPanel(new FlowLayout());
        JButton folderButton = new JButton("Open folder");
        folderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(LogViewer.this.currentFolder);
                chooser.setFileSelectionMode(1);
                int result = chooser.showSaveDialog(LogViewer.this);
                if (result == 0) {
                    LogViewer.this.openFolder(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        folderPanel.add(folderButton);
        folderPanel.add(this.folderLabel);
        folderPanel.add(this.fileLabel);
        this.add((Component)folderPanel, "North");
        this.refreshCountPanel();
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BoxLayout(boxPanel, 0));
        boxPanel.setBorder(BorderFactory.createLineBorder(Color.cyan));
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FileItem selectedItem = LogViewer.this.fileList.getSelectedValue();
                    LogViewer.this.openFile(selectedItem.getFile());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.fileList);
        boxPanel.add(scrollPane);
        boxPanel.add(descPanel);
        this.add(boxPanel);
    }

    private void refreshCountPanel() {
        descPanel.removeAll();
        descPanel.add(new JLabel("Total digital charts: "));
        descPanel.add(new JLabel("" + ChartRepository.getInstance().getSize()));
        UiUtils.trueRepaint(descPanel);
    }

    private void openFolder(String folderName) {
        this.folderLabel.setText("Current folder: " + folderName);
        this.currentFolder = folderName;
        File folder = new File(folderName);
        if (!folder.isDirectory()) {
            throw new IllegalStateException("Not directory: " + folder);
        }
        Object[] files = folder.listFiles(FILE_FILTER);
        Arrays.sort(files);
        this.fileListModel.removeAllElements();
        for (Object file : files) {
            this.fileListModel.addElement(this.getFileDesc((File)file));
        }
        for (int index = 0; files.length > index && this.uiContext.getLinkManager().isLogViewer(); ++index) {
            Object file = files[index];
            if (((File)file).getName().endsWith(FileLog.currentLogName)) {
                continue;
            }
            this.openFile((File)file);
            break;
        }
    }

    private FileItem getFileDesc(File file) {
        return new FileItem(file);
    }

    private void openFile(File file) {
        this.fileLabel.setText("Current file: " + file.getName());
        String filename = file.getAbsolutePath();
        EngineState.EngineStateListenerImpl listener = new EngineState.EngineStateListenerImpl();
        ChartRepository.getInstance().clear();
        EngineState engineState = new EngineState(listener);
        ConsoleUI.engineSnifferPanel.setOutpinListener(engineState);
        engineState.registerStringValueAction("wave_chart", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String value) {
                FileLog.MAIN.logLine("Got wave_chart: " + value);
                ChartRepository.getInstance().addChart(value);
            }
        });
        FileUtils.readFile2(filename, engineState);
        if (ChartRepository.getInstance().getSize() > 0) {
            this.engineSnifferPanel.reloadFile();
        }
        this.refreshCountPanel();
    }
}

