/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.devexperts.logging.Logging;
import com.rusefi.Listener;
import com.rusefi.io.IMethodInvocation;
import com.rusefi.io.InvocationConfirmationListener;
import com.rusefi.io.LinkManager;
import com.rusefi.util.IoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class CommandQueue {
    private static final Logging log = Logging.getLogging(CommandQueue.class);
    public static final String CONFIRMATION_PREFIX = "confirmation_";
    public static int DEFAULT_TIMEOUT = 500;
    private static final int COMMAND_CONFIRMATION_TIMEOUT = 1000;
    public static final int SLOW_CONFIRMATION_TIMEOUT = 5000;
    public static final Class<CommandQueue> COMMAND_QUEUE_CLASS = CommandQueue.class;
    private final LinkManager linkManager;
    private final BlockingQueue<IMethodInvocation> pendingCommands = new LinkedBlockingQueue<IMethodInvocation>();
    private final List<Consumer<String>> commandListeners = new ArrayList<Consumer<String>>();
    private final Runnable runnable;
    public static Listener<Throwable> ERROR_HANDLER = parameter -> IoUtils.exit("CommandQueue error: " + parameter, -2);

    private static boolean isSlowCommand(String cmd) {
        String lc = cmd.toLowerCase();
        return lc.startsWith("set engine_type") || lc.startsWith("writeconfig") || lc.startsWith("rewriteconfig");
    }

    public static int getTimeout(String cmd) {
        return CommandQueue.isSlowCommand(cmd) ? 5000 : 1000;
    }

    public void addListener(Consumer<String> listener) {
        this.commandListeners.add(listener);
    }

    private void sendPendingCommand() throws InterruptedException {
        @NotNull IMethodInvocation command = this.pendingCommands.take();
        this.sendCommand(command);
    }

    private void sendCommand(IMethodInvocation commandRequest) throws InterruptedException {
        String command = commandRequest.getCommand();
        CountDownLatch cl = new CountDownLatch(1);
        Consumer<String> listener = confirmStr -> {
            if (!command.equals(confirmStr)) {
                throw new IllegalStateException("Was waiting for confirmation of " + command + " but got confirmation for " + confirmStr);
            }
            cl.countDown();
        };
        this.commandListeners.add(listener);
        this.linkManager.send(command, commandRequest.isFireEvent());
        int timeoutMs = commandRequest.getTimeout();
        cl.await(timeoutMs, TimeUnit.MILLISECONDS);
        this.commandListeners.remove(listener);
        if (cl.getCount() != 0L) {
            throw new IllegalStateException("No confirmation received after timeout of " + timeoutMs + " ms");
        }
        commandRequest.getListener().onCommandConfirmation();
    }

    public CommandQueue(final LinkManager linkManager) {
        this.linkManager = linkManager;
        this.runnable = new Runnable(){

            @Override
            public void run() {
                linkManager.messageListener.postMessage(COMMAND_QUEUE_CLASS, "SerialIO started");
                while (true) {
                    try {
                        while (true) {
                            CommandQueue.this.sendPendingCommand();
                        }
                    }
                    catch (Throwable e) {
                        log.error("Major connectivity error", e);
                        ERROR_HANDLER.onResult(e);
                        continue;
                    }
                    break;
                }
            }
        };
        Thread thread = new Thread(this.runnable, "ECU Commands Queue");
        thread.setDaemon(true);
        thread.start();
    }

    public LinkManager getLinkManager() {
        return this.linkManager;
    }

    public void handleConfirmationMessage(String message) {
        String confirmation = LinkManager.unpackConfirmation(message);
        if (confirmation == null) {
            this.linkManager.messageListener.postMessage(CommandQueue.class, "Broken confirmation length: " + message);
        }
        this.commandListeners.forEach(f -> f.accept(confirmation));
        if (LinkManager.LOG_LEVEL.isDebugEnabled()) {
            this.linkManager.messageListener.postMessage(CommandQueue.class, "got valid conf! " + confirmation + ", still pending: " + this.pendingCommands.size());
        }
    }

    public void write(String command) {
        this.write(command, DEFAULT_TIMEOUT);
    }

    public void write(String command, int timeout) {
        this.write(command, timeout, InvocationConfirmationListener.VOID);
    }

    public void write(String command, InvocationConfirmationListener listener) {
        this.write(command, DEFAULT_TIMEOUT, listener, true);
    }

    public void write(String command, int timeoutMs, InvocationConfirmationListener listener) {
        this.write(command, timeoutMs, listener, true);
    }

    public void write(String command, int timeoutMs, InvocationConfirmationListener listener, boolean fireEvent) {
        if (fireEvent) {
            this.commandListeners.forEach(c -> c.accept(command));
        }
        this.pendingCommands.add(new MethodInvocation(command, timeoutMs, listener, fireEvent));
    }

    public void addIfNotPresent(IMethodInvocation commandSender) {
        if (!this.pendingCommands.contains(commandSender)) {
            this.pendingCommands.add(commandSender);
        }
    }

    static class MethodInvocation
    implements IMethodInvocation {
        private final String command;
        private final int timeoutMs;
        private final InvocationConfirmationListener listener;
        private final boolean fireEvent;

        MethodInvocation(String command, int timeoutMs, InvocationConfirmationListener listener, boolean fireEvent) {
            this.command = command;
            this.timeoutMs = timeoutMs;
            this.listener = listener;
            this.fireEvent = fireEvent;
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public int getTimeout() {
            return this.timeoutMs;
        }

        @Override
        public InvocationConfirmationListener getListener() {
            return this.listener;
        }

        @Override
        public boolean isFireEvent() {
            return this.fireEvent;
        }

        public String toString() {
            return "MethodInvocation{timeoutMs=" + this.timeoutMs + ", command='" + this.command + "'}";
        }
    }
}

