/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.FrameType;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.GradientWrapper;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Scaler;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.Shadow;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public final class Radial2Top
extends AbstractRadial {
    private static final int BASE = 10;
    private final double FREE_AREA_ANGLE = Math.toRadians(0.0);
    private final double ROTATION_OFFSET = 4.71238898038469 + this.FREE_AREA_ANGLE / 2.0;
    private final Point2D CENTER;
    private final Point2D TRACK_OFFSET;
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage disabledImage;
    private boolean section3DEffectVisible;
    private RadialGradientPaint section3DEffect;
    private boolean area3DEffectVisible;
    private RadialGradientPaint area3DEffect;
    private double angle = 0.0;
    private final Color DARK_NOISE;
    private final Color BRIGHT_NOISE;

    public Radial2Top() {
        this.CENTER = new Point2D.Double();
        this.TRACK_OFFSET = new Point2D.Double();
        this.DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
        this.BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
        this.section3DEffectVisible = false;
        this.area3DEffectVisible = false;
        this.setGaugeType(GaugeType.TYPE2);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Radial2Top(Model MODEL) {
        this.setModel(MODEL);
        this.CENTER = new Point2D.Double();
        this.TRACK_OFFSET = new Point2D.Double();
        this.DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
        this.BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
        this.section3DEffectVisible = false;
        this.area3DEffectVisible = false;
        this.setGaugeType(GaugeType.TYPE2);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            this.create_FRAME_Image(GAUGE_WIDTH, this.bImage);
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(GAUGE_WIDTH, "", "", this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(GAUGE_WIDTH, this.getGlowColor(), false);
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(GAUGE_WIDTH, this.getGlowColor(), true);
        } else {
            this.setGlowPulsating(false);
        }
        this.create_POSTS_Image(GAUGE_WIDTH, this.fImage);
        this.TRACK_OFFSET.setLocation(0.0, 0.0);
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, this.getGaugeBounds().getCenterX() - (double)this.getInsets().top);
        if (this.isTrackVisible()) {
            this.create_TRACK_Image(GAUGE_WIDTH, this.getFreeAreaAngle(), this.getTickmarkOffset(), this.getMinValue(), this.getMaxValue(), this.getAngleStep(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), 0.38f, this.CENTER, this.getTickmarkDirection(), this.TRACK_OFFSET, this.bImage);
        }
        if (!this.getAreas().isEmpty()) {
            if (this.area3DEffectVisible) {
                this.area3DEffect = this.createArea3DEffectGradient(GAUGE_WIDTH, 0.38f);
            }
            this.createAreas(this.bImage);
        }
        if (!this.getSections().isEmpty()) {
            if (this.section3DEffectVisible) {
                this.section3DEffect = this.createSection3DEffectGradient(GAUGE_WIDTH, 0.38f);
            }
            this.createSections(this.bImage);
        }
        TICKMARK_FACTORY.create_RADIAL_TICKMARKS_Image(GAUGE_WIDTH, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getGaugeType(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), this.isSectionTickmarksOnly(), this.getSections(), 0.38f, 0.09f, this.CENTER, new Point2D.Double(0.0, 0.0), Orientation.NORTH, this.getModel().getTicklabelOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        this.create_TITLE_Image(GAUGE_WIDTH, this.getTitle(), this.getUnitString(), this.bImage);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(GAUGE_WIDTH, this.getPointerType());
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.getModel().isPointerShadowVisible() ? this.create_POINTER_SHADOW_Image(GAUGE_WIDTH, this.getPointerType()) : null;
        if (this.isForegroundVisible()) {
            FOREGROUND_FACTORY.createRadialForeground(GAUGE_WIDTH, false, this.getForegroundType(), this.fImage);
        }
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(GAUGE_WIDTH);
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(GAUGE_WIDTH, new Color(0, 23, 252, 255));
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(GAUGE_WIDTH, new Color(252, 29, 0, 255));
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isHighlightArea()) {
            for (Section area : this.getAreas()) {
                if (!area.contains(this.getValue())) continue;
                G2.setColor(area.getHighlightColor());
                G2.fill(area.getFilledArea());
                break;
            }
        }
        if (this.isHighlightSection()) {
            for (Section section : this.getSections()) {
                if (!section.contains(this.getValue())) continue;
                G2.setColor(section.getHighlightColor());
                G2.fill(section.getSectionArea());
                break;
            }
        }
        if (this.isThresholdVisible()) {
            if (!this.isLogScale()) {
                G2.rotate(this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                G2.rotate(this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            G2.drawImage((Image)this.thresholdImage, (int)((double)this.getGaugeBounds().width * 0.480369999), (int)((double)this.getGaugeBounds().height * 0.13), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMinMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                G2.rotate(this.ROTATION_OFFSET + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                G2.rotate(this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            G2.drawImage((Image)this.minMeasuredImage, (int)((double)this.getGaugeBounds().width * 0.4865), (int)((double)this.getGaugeBounds().height * 0.105), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMaxMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                G2.rotate(this.ROTATION_OFFSET + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                G2.rotate(this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            G2.drawImage((Image)this.maxMeasuredImage, (int)((double)this.getGaugeBounds().width * 0.4865), (int)((double)this.getGaugeBounds().height * 0.105), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isLedVisible()) {
            G2.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            G2.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getUserLedPosition().getY()), null);
        }
        this.angle = !this.isLogScale() ? this.ROTATION_OFFSET + (this.getValue() - this.getMinValue()) * this.getAngleStep() : this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * this.getLogAngleStep();
        G2.rotate(this.angle, this.CENTER.getX(), this.CENTER.getY() + 2.0);
        G2.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(this.angle, this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.pointerImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                G2.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                G2.drawImage((Image)this.glowImageOn, 0, 0, null);
                G2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                G2.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.dispose();
    }

    @Override
    public FrameType getFrameType() {
        return FrameType.ROUND;
    }

    @Override
    public GaugeType getGaugeType() {
        return GaugeType.TYPE2;
    }

    @Override
    public void setGaugeType(GaugeType GAUGE_TYPE) {
        super.setGaugeType(GaugeType.TYPE2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    public boolean isSection3DEffectVisible() {
        return this.section3DEffectVisible;
    }

    public void setSection3DEffectVisible(boolean SECTION_3D_EFFECT_VISIBLE) {
        this.section3DEffectVisible = SECTION_3D_EFFECT_VISIBLE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isArea3DEffectVisible() {
        return this.area3DEffectVisible;
    }

    public void setArea3DEffectVisible(boolean AREA_3DEFFECT_VISIBLE) {
        this.area3DEffectVisible = AREA_3DEFFECT_VISIBLE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    private void createAreas(BufferedImage IMAGE) {
        if (!this.getAreas().isEmpty() && this.bImage != null) {
            double ORIGIN_CORRECTION = 180.0;
            double OUTER_RADIUS = (float)this.bImage.getWidth() * 0.38f;
            double RADIUS = this.isSectionsVisible() ? (this.isExpandedSectionsEnabled() ? OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.12f) : OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.04f)) : OUTER_RADIUS;
            double FREE_AREA = (double)this.bImage.getWidth() / 2.0 - RADIUS;
            for (Section area : this.getAreas()) {
                double ANGLE_EXTEND;
                double ANGLE_START;
                if (!this.isLogScale()) {
                    ANGLE_START = 180.0 - area.getStart() * Math.toDegrees(this.getAngleStep());
                    ANGLE_EXTEND = -(area.getStop() - area.getStart()) * Math.toDegrees(this.getAngleStep());
                } else {
                    ANGLE_START = 180.0 - UTIL.logOfBase(10.0, area.getStart()) * Math.toDegrees(this.getLogAngleStep());
                    ANGLE_EXTEND = -UTIL.logOfBase(10.0, area.getStop() - area.getStart()) * Math.toDegrees(this.getLogAngleStep());
                }
                Arc2D.Double AREA = new Arc2D.Double(2);
                AREA.setFrame((double)this.bImage.getMinX() + FREE_AREA, (double)this.bImage.getMinY() + FREE_AREA, 2.0 * RADIUS, 2.0 * RADIUS);
                ((Arc2D)AREA).setAngleStart(ANGLE_START);
                ((Arc2D)AREA).setAngleExtent(ANGLE_EXTEND);
                area.setFilledArea(AREA);
            }
            if (this.isAreasVisible() && IMAGE != null) {
                Graphics2D G2 = IMAGE.createGraphics();
                G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section area : this.getAreas()) {
                    G2.setColor(this.isTransparentAreasEnabled() ? area.getTransparentColor() : area.getColor());
                    G2.fill(area.getFilledArea());
                    if (!this.area3DEffectVisible) continue;
                    G2.setPaint(this.area3DEffect);
                    G2.fill(area.getFilledArea());
                }
                G2.dispose();
            }
        }
    }

    private void createSections(BufferedImage IMAGE) {
        if (!this.getSections().isEmpty() && this.bImage != null) {
            double ORIGIN_CORRECTION = 180.0;
            double OUTER_RADIUS = (float)this.bImage.getWidth() * 0.38f;
            double INNER_RADIUS = this.isExpandedSectionsEnabled() ? OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.12f) : OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.04f);
            double FREE_AREA_OUTER_RADIUS = (double)this.bImage.getWidth() / 2.0 - OUTER_RADIUS;
            double FREE_AREA_INNER_RADIUS = (double)this.bImage.getWidth() / 2.0 - INNER_RADIUS;
            Ellipse2D.Double INNER = new Ellipse2D.Double((double)this.bImage.getMinX() + FREE_AREA_INNER_RADIUS, (double)this.bImage.getMinY() + FREE_AREA_INNER_RADIUS, 2.0 * INNER_RADIUS, 2.0 * INNER_RADIUS);
            for (Section section : this.getSections()) {
                double ANGLE_EXTEND;
                double ANGLE_START;
                if (!this.isLogScale()) {
                    ANGLE_START = 180.0 - section.getStart() * Math.toDegrees(this.getAngleStep());
                    ANGLE_EXTEND = -(section.getStop() - section.getStart()) * Math.toDegrees(this.getAngleStep());
                } else {
                    ANGLE_START = 180.0 - UTIL.logOfBase(10.0, section.getStart()) * Math.toDegrees(this.getLogAngleStep());
                    ANGLE_EXTEND = -UTIL.logOfBase(10.0, section.getStop() - section.getStart()) * Math.toDegrees(this.getLogAngleStep());
                }
                Arc2D.Double OUTER_ARC = new Arc2D.Double(2);
                OUTER_ARC.setFrame((double)this.bImage.getMinX() + FREE_AREA_OUTER_RADIUS, (double)this.bImage.getMinY() + FREE_AREA_OUTER_RADIUS, 2.0 * OUTER_RADIUS, 2.0 * OUTER_RADIUS);
                ((Arc2D)OUTER_ARC).setAngleStart(ANGLE_START);
                ((Arc2D)OUTER_ARC).setAngleExtent(ANGLE_EXTEND);
                Area SECTION = new Area(OUTER_ARC);
                SECTION.subtract(new Area(INNER));
                section.setSectionArea(SECTION);
            }
            if (this.isSectionsVisible() && IMAGE != null) {
                Graphics2D G2 = IMAGE.createGraphics();
                G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getSections()) {
                    G2.setColor(this.isTransparentSectionsEnabled() ? section.getTransparentColor() : section.getColor());
                    G2.fill(section.getSectionArea());
                    if (!this.section3DEffectVisible) continue;
                    G2.setPaint(this.section3DEffect);
                    G2.fill(section.getSectionArea());
                }
                G2.dispose();
            }
        }
    }

    private BufferedImage create_FRAME_Image(int WIDTH, BufferedImage image) {
        double VERTICAL_SCALE;
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, (int)(0.641860465116279 * (double)WIDTH), 3);
            VERTICAL_SCALE = 1.0;
        } else {
            VERTICAL_SCALE = 0.641860465116279;
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        GeneralPath SUBTRACT_PATH = new GeneralPath();
        SUBTRACT_PATH.setWindingRule(0);
        SUBTRACT_PATH.moveTo((double)IMAGE_WIDTH * 0.08372093023255814, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        SUBTRACT_PATH.curveTo((double)IMAGE_WIDTH * 0.08372093023255814, (double)IMAGE_HEIGHT * 0.42028985507246375 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.26976744186046514, (double)IMAGE_HEIGHT * 0.13043478260869565 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.49767441860465117, (double)IMAGE_HEIGHT * 0.13043478260869565 * VERTICAL_SCALE);
        SUBTRACT_PATH.curveTo((double)IMAGE_WIDTH * 0.7255813953488373, (double)IMAGE_HEIGHT * 0.13043478260869565 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9116279069767442, (double)IMAGE_HEIGHT * 0.42028985507246375 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9116279069767442, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        SUBTRACT_PATH.curveTo((double)IMAGE_WIDTH * 0.9116279069767442, (double)IMAGE_HEIGHT * 0.8188405797101449 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9069767441860465, (double)IMAGE_HEIGHT * 0.8695652173913043 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9069767441860465, (double)IMAGE_HEIGHT * 0.8695652173913043 * VERTICAL_SCALE);
        SUBTRACT_PATH.lineTo((double)IMAGE_WIDTH * 0.08837209302325581, (double)IMAGE_HEIGHT * 0.8695652173913043 * VERTICAL_SCALE);
        SUBTRACT_PATH.curveTo((double)IMAGE_WIDTH * 0.08837209302325581, (double)IMAGE_HEIGHT * 0.8695652173913043 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.08372093023255814, (double)IMAGE_HEIGHT * 0.8115942028985508 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.08372093023255814, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        SUBTRACT_PATH.closePath();
        Area SUBTRACT = new Area(SUBTRACT_PATH);
        GeneralPath FRAME_OUTERFRAME = new GeneralPath();
        FRAME_OUTERFRAME.setWindingRule(0);
        FRAME_OUTERFRAME.moveTo(0.0, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        FRAME_OUTERFRAME.curveTo(0.0, (double)IMAGE_HEIGHT * 0.34782608695652173 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.22325581395348837, 0.0, (double)IMAGE_WIDTH * 0.49767441860465117, 0.0);
        FRAME_OUTERFRAME.curveTo((double)IMAGE_WIDTH * 0.772093023255814, 0.0, (double)IMAGE_WIDTH, (double)IMAGE_HEIGHT * 0.34782608695652173 * VERTICAL_SCALE, (double)IMAGE_WIDTH, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        FRAME_OUTERFRAME.curveTo((double)IMAGE_WIDTH, (double)IMAGE_HEIGHT * 0.9057971014492754 * VERTICAL_SCALE, (double)IMAGE_WIDTH, (double)IMAGE_HEIGHT, (double)IMAGE_WIDTH, (double)IMAGE_HEIGHT * VERTICAL_SCALE);
        FRAME_OUTERFRAME.lineTo(0.0, (double)IMAGE_HEIGHT * VERTICAL_SCALE);
        FRAME_OUTERFRAME.curveTo(0.0, (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.0, (double)IMAGE_HEIGHT * 0.8985507246376812 * VERTICAL_SCALE, 0.0, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        FRAME_OUTERFRAME.closePath();
        G2.setPaint(this.getOuterFrameColor());
        Area FRAME_OUTERFRAME_AREA = new Area(FRAME_OUTERFRAME);
        FRAME_OUTERFRAME_AREA.subtract(SUBTRACT);
        G2.fill(FRAME_OUTERFRAME_AREA);
        GeneralPath FRAME_MAIN = new GeneralPath();
        FRAME_MAIN.setWindingRule(0);
        FRAME_MAIN.moveTo((double)IMAGE_WIDTH * 0.004651162790697674, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        FRAME_MAIN.curveTo((double)IMAGE_WIDTH * 0.004651162790697674, (double)IMAGE_HEIGHT * 0.34782608695652173 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.22325581395348837, (double)IMAGE_HEIGHT * 0.007246376811594203 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.49767441860465117, (double)IMAGE_HEIGHT * 0.007246376811594203 * VERTICAL_SCALE);
        FRAME_MAIN.curveTo((double)IMAGE_WIDTH * 0.772093023255814, (double)IMAGE_HEIGHT * 0.007246376811594203 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9953488372093023, (double)IMAGE_HEIGHT * 0.35507246376811596 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9953488372093023, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        FRAME_MAIN.curveTo((double)IMAGE_WIDTH * 0.9953488372093023, (double)IMAGE_HEIGHT * 0.8840579710144928 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9953488372093023, (double)IMAGE_HEIGHT * 0.9927536231884058 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9953488372093023, (double)IMAGE_HEIGHT * 0.9927536231884058 * VERTICAL_SCALE);
        FRAME_MAIN.lineTo((double)IMAGE_WIDTH * 0.004651162790697674, (double)IMAGE_HEIGHT * 0.9927536231884058 * VERTICAL_SCALE);
        FRAME_MAIN.curveTo((double)IMAGE_WIDTH * 0.004651162790697674, (double)IMAGE_HEIGHT * 0.9927536231884058 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.004651162790697674, (double)IMAGE_HEIGHT * 0.8840579710144928 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.004651162790697674, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        FRAME_MAIN.closePath();
        Point2D.Double FRAME_MAIN_START = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMinY());
        Point2D.Double FRAME_MAIN_STOP = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMaxY());
        Point2D.Double FRAME_MAIN_CENTER = new Point2D.Double(FRAME_MAIN.getBounds2D().getCenterX(), FRAME_MAIN.getBounds2D().getHeight() * 0.7753623188 * VERTICAL_SCALE);
        Area FRAME_MAIN_AREA = new Area(FRAME_MAIN);
        if (this.getFrameDesign() == FrameDesign.CUSTOM) {
            G2.setPaint(this.getCustomFrameDesign());
            FRAME_MAIN_AREA.subtract(SUBTRACT);
            G2.fill(FRAME_MAIN_AREA);
        } else {
            switch (this.getFrameDesign()) {
                case BLACK_METAL: {
                    float[] frameMainFractions1 = new float[]{0.0f, 45.0f, 85.0f, 180.0f, 275.0f, 315.0f, 360.0f};
                    Color[] frameMainColors1 = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                    ConicalGradientPaint frameMainGradient1 = new ConicalGradientPaint(true, FRAME_MAIN_CENTER, 0.0f, frameMainFractions1, frameMainColors1);
                    G2.setPaint(frameMainGradient1);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case METAL: {
                    float[] frameMainFractions2 = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] frameMainColors2 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint frameMainGradient2 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions2, frameMainColors2);
                    G2.setPaint(frameMainGradient2);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case SHINY_METAL: {
                    Color[] frameMainColors3;
                    float[] frameMainFractions3;
                    if (this.isFrameBaseColorEnabled()) {
                        frameMainFractions3 = new float[]{0.0f, 45.0f, 90.0f, 135.0f, 180.0f, 225.0f, 270.0f, 315.0f, 360.0f};
                        frameMainColors3 = new Color[]{new Color(254, 254, 254, 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().brighter().brighter().getRed(), this.getFrameBaseColor().brighter().brighter().getGreen(), this.getFrameBaseColor().brighter().brighter().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().brighter().brighter().getRed(), this.getFrameBaseColor().brighter().brighter().getGreen(), this.getFrameBaseColor().brighter().brighter().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(254, 254, 254, 255)};
                    } else {
                        frameMainFractions3 = new float[]{0.0f, 45.0f, 90.0f, 95.0f, 180.0f, 265.0f, 270.0f, 315.0f, 360.0f};
                        frameMainColors3 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(160, 160, 160, 255), new Color(160, 160, 160, 255), new Color(160, 160, 160, 255), new Color(179, 179, 179, 255), new Color(210, 210, 210, 255), new Color(254, 254, 254, 255)};
                    }
                    ConicalGradientPaint frameMainGradient3 = new ConicalGradientPaint(true, FRAME_MAIN_CENTER, 0.0f, frameMainFractions3, frameMainColors3);
                    G2.setPaint(frameMainGradient3);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case GLOSSY_METAL: {
                    GeneralPath FRAME_MAIN_GLOSSY1 = new GeneralPath();
                    FRAME_MAIN_GLOSSY1.setWindingRule(0);
                    FRAME_MAIN_GLOSSY1.moveTo(0.004672897196261682 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY1.curveTo(0.004672897196261682 * (double)IMAGE_WIDTH, 0.35036496350364965 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.22429906542056074 * (double)IMAGE_WIDTH, 0.0072992700729927005 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.5 * (double)IMAGE_WIDTH, 0.0072992700729927005 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY1.curveTo(0.7710280373831776 * (double)IMAGE_WIDTH, 0.0072992700729927005 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9953271028037384 * (double)IMAGE_WIDTH, 0.35036496350364965 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9953271028037384 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY1.curveTo(0.9953271028037384 * (double)IMAGE_WIDTH, 0.8832116788321168 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9953271028037384 * (double)IMAGE_WIDTH, 0.9927007299270073 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9953271028037384 * (double)IMAGE_WIDTH, 0.9927007299270073 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY1.lineTo(0.004672897196261682 * (double)IMAGE_WIDTH, 0.9927007299270073 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY1.curveTo(0.004672897196261682 * (double)IMAGE_WIDTH, 0.9927007299270073 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.004672897196261682 * (double)IMAGE_WIDTH, 0.8832116788321168 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.004672897196261682 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY1.closePath();
                    Area FRAME_MAIN_GLOSSY_1 = new Area(FRAME_MAIN_GLOSSY1);
                    FRAME_MAIN_GLOSSY_1.subtract(SUBTRACT);
                    G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.9927007299270073 * (double)IMAGE_HEIGHT * VERTICAL_SCALE), (float)(0.4953271028037383 * (double)IMAGE_WIDTH), new float[]{0.0f, 0.01f, 0.95f, 1.0f}, new Color[]{new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(0.99607843f, 0.99607843f, 0.99607843f, 1.0f)}));
                    G2.fill(FRAME_MAIN_GLOSSY_1);
                    GeneralPath FRAME_MAIN_GLOSSY2 = new GeneralPath();
                    FRAME_MAIN_GLOSSY2.setWindingRule(0);
                    FRAME_MAIN_GLOSSY2.moveTo(0.014018691588785047 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY2.curveTo(0.014018691588785047 * (double)IMAGE_WIDTH, 0.36496350364963503 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.22429906542056074 * (double)IMAGE_WIDTH, 0.021897810218978103 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.5 * (double)IMAGE_WIDTH, 0.021897810218978103 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY2.curveTo(0.7710280373831776 * (double)IMAGE_WIDTH, 0.021897810218978103 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.985981308411215 * (double)IMAGE_WIDTH, 0.36496350364963503 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.985981308411215 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY2.curveTo(0.985981308411215 * (double)IMAGE_WIDTH, 0.8832116788321168 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.985981308411215 * (double)IMAGE_WIDTH, 0.9781021897810219 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.985981308411215 * (double)IMAGE_WIDTH, 0.9781021897810219 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY2.lineTo(0.014018691588785047 * (double)IMAGE_WIDTH, 0.9781021897810219 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY2.curveTo(0.014018691588785047 * (double)IMAGE_WIDTH, 0.9781021897810219 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.014018691588785047 * (double)IMAGE_WIDTH, 0.8832116788321168 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.014018691588785047 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY2.closePath();
                    Area FRAME_MAIN_GLOSSY_2 = new Area(FRAME_MAIN_GLOSSY2);
                    FRAME_MAIN_GLOSSY_2.subtract(SUBTRACT);
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.0072992700729927005 * (double)IMAGE_HEIGHT * VERTICAL_SCALE), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT * VERTICAL_SCALE), new float[]{0.0f, 0.24f, 0.34f, 0.65f, 0.85f, 1.0f}, new Color[]{new Color(0.9764706f, 0.9764706f, 0.9764706f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), new Color(0.9882353f, 0.9882353f, 0.9882353f, 1.0f), new Color(0.12156863f, 0.12156863f, 0.12156863f, 1.0f), new Color(0.78431374f, 0.7607843f, 0.7529412f, 1.0f), new Color(0.8156863f, 0.8156863f, 0.8156863f, 1.0f)}));
                    G2.fill(FRAME_MAIN_GLOSSY_2);
                    GeneralPath FRAME_MAIN_GLOSSY3 = new GeneralPath();
                    FRAME_MAIN_GLOSSY3.setWindingRule(0);
                    FRAME_MAIN_GLOSSY3.moveTo(0.07009345794392523 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY3.curveTo(0.07009345794392523 * (double)IMAGE_WIDTH, 0.39416058394160586 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.26635514018691586 * (double)IMAGE_WIDTH, 0.10948905109489052 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.5 * (double)IMAGE_WIDTH, 0.10948905109489052 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY3.curveTo(0.7289719626168224 * (double)IMAGE_WIDTH, 0.10948905109489052 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9252336448598131 * (double)IMAGE_WIDTH, 0.38686131386861317 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9252336448598131 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY3.curveTo(0.9252336448598131 * (double)IMAGE_WIDTH, 0.8102189781021898 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9158878504672897 * (double)IMAGE_WIDTH, 0.8905109489051095 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9158878504672897 * (double)IMAGE_WIDTH, 0.8905109489051095 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY3.lineTo(0.07476635514018691 * (double)IMAGE_WIDTH, 0.8905109489051095 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY3.curveTo(0.07476635514018691 * (double)IMAGE_WIDTH, 0.8905109489051095 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.07009345794392523 * (double)IMAGE_WIDTH, 0.8102189781021898 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.07009345794392523 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY3.closePath();
                    Area FRAME_MAIN_GLOSSY_3 = new Area(FRAME_MAIN_GLOSSY3);
                    FRAME_MAIN_GLOSSY_3.subtract(SUBTRACT);
                    G2.setPaint(new Color(0.9647059f, 0.9647059f, 0.9647059f, 1.0f));
                    G2.fill(FRAME_MAIN_GLOSSY_3);
                    GeneralPath FRAME_MAIN_GLOSSY4 = new GeneralPath();
                    FRAME_MAIN_GLOSSY4.setWindingRule(0);
                    FRAME_MAIN_GLOSSY4.moveTo(0.07476635514018691 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY4.curveTo(0.07476635514018691 * (double)IMAGE_WIDTH, 0.41605839416058393 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.26635514018691586 * (double)IMAGE_WIDTH, 0.11678832116788321 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.5 * (double)IMAGE_WIDTH, 0.11678832116788321 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY4.curveTo(0.7289719626168224 * (double)IMAGE_WIDTH, 0.11678832116788321 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9205607476635514 * (double)IMAGE_WIDTH, 0.41605839416058393 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9205607476635514 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY4.curveTo(0.9205607476635514 * (double)IMAGE_WIDTH, 0.8102189781021898 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9112149532710281 * (double)IMAGE_WIDTH, 0.8832116788321168 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.9112149532710281 * (double)IMAGE_WIDTH, 0.8832116788321168 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY4.lineTo(0.0794392523364486 * (double)IMAGE_WIDTH, 0.8832116788321168 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY4.curveTo(0.0794392523364486 * (double)IMAGE_WIDTH, 0.8832116788321168 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.07476635514018691 * (double)IMAGE_WIDTH, 0.8102189781021898 * (double)IMAGE_HEIGHT * VERTICAL_SCALE, 0.07476635514018691 * (double)IMAGE_WIDTH, 0.7737226277372263 * (double)IMAGE_HEIGHT * VERTICAL_SCALE);
                    FRAME_MAIN_GLOSSY4.closePath();
                    Area FRAME_MAIN_GLOSSY_4 = new Area(FRAME_MAIN_GLOSSY4);
                    FRAME_MAIN_GLOSSY_4.subtract(SUBTRACT);
                    G2.setPaint(new Color(0.2f, 0.2f, 0.2f, 1.0f));
                    G2.fill(FRAME_MAIN_GLOSSY_4);
                    break;
                }
                case BRASS: {
                    float[] frameMainFractions5 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] frameMainColors5 = new Color[]{new Color(249, 243, 155, 255), new Color(246, 226, 101, 255), new Color(240, 225, 132, 255), new Color(90, 57, 22, 255), new Color(249, 237, 139, 255), new Color(243, 226, 108, 255), new Color(202, 182, 113, 255)};
                    LinearGradientPaint frameMainGradient5 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions5, frameMainColors5);
                    G2.setPaint(frameMainGradient5);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case STEEL: {
                    float[] frameMainFractions6 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] frameMainColors6 = new Color[]{new Color(231, 237, 237, 255), new Color(189, 199, 198, 255), new Color(192, 201, 200, 255), new Color(23, 31, 33, 255), new Color(196, 205, 204, 255), new Color(194, 204, 203, 255), new Color(189, 201, 199, 255)};
                    LinearGradientPaint frameMainGradient6 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions6, frameMainColors6);
                    G2.setPaint(frameMainGradient6);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case CHROME: {
                    float[] frameMainFractions7 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.63f, 0.68f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] frameMainColors7 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint frameMainGradient7 = new ConicalGradientPaint(false, FRAME_MAIN_CENTER, 0.0f, frameMainFractions7, frameMainColors7);
                    G2.setPaint(frameMainGradient7);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case GOLD: {
                    float[] frameMainFractions8 = new float[]{0.0f, 0.15f, 0.22f, 0.3f, 0.38f, 0.44f, 0.51f, 0.6f, 0.68f, 0.75f, 1.0f};
                    Color[] frameMainColors8 = new Color[]{new Color(255, 255, 207, 255), new Color(255, 237, 96, 255), new Color(254, 199, 57, 255), new Color(255, 249, 203, 255), new Color(255, 199, 64, 255), new Color(252, 194, 60, 255), new Color(255, 204, 59, 255), new Color(213, 134, 29, 255), new Color(255, 201, 56, 255), new Color(212, 135, 29, 255), new Color(247, 238, 101, 255)};
                    LinearGradientPaint frameMainGradient8 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions8, frameMainColors8);
                    G2.setPaint(frameMainGradient8);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case ANTHRACITE: {
                    float[] frameMainFractions9 = new float[]{0.0f, 0.06f, 0.12f, 1.0f};
                    Color[] frameMainColors9 = new Color[]{new Color(118, 117, 135, 255), new Color(74, 74, 82, 255), new Color(50, 50, 54, 255), new Color(97, 97, 108, 255)};
                    LinearGradientPaint frameMainGradient9 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions9, frameMainColors9);
                    G2.setPaint(frameMainGradient9);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case TILTED_GRAY: {
                    ((Point2D)FRAME_MAIN_START).setLocation(0.2336448598130841 * (double)IMAGE_WIDTH, 0.08411214953271028 * (double)IMAGE_HEIGHT);
                    ((Point2D)FRAME_MAIN_STOP).setLocation(0.8125818236066633 * (double)IMAGE_WIDTH, 0.9109198204038422 * (double)IMAGE_HEIGHT);
                    float[] frameMainFractions10 = new float[]{0.0f, 0.07f, 0.16f, 0.33f, 0.55f, 0.79f, 1.0f};
                    Color[] frameMainColors10 = new Color[]{new Color(255, 255, 255, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(255, 255, 255, 255), new Color(197, 197, 197, 255), new Color(255, 255, 255, 255), new Color(102, 102, 102, 255)};
                    LinearGradientPaint frameMainGradient10 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions10, frameMainColors10);
                    G2.setPaint(frameMainGradient10);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case TILTED_BLACK: {
                    ((Point2D)FRAME_MAIN_START).setLocation(0.22897196261682243 * (double)IMAGE_WIDTH, 0.0794392523364486 * (double)IMAGE_HEIGHT);
                    ((Point2D)FRAME_MAIN_STOP).setLocation(0.8025483989678684 * (double)IMAGE_WIDTH, 0.8985912966254403 * (double)IMAGE_HEIGHT);
                    float[] frameMainFractions11 = new float[]{0.0f, 0.21f, 0.47f, 0.99f, 1.0f};
                    Color[] frameMainColors11 = new Color[]{new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
                    LinearGradientPaint frameMainGradient11 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions11, frameMainColors11);
                    G2.setPaint(frameMainGradient11);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                default: {
                    float[] frameMainFractions = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] frameMainColors = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint frameMainGradient = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions, frameMainColors);
                    G2.setPaint(frameMainGradient);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                }
            }
        }
        GeneralPath FRAME_INNERFRAME = new GeneralPath();
        FRAME_INNERFRAME.setWindingRule(0);
        FRAME_INNERFRAME.moveTo((double)IMAGE_WIDTH * 0.07906976744186046, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        FRAME_INNERFRAME.curveTo((double)IMAGE_WIDTH * 0.07906976744186046, (double)IMAGE_HEIGHT * 0.41304347826086957 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.2651162790697674, (double)IMAGE_HEIGHT * 0.12318840579710146 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.49767441860465117, (double)IMAGE_HEIGHT * 0.12318840579710146 * VERTICAL_SCALE);
        FRAME_INNERFRAME.curveTo((double)IMAGE_WIDTH * 0.7302325581395349, (double)IMAGE_HEIGHT * 0.12318840579710146 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9162790697674419, (double)IMAGE_HEIGHT * 0.41304347826086957 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9162790697674419, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        FRAME_INNERFRAME.curveTo((double)IMAGE_WIDTH * 0.9162790697674419, (double)IMAGE_HEIGHT * 0.8115942028985508 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9069767441860465, (double)IMAGE_HEIGHT * 0.8768115942028986 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9069767441860465, (double)IMAGE_HEIGHT * 0.8768115942028986 * VERTICAL_SCALE);
        FRAME_INNERFRAME.lineTo((double)IMAGE_WIDTH * 0.08837209302325581, (double)IMAGE_HEIGHT * 0.8768115942028986 * VERTICAL_SCALE);
        FRAME_INNERFRAME.curveTo((double)IMAGE_WIDTH * 0.08837209302325581, (double)IMAGE_HEIGHT * 0.8768115942028986 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.07906976744186046, (double)IMAGE_HEIGHT * 0.8115942028985508 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.07906976744186046, (double)IMAGE_HEIGHT * 0.7753623188405797 * VERTICAL_SCALE);
        FRAME_INNERFRAME.closePath();
        G2.setPaint(this.getInnerFrameColor());
        Area FRAME_INNERFRAME_AREA = new Area(FRAME_INNERFRAME);
        FRAME_INNERFRAME_AREA.subtract(SUBTRACT);
        G2.fill(FRAME_INNERFRAME_AREA);
        float scale = 1.0f;
        Shape[] EFFECT = new Shape[100];
        switch (this.getFrameEffect()) {
            case EFFECT_BULGE: {
                int i;
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.13f, 0.14f, 0.17f, 0.18f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 102), new Color(255, 255, 255, 151), new Color(219, 219, 219, 153), new Color(0, 0, 0, 95), new Color(0, 0, 0, 76), new Color(0, 0, 0, 0)};
                GradientWrapper EFFECT_GRADIENT = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), EFFECT_FRACTIONS, EFFECT_COLORS);
                for (i = 0; i < 100; ++i) {
                    EFFECT[i] = Scaler.INSTANCE.scale(FRAME_MAIN_AREA, scale);
                    scale -= 0.01f;
                }
                G2.setStroke(new BasicStroke(1.5f));
                for (i = 0; i < EFFECT.length; ++i) {
                    G2.setPaint(EFFECT_GRADIENT.getColorAt((float)i / 100.0f));
                    G2.draw(EFFECT[i]);
                }
                break;
            }
            case EFFECT_CONE: {
                int i;
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.0399f, 0.04f, 0.1799f, 0.18f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 76), new Color(223, 223, 223, 127), new Color(255, 255, 255, 124), new Color(9, 9, 9, 51), new Color(0, 0, 0, 50), new Color(0, 0, 0, 0)};
                GradientWrapper EFFECT_GRADIENT = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), EFFECT_FRACTIONS, EFFECT_COLORS);
                for (i = 0; i < 100; ++i) {
                    EFFECT[i] = Scaler.INSTANCE.scale(FRAME_MAIN_AREA, scale);
                    scale -= 0.01f;
                }
                G2.setStroke(new BasicStroke(1.5f));
                for (i = 0; i < EFFECT.length; ++i) {
                    G2.setPaint(EFFECT_GRADIENT.getColorAt((float)i / 100.0f));
                    G2.draw(EFFECT[i]);
                }
                break;
            }
            case EFFECT_TORUS: {
                int i;
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.08f, 0.1799f, 0.18f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 76), new Color(255, 255, 255, 64), new Color(13, 13, 13, 51), new Color(0, 0, 0, 50), new Color(0, 0, 0, 0)};
                GradientWrapper EFFECT_GRADIENT = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), EFFECT_FRACTIONS, EFFECT_COLORS);
                for (i = 0; i < 100; ++i) {
                    EFFECT[i] = Scaler.INSTANCE.scale(FRAME_MAIN_AREA, scale);
                    scale -= 0.01f;
                }
                G2.setStroke(new BasicStroke(1.5f));
                for (i = 0; i < EFFECT.length; ++i) {
                    G2.setPaint(EFFECT_GRADIENT.getColorAt((float)i / 100.0f));
                    G2.draw(EFFECT[i]);
                }
                break;
            }
            case EFFECT_INNER_FRAME: {
                Shape EFFECT_BIGINNERFRAME = Scaler.INSTANCE.scale(FRAME_MAIN_AREA, 0.8785046339035034);
                Point2D.Double EFFECT_BIGINNERFRAME_START = new Point2D.Double(0.0, EFFECT_BIGINNERFRAME.getBounds2D().getMinY());
                Point2D.Double EFFECT_BIGINNERFRAME_STOP = new Point2D.Double(0.0, EFFECT_BIGINNERFRAME.getBounds2D().getMaxY());
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.3f, 0.5f, 0.71f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 183), new Color(148, 148, 148, 25), new Color(0, 0, 0, 159), new Color(0, 0, 0, 81), new Color(255, 255, 255, 158)};
                LinearGradientPaint EFFECT_BIGINNERFRAME_GRADIENT = new LinearGradientPaint(EFFECT_BIGINNERFRAME_START, EFFECT_BIGINNERFRAME_STOP, EFFECT_FRACTIONS, EFFECT_COLORS);
                G2.setPaint(EFFECT_BIGINNERFRAME_GRADIENT);
                G2.fill(EFFECT_BIGINNERFRAME);
            }
        }
        G2.dispose();
        return image;
    }

    @Override
    protected BufferedImage create_BACKGROUND_Image(int WIDTH) {
        return this.create_BACKGROUND_Image(WIDTH, "", "", null);
    }

    @Override
    protected BufferedImage create_BACKGROUND_Image(int WIDTH, String TITLE, String UNIT_STRING, BufferedImage image) {
        double VERTICAL_SCALE;
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, (int)(0.641860465116279 * (double)WIDTH), 3);
            VERTICAL_SCALE = 1.0;
        } else {
            VERTICAL_SCALE = 0.641860465116279;
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        boolean fadeInOut = false;
        GeneralPath GAUGE_BACKGROUND = new GeneralPath();
        GAUGE_BACKGROUND.setWindingRule(0);
        GAUGE_BACKGROUND.moveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.7737226277372263 * VERTICAL_SCALE);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.41605839416058393 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.13138686131386862 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.13138686131386862 * VERTICAL_SCALE);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.13138686131386862 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9112149532710281, (double)IMAGE_HEIGHT * 0.41605839416058393 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9112149532710281, (double)IMAGE_HEIGHT * 0.7737226277372263 * VERTICAL_SCALE);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.9112149532710281, (double)IMAGE_HEIGHT * 0.8175182481751825 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9065420560747663, (double)IMAGE_HEIGHT * 0.8686131386861314 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.9065420560747663, (double)IMAGE_HEIGHT * 0.8686131386861314 * VERTICAL_SCALE);
        GAUGE_BACKGROUND.lineTo((double)IMAGE_WIDTH * 0.08878504672897196, (double)IMAGE_HEIGHT * 0.8686131386861314 * VERTICAL_SCALE);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.08878504672897196, (double)IMAGE_HEIGHT * 0.8686131386861314 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.8175182481751825 * VERTICAL_SCALE, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.7737226277372263 * VERTICAL_SCALE);
        GAUGE_BACKGROUND.closePath();
        Point2D.Double GAUGE_BACKGROUND_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
        Point2D.Double GAUGE_BACKGROUND_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
        float[] GAUGE_BACKGROUND_FRACTIONS = new float[]{0.0f, 0.4f, 1.0f};
        Paint backgroundPaint = null;
        if (this.getCustomBackground() != null && this.getBackgroundColor() == BackgroundColor.CUSTOM) {
            G2.setPaint(this.getCustomBackground());
        } else {
            Color[] GAUGE_BACKGROUND_COLORS = new Color[]{this.getBackgroundColor().GRADIENT_START_COLOR, this.getBackgroundColor().GRADIENT_FRACTION_COLOR, this.getBackgroundColor().GRADIENT_STOP_COLOR};
            if (this.getBackgroundColor() == BackgroundColor.BRUSHED_METAL) {
                backgroundPaint = new TexturePaint(UTIL.createBrushMetalTexture(this.getModel().getTextureColor(), GAUGE_BACKGROUND.getBounds().width, GAUGE_BACKGROUND.getBounds().height), GAUGE_BACKGROUND.getBounds());
            } else if (this.getBackgroundColor() == BackgroundColor.STAINLESS) {
                float[] STAINLESS_FRACTIONS = new float[]{0.0f, 0.03f, 0.1f, 0.14f, 0.24f, 0.33f, 0.38f, 0.5f, 0.62f, 0.67f, 0.76f, 0.81f, 0.85f, 0.97f, 1.0f};
                Color[] STAINLESS_COLORS = new Color[]{new Color(0xFDFDFD), new Color(0xFDFDFD), new Color(0xB2B2B4), new Color(0xACACAE), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(0xACACAE), new Color(0xB2B2B4), new Color(0xFDFDFD), new Color(0xFDFDFD)};
                backgroundPaint = new ConicalGradientPaint(false, this.getCenter(), -0.45f, STAINLESS_FRACTIONS, STAINLESS_COLORS);
            } else if (this.getBackgroundColor() == BackgroundColor.STAINLESS_GRINDED) {
                backgroundPaint = new TexturePaint(Radial2Top.BACKGROUND_FACTORY.STAINLESS_GRINDED_TEXTURE, new Rectangle(0, 0, 100, 100));
            } else if (this.getBackgroundColor() == BackgroundColor.CARBON) {
                backgroundPaint = new TexturePaint(Radial2Top.BACKGROUND_FACTORY.CARBON_FIBRE_TEXTURE, new Rectangle(0, 0, 12, 12));
                fadeInOut = true;
            } else if (this.getBackgroundColor() == BackgroundColor.PUNCHED_SHEET) {
                backgroundPaint = new TexturePaint(BACKGROUND_FACTORY.getPunchedSheetTexture(), new Rectangle(0, 0, 12, 12));
                fadeInOut = true;
            } else if (this.getBackgroundColor() == BackgroundColor.LINEN) {
                backgroundPaint = new TexturePaint(UTIL.createLinenTexture(this.getModel().getTextureColor(), GAUGE_BACKGROUND.getBounds().width, GAUGE_BACKGROUND.getBounds().height), GAUGE_BACKGROUND.getBounds());
            } else if (this.getBackgroundColor() == BackgroundColor.NOISY_PLASTIC) {
                ((Point2D)GAUGE_BACKGROUND_START).setLocation(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
                ((Point2D)GAUGE_BACKGROUND_STOP).setLocation(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
                if (GAUGE_BACKGROUND_START.equals(GAUGE_BACKGROUND_STOP)) {
                    ((Point2D)GAUGE_BACKGROUND_STOP).setLocation(0.0, ((Point2D)GAUGE_BACKGROUND_START).getY() + 1.0);
                }
                float[] FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] COLORS = new Color[]{UTIL.lighter(this.getTextureColor(), 0.15f), UTIL.darker(this.getTextureColor(), 0.15f)};
                backgroundPaint = new LinearGradientPaint(GAUGE_BACKGROUND_START, GAUGE_BACKGROUND_STOP, FRACTIONS, COLORS);
            } else {
                backgroundPaint = new LinearGradientPaint(GAUGE_BACKGROUND_START, GAUGE_BACKGROUND_STOP, GAUGE_BACKGROUND_FRACTIONS, GAUGE_BACKGROUND_COLORS);
            }
            G2.setPaint(backgroundPaint);
        }
        G2.fill(GAUGE_BACKGROUND);
        BufferedImage CLP = this.getCustomBackground() != null && this.getBackgroundColor() == BackgroundColor.CUSTOM ? Shadow.INSTANCE.createInnerShadow(GAUGE_BACKGROUND, this.getCustomBackground(), 0, 0.65f, Color.BLACK, 20, 315) : Shadow.INSTANCE.createInnerShadow(GAUGE_BACKGROUND, backgroundPaint, 0, 0.65f, Color.BLACK, 20, 315);
        G2.drawImage((Image)CLP, GAUGE_BACKGROUND.getBounds().x, GAUGE_BACKGROUND.getBounds().y, null);
        if (this.getBackgroundColor() == BackgroundColor.NOISY_PLASTIC) {
            Random BW_RND = new Random();
            Random ALPHA_RND = new Random();
            Shape OLD_CLIP = G2.getClip();
            G2.setClip(GAUGE_BACKGROUND);
            int y = 0;
            while ((double)y < GAUGE_BACKGROUND.getBounds().getHeight()) {
                int x = 0;
                while ((double)x < GAUGE_BACKGROUND.getBounds().getWidth()) {
                    Color noiseColor = BW_RND.nextBoolean() ? this.BRIGHT_NOISE : this.DARK_NOISE;
                    int noiseAlpha = 10 + ALPHA_RND.nextInt(10) - 5;
                    G2.setColor(new Color(noiseColor.getRed(), noiseColor.getGreen(), noiseColor.getBlue(), noiseAlpha));
                    G2.drawLine((int)((double)x + GAUGE_BACKGROUND.getBounds2D().getMinX()), (int)((double)y + GAUGE_BACKGROUND.getBounds2D().getMinY()), (int)((double)x + GAUGE_BACKGROUND.getBounds2D().getMinX()), (int)((double)y + GAUGE_BACKGROUND.getBounds2D().getMinY()));
                    ++x;
                }
                ++y;
            }
            G2.setClip(OLD_CLIP);
        }
        if (fadeInOut) {
            float[] SHADOW_OVERLAY_FRACTIONS = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            Color[] SHADOW_OVERLAY_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.6f)};
            LinearGradientPaint SHADOW_OVERLAY_GRADIENT = new LinearGradientPaint(new Point2D.Double(GAUGE_BACKGROUND.getBounds().getMinX(), 0.0), new Point2D.Double(GAUGE_BACKGROUND.getBounds().getMaxX(), 0.0), SHADOW_OVERLAY_FRACTIONS, SHADOW_OVERLAY_COLORS);
            G2.setPaint(SHADOW_OVERLAY_GRADIENT);
            G2.fill(GAUGE_BACKGROUND);
        }
        if (this.isCustomLayerVisible()) {
            G2.drawImage((Image)UTIL.getScaledInstance(this.getCustomLayer(), IMAGE_WIDTH, (int)((double)IMAGE_HEIGHT * VERTICAL_SCALE), RenderingHints.VALUE_INTERPOLATION_BICUBIC), 0, 0, null);
        }
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        if (!TITLE.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getLabelColor());
            }
            G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)IMAGE_WIDTH)));
            TextLayout TITLE_LAYOUT = new TextLayout(TITLE, G2.getFont(), RENDER_CONTEXT);
            Rectangle2D TITLE_BOUNDARY = TITLE_LAYOUT.getBounds();
            G2.drawString(TITLE, (float)(((double)IMAGE_WIDTH - TITLE_BOUNDARY.getWidth()) / 2.0), (float)((double)(0.44f * (float)IMAGE_HEIGHT) * VERTICAL_SCALE) + TITLE_LAYOUT.getAscent() - TITLE_LAYOUT.getDescent());
        }
        if (!UNIT_STRING.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getLabelColor());
            }
            G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)IMAGE_WIDTH)));
            TextLayout UNIT_LAYOUT = new TextLayout(UNIT_STRING, G2.getFont(), RENDER_CONTEXT);
            Rectangle2D UNIT_BOUNDARY = UNIT_LAYOUT.getBounds();
            G2.drawString(UNIT_STRING, (float)(((double)IMAGE_WIDTH - UNIT_BOUNDARY.getWidth()) / 2.0), 0.52f * (float)IMAGE_HEIGHT + UNIT_LAYOUT.getAscent() - UNIT_LAYOUT.getDescent());
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_GLOW_Image(int WIDTH, Color GLOW_COLOR, boolean ON) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, (int)(0.641860465116279 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath GLOWRING = new GeneralPath();
        GLOWRING.setWindingRule(0);
        GLOWRING.moveTo((double)IMAGE_WIDTH * 0.11214953271028037, (double)IMAGE_HEIGHT * 0.7737226277372263);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.11214953271028037, (double)IMAGE_HEIGHT * 0.4233576642335766, (double)IMAGE_WIDTH * 0.29906542056074764, (double)IMAGE_HEIGHT * 0.1678832116788321, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1678832116788321);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.1678832116788321, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.41605839416058393, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.7737226277372263);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8175182481751825, (double)IMAGE_WIDTH * 0.883177570093458, (double)IMAGE_HEIGHT * 0.8613138686131386, (double)IMAGE_WIDTH * 0.883177570093458, (double)IMAGE_HEIGHT * 0.8613138686131386);
        GLOWRING.lineTo((double)IMAGE_WIDTH * 0.11682242990654206, (double)IMAGE_HEIGHT * 0.8613138686131386);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.11682242990654206, (double)IMAGE_HEIGHT * 0.8613138686131386, (double)IMAGE_WIDTH * 0.11214953271028037, (double)IMAGE_HEIGHT * 0.8175182481751825, (double)IMAGE_WIDTH * 0.11214953271028037, (double)IMAGE_HEIGHT * 0.7737226277372263);
        GLOWRING.closePath();
        GLOWRING.moveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.7737226277372263);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.8175182481751825, (double)IMAGE_WIDTH * 0.08878504672897196, (double)IMAGE_HEIGHT * 0.8686131386861314, (double)IMAGE_WIDTH * 0.08878504672897196, (double)IMAGE_HEIGHT * 0.8686131386861314);
        GLOWRING.lineTo((double)IMAGE_WIDTH * 0.9065420560747663, (double)IMAGE_HEIGHT * 0.8686131386861314);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.9065420560747663, (double)IMAGE_HEIGHT * 0.8686131386861314, (double)IMAGE_WIDTH * 0.9112149532710281, (double)IMAGE_HEIGHT * 0.8175182481751825, (double)IMAGE_WIDTH * 0.9112149532710281, (double)IMAGE_HEIGHT * 0.7737226277372263);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.9112149532710281, (double)IMAGE_HEIGHT * 0.41605839416058393, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.13138686131386862, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.13138686131386862);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.13138686131386862, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.41605839416058393, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.7737226277372263);
        GLOWRING.closePath();
        if (!ON) {
            Point2D.Double GLOWRING_OFF_START = new Point2D.Double(0.0, GLOWRING.getBounds2D().getMinY());
            Point2D.Double GLOWRING_OFF_STOP = new Point2D.Double(0.0, GLOWRING.getBounds2D().getMaxY());
            float[] GLOWRING_OFF_FRACTIONS = new float[]{0.0f, 0.19f, 0.2f, 0.39f, 0.4f, 0.64f, 0.65f, 0.82f, 1.0f};
            Color[] GLOWRING_OFF_COLORS = new Color[]{new Color(204, 204, 204, 102), new Color(255, 255, 255, 102), new Color(250, 250, 250, 102), new Color(158, 158, 158, 102), new Color(153, 153, 153, 102), new Color(202, 202, 202, 102), new Color(204, 204, 204, 102), new Color(255, 255, 255, 102), new Color(153, 153, 153, 102)};
            LinearGradientPaint GLOWRING_OFF_GRADIENT = new LinearGradientPaint(GLOWRING_OFF_START, GLOWRING_OFF_STOP, GLOWRING_OFF_FRACTIONS, GLOWRING_OFF_COLORS);
            G2.setPaint(GLOWRING_OFF_GRADIENT);
            G2.fill(GLOWRING);
        } else {
            G2.translate(-10, -10);
            G2.drawImage((Image)Shadow.INSTANCE.createDropShadow(GLOWRING, UTIL.setAlpha(GLOW_COLOR, 0.8f), GLOW_COLOR, true, null, null, 0, 1.0f, 10, 315, GLOW_COLOR), GLOWRING.getBounds().x, GLOWRING.getBounds().y, null);
            G2.translate(10, 10);
            Point2D.Double GLOWRING_HL_START = new Point2D.Double(0.0, GLOWRING.getBounds2D().getMinY());
            Point2D.Double GLOWRING_HL_STOP = new Point2D.Double(0.0, GLOWRING.getBounds2D().getMaxY());
            float[] GLOWRING_HL_FRACTIONS = new float[]{0.0f, 0.26f, 0.42f, 0.42009997f, 0.56f, 0.5601f, 0.96f, 0.9601f, 1.0f};
            Color[] GLOWRING_HL_COLORS = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 63), new Color(255, 255, 255, 102), new Color(255, 255, 255, 98), new Color(255, 255, 255, 3), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 102)};
            LinearGradientPaint GLOWRING_HL_GRADIENT = new LinearGradientPaint(GLOWRING_HL_START, GLOWRING_HL_STOP, GLOWRING_HL_FRACTIONS, GLOWRING_HL_COLORS);
            G2.setPaint(GLOWRING_HL_GRADIENT);
            G2.fill(GLOWRING);
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_POSTS_Image(int WIDTH, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = (int)((double)image.getHeight() * 0.6418604651);
        switch (this.getKnobType()) {
            case SMALL_STD_KNOB: {
                Color[] CENTER_KNOB_MAIN_COLORS;
                Ellipse2D.Double CENTER_KNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.46261683106422424, (double)IMAGE_HEIGHT * 0.7153284549713135, (double)IMAGE_WIDTH * 0.07943925261497498, (double)IMAGE_HEIGHT * 0.1313868761062622);
                Point2D.Double CENTER_KNOB_FRAME_START = new Point2D.Double(0.0, CENTER_KNOB_FRAME.getBounds2D().getMinY());
                Point2D.Double CENTER_KNOB_FRAME_STOP = new Point2D.Double(0.0, CENTER_KNOB_FRAME.getBounds2D().getMaxY());
                float[] CENTER_KNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
                Color[] CENTER_KNOB_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                LinearGradientPaint CENTER_KNOB_FRAME_GRADIENT = new LinearGradientPaint(CENTER_KNOB_FRAME_START, CENTER_KNOB_FRAME_STOP, CENTER_KNOB_FRAME_FRACTIONS, CENTER_KNOB_FRAME_COLORS);
                G2.setPaint(CENTER_KNOB_FRAME_GRADIENT);
                G2.fill(CENTER_KNOB_FRAME);
                Ellipse2D.Double CENTER_KNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4719626307487488, (double)IMAGE_HEIGHT * (double)0.729927f, (double)IMAGE_WIDTH * 0.060747623443603516, (double)IMAGE_HEIGHT * 0.10218977928161621);
                Point2D.Double CENTER_KNOB_MAIN_START = new Point2D.Double(0.0, CENTER_KNOB_MAIN.getBounds2D().getMinY());
                Point2D.Double CENTER_KNOB_MAIN_STOP = new Point2D.Double(0.0, CENTER_KNOB_MAIN.getBounds2D().getMaxY());
                float[] CENTER_KNOB_MAIN_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                LinearGradientPaint CENTER_KNOB_MAIN_GRADIENT = new LinearGradientPaint(CENTER_KNOB_MAIN_START, CENTER_KNOB_MAIN_STOP, CENTER_KNOB_MAIN_FRACTIONS, CENTER_KNOB_MAIN_COLORS);
                G2.setPaint(CENTER_KNOB_MAIN_GRADIENT);
                G2.fill(CENTER_KNOB_MAIN);
                Ellipse2D.Double CENTER_KNOB_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4719626307487488, (double)IMAGE_HEIGHT * (double)0.729927f, (double)IMAGE_WIDTH * 0.060747623443603516, (double)IMAGE_HEIGHT * 0.10218977928161621);
                Point2D.Double CENTER_KNOB_INNERSHADOW_CENTER = new Point2D.Double(0.4930232558139535 * (double)IMAGE_WIDTH, 0.7608695652173914 * (double)IMAGE_HEIGHT);
                float[] CENTER_KNOB_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                Color[] CENTER_KNOB_INNERSHADOW_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                RadialGradientPaint CENTER_KNOB_INNERSHADOW_GRADIENT = new RadialGradientPaint(CENTER_KNOB_INNERSHADOW_CENTER, (float)(0.03255813953488372 * (double)IMAGE_WIDTH), CENTER_KNOB_INNERSHADOW_FRACTIONS, CENTER_KNOB_INNERSHADOW_COLORS);
                G2.setPaint(CENTER_KNOB_INNERSHADOW_GRADIENT);
                G2.fill(CENTER_KNOB_INNERSHADOW);
                break;
            }
            case BIG_STD_KNOB: {
                Color[] BIGCENTER_FOREGROUND_COLORS;
                Color[] BIGCENTER_FOREGROUNDFRAME_COLORS;
                Color[] BIGCENTER_BACKGROUND_COLORS;
                Color[] BIGCENTER_BACKGROUNDFRAME_COLORS;
                Ellipse2D.Double BIGCENTER_BACKGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.44859811663627625, (double)IMAGE_HEIGHT * 0.6934306621551514, (double)IMAGE_WIDTH * 0.1074766218662262, (double)IMAGE_HEIGHT * 0.17518246173858643);
                Point2D.Double BIGCENTER_BACKGROUNDFRAME_START = new Point2D.Double(0.0, BIGCENTER_BACKGROUNDFRAME.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_BACKGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGCENTER_BACKGROUNDFRAME.getBounds2D().getMaxY());
                float[] BIGCENTER_BACKGROUNDFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_BACKGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGCENTER_BACKGROUNDFRAME_START, BIGCENTER_BACKGROUNDFRAME_STOP, BIGCENTER_BACKGROUNDFRAME_FRACTIONS, BIGCENTER_BACKGROUNDFRAME_COLORS);
                G2.setPaint(BIGCENTER_BACKGROUNDFRAME_GRADIENT);
                G2.fill(BIGCENTER_BACKGROUNDFRAME);
                Ellipse2D.Double BIGCENTER_BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.44859811663627625, (double)IMAGE_HEIGHT * 0.7007299065589905, (double)IMAGE_WIDTH * 0.1074766218662262, (double)IMAGE_HEIGHT * 0.1605839729309082);
                Point2D.Double BIGCENTER_BACKGROUND_START = new Point2D.Double(0.0, BIGCENTER_BACKGROUND.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_BACKGROUND_STOP = new Point2D.Double(0.0, BIGCENTER_BACKGROUND.getBounds2D().getMaxY());
                float[] BIGCENTER_BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_BACKGROUND_GRADIENT = new LinearGradientPaint(BIGCENTER_BACKGROUND_START, BIGCENTER_BACKGROUND_STOP, BIGCENTER_BACKGROUND_FRACTIONS, BIGCENTER_BACKGROUND_COLORS);
                G2.setPaint(BIGCENTER_BACKGROUND_GRADIENT);
                G2.fill(BIGCENTER_BACKGROUND);
                Ellipse2D.Double BIGCENTER_FOREGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.46261683106422424, (double)IMAGE_HEIGHT * 0.7153284549713135, (double)IMAGE_WIDTH * 0.07943925261497498, (double)IMAGE_HEIGHT * 0.1313868761062622);
                Point2D.Double BIGCENTER_FOREGROUNDFRAME_START = new Point2D.Double(0.0, BIGCENTER_FOREGROUNDFRAME.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_FOREGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGCENTER_FOREGROUNDFRAME.getBounds2D().getMaxY());
                float[] BIGCENTER_FOREGROUNDFRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_FOREGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGCENTER_FOREGROUNDFRAME_START, BIGCENTER_FOREGROUNDFRAME_STOP, BIGCENTER_FOREGROUNDFRAME_FRACTIONS, BIGCENTER_FOREGROUNDFRAME_COLORS);
                G2.setPaint(BIGCENTER_FOREGROUNDFRAME_GRADIENT);
                G2.fill(BIGCENTER_FOREGROUNDFRAME);
                Ellipse2D.Double BIGCENTER_FOREGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.46261683106422424, (double)IMAGE_HEIGHT * 0.7226277589797974, (double)IMAGE_WIDTH * 0.07943925261497498, (double)IMAGE_HEIGHT * 0.11678832769393921);
                Point2D.Double BIGCENTER_FOREGROUND_START = new Point2D.Double(0.0, BIGCENTER_FOREGROUND.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_FOREGROUND_STOP = new Point2D.Double(0.0, BIGCENTER_FOREGROUND.getBounds2D().getMaxY());
                float[] BIGCENTER_FOREGROUND_FRACTIONS = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_FOREGROUND_GRADIENT = new LinearGradientPaint(BIGCENTER_FOREGROUND_START, BIGCENTER_FOREGROUND_STOP, BIGCENTER_FOREGROUND_FRACTIONS, BIGCENTER_FOREGROUND_COLORS);
                G2.setPaint(BIGCENTER_FOREGROUND_GRADIENT);
                G2.fill(BIGCENTER_FOREGROUND);
                break;
            }
            case BIG_CHROME_KNOB: {
                Ellipse2D.Double CHROMEKNOB_BACKFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.44859811663627625, (double)IMAGE_HEIGHT * 0.6934306621551514, (double)IMAGE_WIDTH * 0.1074766218662262, (double)IMAGE_HEIGHT * 0.17518246173858643);
                Point2D.Double CHROMEKNOB_BACKFRAME_START = new Point2D.Double(0.4697674418604651 * (double)IMAGE_WIDTH, 0.7028985507246377 * (double)IMAGE_HEIGHT);
                Point2D.Double CHROMEKNOB_BACKFRAME_STOP = new Point2D.Double(0.5264564794295986 * (double)IMAGE_WIDTH, 0.844239900084042 * (double)IMAGE_HEIGHT);
                float[] CHROMEKNOB_BACKFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] CHROMEKNOB_BACKFRAME_COLORS = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                LinearGradientPaint CHROMEKNOB_BACKFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_BACKFRAME_START, CHROMEKNOB_BACKFRAME_STOP, CHROMEKNOB_BACKFRAME_FRACTIONS, CHROMEKNOB_BACKFRAME_COLORS);
                G2.setPaint(CHROMEKNOB_BACKFRAME_GRADIENT);
                G2.fill(CHROMEKNOB_BACKFRAME);
                Ellipse2D.Double CHROMEKNOB_BACK = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.44859811663627625, (double)IMAGE_HEIGHT * 0.7007299065589905, (double)IMAGE_WIDTH * 0.1074766218662262, (double)IMAGE_HEIGHT * 0.16788321733474731);
                Point2D.Double CHROMEKNOB_BACK_CENTER = new Point2D.Double(CHROMEKNOB_BACK.getCenterX(), CHROMEKNOB_BACK.getCenterY());
                float[] CHROMEKNOB_BACK_FRACTIONS = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                Color[] CHROMEKNOB_BACK_COLORS = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                ConicalGradientPaint CHROMEKNOB_BACK_GRADIENT = new ConicalGradientPaint(false, CHROMEKNOB_BACK_CENTER, 0.0f, CHROMEKNOB_BACK_FRACTIONS, CHROMEKNOB_BACK_COLORS);
                G2.setPaint(CHROMEKNOB_BACK_GRADIENT);
                G2.fill(CHROMEKNOB_BACK);
                Ellipse2D.Double CHROMEKNOB_FOREFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.47663551568984985, (double)IMAGE_HEIGHT * 0.7445255517959595, (double)IMAGE_WIDTH * 0.05140185356140137, (double)IMAGE_HEIGHT * 0.0802919864654541);
                Point2D.Double CHROMEKNOB_FOREFRAME_START = new Point2D.Double(0.48372093023255813 * (double)IMAGE_WIDTH, 0.7463768115942029 * (double)IMAGE_HEIGHT);
                Point2D.Double CHROMEKNOB_FOREFRAME_STOP = new Point2D.Double(0.5123307997124568 * (double)IMAGE_WIDTH, 0.812459516652938 * (double)IMAGE_HEIGHT);
                float[] CHROMEKNOB_FOREFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] CHROMEKNOB_FOREFRAME_COLORS = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                LinearGradientPaint CHROMEKNOB_FOREFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FOREFRAME_START, CHROMEKNOB_FOREFRAME_STOP, CHROMEKNOB_FOREFRAME_FRACTIONS, CHROMEKNOB_FOREFRAME_COLORS);
                G2.setPaint(CHROMEKNOB_FOREFRAME_GRADIENT);
                G2.fill(CHROMEKNOB_FOREFRAME);
                Ellipse2D.Double CHROMEKNOB_FORE = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.47663551568984985, (double)IMAGE_HEIGHT * 0.7445255517959595, (double)IMAGE_WIDTH * 0.05140185356140137, (double)IMAGE_HEIGHT * 0.07299268245697021);
                Point2D.Double CHROMEKNOB_FORE_START = new Point2D.Double(0.48372093023255813 * (double)IMAGE_WIDTH, 0.7463768115942029 * (double)IMAGE_HEIGHT);
                Point2D.Double CHROMEKNOB_FORE_STOP = new Point2D.Double(0.5071290052615661 * (double)IMAGE_WIDTH, 0.8004444793695317 * (double)IMAGE_HEIGHT);
                float[] CHROMEKNOB_FORE_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] CHROMEKNOB_FORE_COLORS = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                LinearGradientPaint CHROMEKNOB_FORE_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FORE_START, CHROMEKNOB_FORE_STOP, CHROMEKNOB_FORE_FRACTIONS, CHROMEKNOB_FORE_COLORS);
                G2.setPaint(CHROMEKNOB_FORE_GRADIENT);
                G2.fill(CHROMEKNOB_FORE);
                break;
            }
            case METAL_KNOB: {
                Color[] METALKNOB_MAIN_COLORS;
                Ellipse2D.Double METALKNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.7153284549713135, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.1313868761062622);
                Point2D.Double METALKNOB_FRAME_START = new Point2D.Double(0.0, METALKNOB_FRAME.getBounds2D().getMinY());
                Point2D.Double METALKNOB_FRAME_STOP = new Point2D.Double(0.0, METALKNOB_FRAME.getBounds2D().getMaxY());
                float[] METALKNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                Color[] METALKNOB_FRAME_COLORS = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                LinearGradientPaint METALKNOB_FRAME_GRADIENT = new LinearGradientPaint(METALKNOB_FRAME_START, METALKNOB_FRAME_STOP, METALKNOB_FRAME_FRACTIONS, METALKNOB_FRAME_COLORS);
                G2.setPaint(METALKNOB_FRAME_GRADIENT);
                G2.fill(METALKNOB_FRAME);
                Ellipse2D.Double METALKNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.46261683106422424, (double)IMAGE_HEIGHT * 0.7226277589797974, (double)IMAGE_WIDTH * 0.0747663676738739, (double)IMAGE_HEIGHT * 0.11678832769393921);
                Point2D.Double METALKNOB_MAIN_START = new Point2D.Double(0.0, METALKNOB_MAIN.getBounds2D().getMinY());
                Point2D.Double METALKNOB_MAIN_STOP = new Point2D.Double(0.0, METALKNOB_MAIN.getBounds2D().getMaxY());
                float[] METALKNOB_MAIN_FRACTIONS = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        METALKNOB_MAIN_COLORS = new Color[]{new Color(2828847), new Color(1710880)};
                        break;
                    }
                    case BRASS: {
                        METALKNOB_MAIN_COLORS = new Color[]{new Color(9858614), new Color(8150845)};
                        break;
                    }
                    default: {
                        METALKNOB_MAIN_COLORS = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                    }
                }
                LinearGradientPaint METALKNOB_MAIN_GRADIENT = new LinearGradientPaint(METALKNOB_MAIN_START, METALKNOB_MAIN_STOP, METALKNOB_MAIN_FRACTIONS, METALKNOB_MAIN_COLORS);
                G2.setPaint(METALKNOB_MAIN_GRADIENT);
                G2.fill(METALKNOB_MAIN);
                GeneralPath METALKNOB_LOWERHL = new GeneralPath();
                METALKNOB_LOWERHL.setWindingRule(0);
                METALKNOB_LOWERHL.moveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.8321167883211679);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.8102189781021898, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.8029197080291971, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8029197080291971);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.8029197080291971, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.8102189781021898, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.8321167883211679);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.8394160583941606, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.8394160583941606, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8394160583941606);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.8394160583941606, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.8394160583941606, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.8321167883211679);
                METALKNOB_LOWERHL.closePath();
                Point2D.Double METALKNOB_LOWERHL_CENTER = new Point2D.Double(0.49767441860465117 * (double)IMAGE_WIDTH, 0.8333333333333334 * (double)IMAGE_HEIGHT);
                float[] METALKNOB_LOWERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_LOWERHL_COLORS = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                RadialGradientPaint METALKNOB_LOWERHL_GRADIENT = new RadialGradientPaint(METALKNOB_LOWERHL_CENTER, (float)(0.03255813953488372 * (double)IMAGE_WIDTH), METALKNOB_LOWERHL_FRACTIONS, METALKNOB_LOWERHL_COLORS);
                G2.setPaint(METALKNOB_LOWERHL_GRADIENT);
                G2.fill(METALKNOB_LOWERHL);
                GeneralPath METALKNOB_UPPERHL = new GeneralPath();
                METALKNOB_UPPERHL.setWindingRule(0);
                METALKNOB_UPPERHL.moveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.7518248175182481);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.7299270072992701, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.7153284671532847, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7153284671532847);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.7153284671532847, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.7299270072992701, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.7518248175182481);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.7591240875912408, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.7664233576642335, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7664233576642335);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.7664233576642335, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.7591240875912408, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.7518248175182481);
                METALKNOB_UPPERHL.closePath();
                Point2D.Double METALKNOB_UPPERHL_CENTER = new Point2D.Double(0.4930232558139535 * (double)IMAGE_WIDTH, 0.7101449275362319 * (double)IMAGE_HEIGHT);
                float[] METALKNOB_UPPERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_UPPERHL_COLORS = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                RadialGradientPaint METALKNOB_UPPERHL_GRADIENT = new RadialGradientPaint(METALKNOB_UPPERHL_CENTER, (float)(0.04883720930232558 * (double)IMAGE_WIDTH), METALKNOB_UPPERHL_FRACTIONS, METALKNOB_UPPERHL_COLORS);
                G2.setPaint(METALKNOB_UPPERHL_GRADIENT);
                G2.fill(METALKNOB_UPPERHL);
                Ellipse2D.Double METALKNOB_INNERFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4813084006309509, (double)IMAGE_HEIGHT * 0.7518247961997986, (double)IMAGE_WIDTH * (double)0.0373832f, (double)IMAGE_HEIGHT * 0.0656934380531311);
                Point2D.Double METALKNOB_INNERFRAME_START = new Point2D.Double(0.0, METALKNOB_INNERFRAME.getBounds2D().getMinY());
                Point2D.Double METALKNOB_INNERFRAME_STOP = new Point2D.Double(0.0, METALKNOB_INNERFRAME.getBounds2D().getMaxY());
                float[] METALKNOB_INNERFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_INNERFRAME_COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                LinearGradientPaint METALKNOB_INNERFRAME_GRADIENT = new LinearGradientPaint(METALKNOB_INNERFRAME_START, METALKNOB_INNERFRAME_STOP, METALKNOB_INNERFRAME_FRACTIONS, METALKNOB_INNERFRAME_COLORS);
                G2.setPaint(METALKNOB_INNERFRAME_GRADIENT);
                G2.fill(METALKNOB_INNERFRAME);
                Ellipse2D.Double METALKNOB_INNERBACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4859813153743744, (double)IMAGE_HEIGHT * 0.7591241002082825, (double)IMAGE_WIDTH * 0.02803739905357361, (double)IMAGE_HEIGHT * (double)0.05109489f);
                Point2D.Double METALKNOB_INNERBACKGROUND_START = new Point2D.Double(0.0, METALKNOB_INNERBACKGROUND.getBounds2D().getMinY());
                Point2D.Double METALKNOB_INNERBACKGROUND_STOP = new Point2D.Double(0.0, METALKNOB_INNERBACKGROUND.getBounds2D().getMaxY());
                float[] METALKNOB_INNERBACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_INNERBACKGROUND_COLORS = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                LinearGradientPaint METALKNOB_INNERBACKGROUND_GRADIENT = new LinearGradientPaint(METALKNOB_INNERBACKGROUND_START, METALKNOB_INNERBACKGROUND_STOP, METALKNOB_INNERBACKGROUND_FRACTIONS, METALKNOB_INNERBACKGROUND_COLORS);
                G2.setPaint(METALKNOB_INNERBACKGROUND_GRADIENT);
                G2.fill(METALKNOB_INNERBACKGROUND);
            }
        }
        IMAGE_HEIGHT = image.getHeight();
        if (this.getPostsVisible()) {
            Color[] MIN_POST_MAIN_LEFT_COLORS;
            Color[] MAX_POST_MAIN_RIGHT_COLORS;
            Ellipse2D.Double MAX_POST_FRAME_RIGHT = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.8317757248878479, (double)IMAGE_HEIGHT * 0.514018714427948, (double)IMAGE_WIDTH * 0.03738313913345337, (double)IMAGE_HEIGHT * 0.03738313913345337);
            Point2D.Double MAX_POST_FRAME_RIGHT_START = new Point2D.Double(0.0, MAX_POST_FRAME_RIGHT.getBounds2D().getMinY());
            Point2D.Double MAX_POST_FRAME_RIGHT_STOP = new Point2D.Double(0.0, MAX_POST_FRAME_RIGHT.getBounds2D().getMaxY());
            float[] E_MAX_POST_FRAME_RIGHT_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
            Color[] MAX_POST_FRAME_RIGHT_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
            LinearGradientPaint MAX_POST_FRAME_RIGHT_GRADIENT = new LinearGradientPaint(MAX_POST_FRAME_RIGHT_START, MAX_POST_FRAME_RIGHT_STOP, E_MAX_POST_FRAME_RIGHT_FRACTIONS, MAX_POST_FRAME_RIGHT_COLORS);
            G2.setPaint(MAX_POST_FRAME_RIGHT_GRADIENT);
            G2.fill(MAX_POST_FRAME_RIGHT);
            Ellipse2D.Double MAX_POST_MAIN_RIGHT = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.836448609828949, (double)IMAGE_HEIGHT * 0.5186915993690491, (double)IMAGE_WIDTH * 0.02803736925125122, (double)IMAGE_HEIGHT * 0.02803736925125122);
            Point2D.Double MAX_POST_MAIN_RIGHT_START = new Point2D.Double(0.0, MAX_POST_MAIN_RIGHT.getBounds2D().getMinY());
            Point2D.Double MAX_POST_MAIN_RIGHT_STOP = new Point2D.Double(0.0, MAX_POST_MAIN_RIGHT.getBounds2D().getMaxY());
            float[] MAX_POST_MAIN_RIGHT_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
            switch (this.getModel().getKnobStyle()) {
                case BLACK: {
                    MAX_POST_MAIN_RIGHT_COLORS = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                    break;
                }
                case BRASS: {
                    MAX_POST_MAIN_RIGHT_COLORS = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                    break;
                }
                default: {
                    MAX_POST_MAIN_RIGHT_COLORS = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                }
            }
            LinearGradientPaint MAX_POST_MAIN_RIGHT_GRADIENT = new LinearGradientPaint(MAX_POST_MAIN_RIGHT_START, MAX_POST_MAIN_RIGHT_STOP, MAX_POST_MAIN_RIGHT_FRACTIONS, MAX_POST_MAIN_RIGHT_COLORS);
            G2.setPaint(MAX_POST_MAIN_RIGHT_GRADIENT);
            G2.fill(MAX_POST_MAIN_RIGHT);
            Ellipse2D.Double MAX_POST_INNERSHADOW_RIGHT = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.836448609828949, (double)IMAGE_HEIGHT * 0.5186915993690491, (double)IMAGE_WIDTH * 0.02803736925125122, (double)IMAGE_HEIGHT * 0.02803736925125122);
            Point2D.Double MAX_POST_INNERSHADOW_RIGHT_CENTER = new Point2D.Double(0.8504672897196262 * (double)IMAGE_WIDTH, 0.5280373831775701 * (double)IMAGE_HEIGHT);
            float[] MAX_POST_INNERSHADOW_RIGHT_FRACTIONS = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
            Color[] MAX_POST_INNERSHADOW_RIGHT_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
            RadialGradientPaint MAX_POST_INNERSHADOW_RIGHT_GRADIENT = new RadialGradientPaint(MAX_POST_INNERSHADOW_RIGHT_CENTER, (float)(0.014018691588785047 * (double)IMAGE_WIDTH), MAX_POST_INNERSHADOW_RIGHT_FRACTIONS, MAX_POST_INNERSHADOW_RIGHT_COLORS);
            G2.setPaint(MAX_POST_INNERSHADOW_RIGHT_GRADIENT);
            G2.fill(MAX_POST_INNERSHADOW_RIGHT);
            Ellipse2D.Double MIN_POST_FRAME_LEFT = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.13084112107753754, (double)IMAGE_HEIGHT * 0.514018714427948, (double)IMAGE_WIDTH * 0.03738318383693695, (double)IMAGE_HEIGHT * 0.03738313913345337);
            Point2D.Double MIN_POST_FRAME_LEFT_START = new Point2D.Double(0.0, MIN_POST_FRAME_LEFT.getBounds2D().getMinY());
            Point2D.Double MIN_POST_FRAME_LEFT_STOP = new Point2D.Double(0.0, MIN_POST_FRAME_LEFT.getBounds2D().getMaxY());
            float[] E_MIN_POST_FRAME_LEFT_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
            Color[] MIN_POST_FRAME_LEFT_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
            LinearGradientPaint MIN_POST_FRAME_LEFT_GRADIENT = new LinearGradientPaint(MIN_POST_FRAME_LEFT_START, MIN_POST_FRAME_LEFT_STOP, E_MIN_POST_FRAME_LEFT_FRACTIONS, MIN_POST_FRAME_LEFT_COLORS);
            G2.setPaint(MIN_POST_FRAME_LEFT_GRADIENT);
            G2.fill(MIN_POST_FRAME_LEFT);
            Ellipse2D.Double MIN_POST_MAIN_LEFT = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.1355140209197998, (double)IMAGE_HEIGHT * 0.5186915993690491, (double)IMAGE_WIDTH * 0.028037384152412415, (double)IMAGE_HEIGHT * 0.02803736925125122);
            Point2D.Double MIN_POST_MAIN_LEFT_START = new Point2D.Double(0.0, MIN_POST_MAIN_LEFT.getBounds2D().getMinY());
            Point2D.Double MIN_POST_MAIN_LEFT_STOP = new Point2D.Double(0.0, MIN_POST_MAIN_LEFT.getBounds2D().getMaxY());
            float[] MIN_POST_MAIN_LEFT_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
            switch (this.getModel().getKnobStyle()) {
                case BLACK: {
                    MIN_POST_MAIN_LEFT_COLORS = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                    break;
                }
                case BRASS: {
                    MIN_POST_MAIN_LEFT_COLORS = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                    break;
                }
                default: {
                    MIN_POST_MAIN_LEFT_COLORS = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                }
            }
            LinearGradientPaint MIN_POST_MAIN_LEFT_GRADIENT = new LinearGradientPaint(MIN_POST_MAIN_LEFT_START, MIN_POST_MAIN_LEFT_STOP, MIN_POST_MAIN_LEFT_FRACTIONS, MIN_POST_MAIN_LEFT_COLORS);
            G2.setPaint(MIN_POST_MAIN_LEFT_GRADIENT);
            G2.fill(MIN_POST_MAIN_LEFT);
            Ellipse2D.Double MIN_POST_INNERSHADOW_LEFT = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.1355140209197998, (double)IMAGE_HEIGHT * 0.5186915993690491, (double)IMAGE_WIDTH * 0.028037384152412415, (double)IMAGE_HEIGHT * 0.02803736925125122);
            Point2D.Double MIN_POST_INNERSHADOW_LEFT_CENTER = new Point2D.Double(0.14953271028037382 * (double)IMAGE_WIDTH, 0.5280373831775701 * (double)IMAGE_HEIGHT);
            float[] MIN_POST_INNERSHADOW_LEFT_FRACTIONS = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
            Color[] MIN_POST_INNERSHADOW_LEFT_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
            RadialGradientPaint MIN_POST_INNERSHADOW_LEFT_GRADIENT = new RadialGradientPaint(MIN_POST_INNERSHADOW_LEFT_CENTER, (float)(0.014018691588785047 * (double)IMAGE_WIDTH), MIN_POST_INNERSHADOW_LEFT_FRACTIONS, MIN_POST_INNERSHADOW_LEFT_COLORS);
            G2.setPaint(MIN_POST_INNERSHADOW_LEFT_GRADIENT);
            G2.fill(MIN_POST_INNERSHADOW_LEFT);
        }
        G2.dispose();
        return image;
    }

    @Override
    protected BufferedImage create_DISABLED_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, (int)(0.641860465116279 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath GAUGE_BACKGROUND = new GeneralPath();
        GAUGE_BACKGROUND.setWindingRule(0);
        GAUGE_BACKGROUND.moveTo((double)IMAGE_WIDTH * 0.08372093023255814, (double)IMAGE_HEIGHT * 0.7753623188405797);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.08372093023255814, (double)IMAGE_HEIGHT * 0.42028985507246375, (double)IMAGE_WIDTH * 0.26976744186046514, (double)IMAGE_HEIGHT * 0.13043478260869565, (double)IMAGE_WIDTH * 0.49767441860465117, (double)IMAGE_HEIGHT * 0.13043478260869565);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.7255813953488373, (double)IMAGE_HEIGHT * 0.13043478260869565, (double)IMAGE_WIDTH * 0.9116279069767442, (double)IMAGE_HEIGHT * 0.42028985507246375, (double)IMAGE_WIDTH * 0.9116279069767442, (double)IMAGE_HEIGHT * 0.7753623188405797);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.9116279069767442, (double)IMAGE_HEIGHT * 0.8188405797101449, (double)IMAGE_WIDTH * 0.9069767441860465, (double)IMAGE_HEIGHT * 0.8695652173913043, (double)IMAGE_WIDTH * 0.9069767441860465, (double)IMAGE_HEIGHT * 0.8695652173913043);
        GAUGE_BACKGROUND.lineTo((double)IMAGE_WIDTH * 0.08837209302325581, (double)IMAGE_HEIGHT * 0.8695652173913043);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.08837209302325581, (double)IMAGE_HEIGHT * 0.8695652173913043, (double)IMAGE_WIDTH * 0.08372093023255814, (double)IMAGE_HEIGHT * 0.8115942028985508, (double)IMAGE_WIDTH * 0.08372093023255814, (double)IMAGE_HEIGHT * 0.7753623188405797);
        GAUGE_BACKGROUND.closePath();
        G2.setColor(new Color(102, 102, 102, 178));
        G2.fill(GAUGE_BACKGROUND);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "Radial2Top";
    }
}

