/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.widgets;

import com.rusefi.FileLog;
import com.rusefi.NamedThreadFactory;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.functional_tests.EcuTestHelper;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.LinkManager;
import com.rusefi.ui.RecentCommands;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.util.JTextFieldWithWidth;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class AnyCommand {
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("AnyCommand");
    public static final String KEY = "last_value";
    private final UIContext uiContext;
    private final JTextComponent text;
    private JPanel content = new JPanel(new FlowLayout(0));
    private boolean reentrant;
    private Listener listener;

    private AnyCommand(UIContext uiContext, final JTextComponent text, final Node config, String defaultCommand, boolean listenToCommands, boolean withCommandCaption) {
        this.uiContext = uiContext;
        this.text = text;
        this.installCtrlEnterAction();
        text.setText(defaultCommand);
        this.content.setBorder(BorderFactory.createLineBorder(Color.PINK));
        if (withCommandCaption) {
            this.content.add(new JLabel("Command: "));
        }
        this.content.add(text);
        JButton go = new JButton("Go");
        go.setContentAreaFilled(false);
        go.addActionListener(e -> this.send());
        this.content.add(go);
        uiContext.getCommandQueue().addListener(command -> {
            if (listenToCommands && !this.reentrant && !RecentCommands.isBoringCommand(command)) {
                text.setText((String)command);
            }
        });
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                boolean isOk = AnyCommand.isValidInput(text.getText());
                text.setBorder(isOk ? null : BorderFactory.createLineBorder(Color.red));
                config.setProperty(AnyCommand.KEY, text.getText());
            }
        });
    }

    private void installCtrlEnterAction() {
        this.text.setToolTipText("Ctrl-Enter to send");
        this.text.getInputMap().put(KeyStroke.getKeyStroke(10, 128), "sendKey");
        this.text.getActionMap().put("sendKey", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnyCommand.this.send();
            }
        });
    }

    private void send() {
        String multiLine = this.text.getText();
        for (String line : multiLine.split("\n")) {
            this.sendCommand(line);
        }
    }

    private void sendCommand(String rawCommand) {
        if (!AnyCommand.isValidInput(rawCommand)) {
            return;
        }
        String cmd = AnyCommand.prepareCommand(rawCommand, this.uiContext.getLinkManager());
        if (cmd == null) {
            return;
        }
        if (this.listener != null) {
            this.listener.onSend();
        }
        int timeout = CommandQueue.getTimeout(cmd);
        this.reentrant = true;
        this.uiContext.getCommandQueue().write(cmd, timeout);
        this.reentrant = false;
    }

    public static String prepareCommand(String rawCommand, LinkManager linkManager) {
        try {
            if (rawCommand.toLowerCase().startsWith("stim_check ")) {
                AnyCommand.handleStimulationSelfCheck(rawCommand, linkManager);
                return null;
            }
            return rawCommand;
        }
        catch (Throwable e) {
            FileLog.MAIN.log(e);
            return rawCommand;
        }
    }

    private static void handleStimulationSelfCheck(String rawCommand, final LinkManager linkManager) {
        String[] parts = rawCommand.split(" ", 4);
        if (parts.length != 4) {
            MessagesCentral.getInstance().postMessage(AnyCommand.class, "Invalid command length " + parts);
            return;
        }
        final int rpm = Integer.parseInt(parts[1]);
        final int settleTime = Integer.parseInt(parts[2]);
        final int durationTime = Integer.parseInt(parts[3]);
        THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                MessagesCentral.getInstance().postMessage(AnyCommand.class, "Will test with RPM " + rpm + ", settle time" + settleTime + "s and duration" + durationTime + "s");
                Function<String, Object> callback = new Function<String, Object>(){

                    @Override
                    public Object apply(String status) {
                        if (status == null) {
                            MessagesCentral.getInstance().postMessage(AnyCommand.class, rpm + " worked!");
                        } else {
                            MessagesCentral.getInstance().postMessage(AnyCommand.class, rpm + " failed " + status);
                        }
                        return null;
                    }
                };
                EcuTestHelper.assertRpmDoesNotJump(rpm, settleTime, durationTime, callback, linkManager.getCommandQueue());
            }
        }).start();
    }

    private static boolean isValidInput(String text) {
        boolean isOk = true;
        for (char c : text.toCharArray()) {
            if (c <= '\u007f') continue;
            isOk = false;
            break;
        }
        return isOk;
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setContent(JPanel content) {
        this.content = content;
    }

    public void requestFocus() {
        this.text.requestFocus();
    }

    public static AnyCommand createField(UIContext uiContext, Node config, boolean listenToCommands, boolean withCommandCaption) {
        return AnyCommand.createField(uiContext, config, config.getProperty(KEY), listenToCommands, withCommandCaption);
    }

    public static AnyCommand createField(UIContext uiContext, Node config, String defaultCommand, boolean listenToCommands, boolean withCommandCaption) {
        final JTextFieldWithWidth text = new JTextFieldWithWidth(200);
        final AnyCommand command = new AnyCommand(uiContext, text, config, defaultCommand, listenToCommands, withCommandCaption);
        text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command.send();
            }
        });
        final AtomicInteger index = new AtomicInteger();
        command.listener = () -> index.set(0);
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    String command = RecentCommands.getRecent(index.incrementAndGet());
                    text.setText(command);
                } else if (e.getKeyCode() == 40) {
                    String command = RecentCommands.getRecent(index.decrementAndGet());
                    text.setText(command);
                }
            }
        });
        return command;
    }

    public static AnyCommand createArea(UIContext uiContext, Node config, String defaultCommand, boolean listenToCommands, boolean withCommandCaption) {
        JTextArea text = new JTextArea(3, 20){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(200, size.height);
            }
        };
        return new AnyCommand(uiContext, text, config, defaultCommand, listenToCommands, withCommandCaption);
    }

    static interface Listener {
        public void onSend();
    }
}

