/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public final class BiLinearGradientPaint
implements Paint {
    private static final Util UTIL = Util.INSTANCE;
    private final Rectangle BOUNDS;
    private final Color COLOR_00;
    private final Color COLOR_10;
    private final Color COLOR_01;
    private final Color COLOR_11;
    private final float FRACTION_X_STEPSIZE;
    private final float FRACTION_Y_STEPSIZE;
    private int titleBarHeight;

    public BiLinearGradientPaint(Shape SHAPE, Color COLOR_00, Color COLOR_10, Color COLOR_01, Color COLOR_11) throws IllegalArgumentException {
        this.BOUNDS = SHAPE.getBounds();
        this.COLOR_00 = COLOR_00;
        this.COLOR_10 = COLOR_10;
        this.COLOR_01 = COLOR_01;
        this.COLOR_11 = COLOR_11;
        this.FRACTION_X_STEPSIZE = 1.0f / (float)this.BOUNDS.getBounds().width;
        this.FRACTION_Y_STEPSIZE = 1.0f / (float)this.BOUNDS.getBounds().height;
        this.titleBarHeight = -1;
    }

    @Override
    public PaintContext createContext(ColorModel COLOR_MODEL, Rectangle DEVICE_BOUNDS, Rectangle2D USER_BOUNDS, AffineTransform TRANSFORM, RenderingHints HINTS) {
        return new BiLinearGradientPaintContext();
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    public String toString() {
        return "BiLinearGradientPaint";
    }

    private final class BiLinearGradientPaintContext
    implements PaintContext {
        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int X, int Y, int TILE_WIDTH, int TILE_HEIGHT) {
            if (BiLinearGradientPaint.this.titleBarHeight == -1) {
                BiLinearGradientPaint.this.titleBarHeight = Y;
            }
            WritableRaster RASTER = this.getColorModel().createCompatibleWritableRaster(TILE_WIDTH, TILE_HEIGHT);
            int[] DATA = new int[TILE_WIDTH * TILE_HEIGHT * 4];
            float fraction_x = (float)(X - ((BiLinearGradientPaint)BiLinearGradientPaint.this).BOUNDS.x) * BiLinearGradientPaint.this.FRACTION_X_STEPSIZE;
            float fraction_y = (float)(Y - ((BiLinearGradientPaint)BiLinearGradientPaint.this).BOUNDS.y - BiLinearGradientPaint.this.titleBarHeight) * BiLinearGradientPaint.this.FRACTION_Y_STEPSIZE;
            fraction_x = fraction_x > 1.0f ? 1.0f : fraction_x;
            fraction_y = fraction_y > 1.0f ? 1.0f : fraction_y;
            for (int tileY = 0; tileY < TILE_HEIGHT; ++tileY) {
                for (int tileX = 0; tileX < TILE_WIDTH; ++tileX) {
                    Color currentColor = UTIL.bilinearInterpolateColor(BiLinearGradientPaint.this.COLOR_00, BiLinearGradientPaint.this.COLOR_10, BiLinearGradientPaint.this.COLOR_01, BiLinearGradientPaint.this.COLOR_11, fraction_x, fraction_y);
                    fraction_x = (fraction_x += BiLinearGradientPaint.this.FRACTION_X_STEPSIZE) > 1.0f ? 1.0f : fraction_x;
                    int BASE = (tileY * TILE_WIDTH + tileX) * 4;
                    DATA[BASE + 0] = currentColor.getRed();
                    DATA[BASE + 1] = currentColor.getGreen();
                    DATA[BASE + 2] = currentColor.getBlue();
                    DATA[BASE + 3] = currentColor.getAlpha();
                }
                fraction_x = (float)(X - ((BiLinearGradientPaint)BiLinearGradientPaint.this).BOUNDS.x) * BiLinearGradientPaint.this.FRACTION_X_STEPSIZE;
                fraction_y = (fraction_y += BiLinearGradientPaint.this.FRACTION_Y_STEPSIZE) > 1.0f ? 1.0f : fraction_y;
            }
            RASTER.setPixels(0, 0, TILE_WIDTH, TILE_HEIGHT, DATA);
            return RASTER;
        }
    }
}

