/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.console;

import com.opensr5.ini.DialogModel;
import com.rusefi.config.Field;
import com.rusefi.config.FieldType;
import com.rusefi.config.FieldsMap;
import com.rusefi.ui.RecentCommands;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.config.BitConfigField;
import com.rusefi.ui.config.ConfigUiField;
import com.rusefi.ui.config.EnumConfigField;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class SettingsTab {
    private final JPanel content = new JPanel(new BorderLayout());
    private final JPanel panel = new JPanel(new GridLayout(1, 3));
    private final JButton dialog = new JButton();
    private final JPanel dialogBody = new JPanel();
    private final UIContext uiContext;

    public SettingsTab(UIContext uiContext) {
        this.uiContext = uiContext;
        UiUtils.showLoadingMessage(this.content);
    }

    public Component createPane() {
        return this.content;
    }

    public void showContent() {
        final Map<String, DialogModel> dialogs = this.uiContext.getIni().getDialogs();
        if (dialogs.isEmpty()) {
            this.content.removeAll();
            this.content.add(new JLabel("Meta data not found: rusefi*.ini"));
            UiUtils.trueLayout(this.content);
            return;
        }
        this.content.removeAll();
        this.panel.removeAll();
        String firstDialog = new ArrayList<String>(dialogs.keySet()).get(0);
        this.dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                JPopupMenu menu = new JPopupMenu();
                menu.setLayout(new GridLayout(dialogs.keySet().size() / 2 + 1, 2));
                for (String name : dialogs.keySet()) {
                    JMenuItem item = new JMenuItem(name);
                    item.addActionListener(e1 -> SettingsTab.this.selectDialog(name));
                    menu.add(item);
                }
                menu.show(c, -1, c.getHeight());
            }
        });
        this.selectDialog(firstDialog);
        this.panel.add(UiUtils.wrap(this.dialog));
        this.panel.add(this.dialogBody);
        this.panel.add(UiUtils.wrap(RecentCommands.createButton(this.uiContext, new AtomicBoolean(), "writeconfig")));
        JLabel unusable = new JLabel("This is painfully unusable, TunerStudio works way better for settings!");
        unusable.setForeground(Color.red);
        this.content.add((Component)unusable, "North");
        this.content.add((Component)this.panel, "Center");
        UiUtils.trueLayout(this.content);
    }

    private void selectDialog(String name) {
        this.dialog.setText(name);
        this.dialogBody.removeAll();
        DialogModel m = this.uiContext.getIni().getDialogs().get(name);
        this.dialogBody.setLayout(new GridLayout(m.getFields().size(), 1));
        for (DialogModel.Field f : m.getFields()) {
            if (f.getKey() == null) continue;
            Field field = FieldsMap.VALUES.get(f.getKey().toUpperCase());
            if (field == null) {
                throw new NullPointerException("No field for " + f.getKey());
            }
            JPanel control = field.getType() == FieldType.BIT ? new BitConfigField(this.uiContext, field, f.getUiName()).getContent() : (field.getOptions() != null ? new EnumConfigField(this.uiContext, field, f.getUiName()).getContent() : new ConfigUiField(this.uiContext, field, f.getUiName()).getContent());
            this.dialogBody.add(control);
        }
        UiUtils.trueLayout(this.dialogBody);
    }
}

