/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.ConsoleUI;
import com.rusefi.FileLog;
import com.rusefi.NamedThreadFactory;
import com.rusefi.SimulatorExecHelper;
import com.rusefi.StartupFrame;
import com.rusefi.io.LinkManager;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.ui.util.UiUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SimulatorHelper {
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("SimulatorHelper");
    public static final String BINARY = "rusefi_simulator.exe";
    private static Process process;

    public static boolean isBinaryHere() {
        return new File(BINARY).exists();
    }

    private static void startSimulator() {
        LinkManager.isSimulationMode = true;
        FileLog.MAIN.logLine("Executing rusefi_simulator.exe");
        THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    FileLog.SIMULATOR_CONSOLE.start();
                    process = Runtime.getRuntime().exec(SimulatorHelper.BINARY);
                    FileLog.MAIN.logLine("Executing rusefi_simulator.exe=" + process);
                    SimulatorExecHelper.dumpProcessOutput(process, new CountDownLatch(1));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }).start();
        boolean isPortOpened = false;
        for (int i = 0; i < 60 && !isPortOpened; ++i) {
            isPortOpened = TcpConnector.isTcpPortOpened();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Unexpected", e);
            }
        }
        if (!isPortOpened) {
            throw new IllegalStateException("Port not opened?");
        }
        FileLog.MAIN.logLine("Port 29001 is alive");
        new ConsoleUI("29001");
    }

    public static JComponent createSimulatorComponent(final StartupFrame portSelector) {
        if (!SimulatorHelper.isBinaryHere()) {
            return new JLabel("rusefi_simulator.exe not found");
        }
        if (TcpConnector.isTcpPortOpened()) {
            return new JLabel("Port 29001 already busy. Simulator running?");
        }
        JButton simulatorButton = new JButton("Start Virtual Simulator");
        simulatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                portSelector.disposeFrameAndProceed();
                SimulatorHelper.startSimulator();
            }
        });
        UiUtils.setToolTip(simulatorButton, "Connect to totally virtual simulator", "You do not need any hardware to try rusEfi", "This works via localhost: 29001 TCP/IP port");
        return simulatorButton;
    }

    public static void onWindowClosed() {
        if (process != null) {
            process.destroy();
        }
    }
}

