/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autotest;

import com.rusefi.FileLog;
import com.rusefi.IoUtil;
import com.rusefi.TestingUtils;
import com.rusefi.autodetect.PortDetector;
import com.rusefi.core.EngineState;
import com.rusefi.io.LinkManager;
import org.jetbrains.annotations.NotNull;

public class ControllerConnectorState {
    public static volatile String firmwareVersion;
    private static LinkManager linkManager;

    @NotNull
    public static synchronized LinkManager getLinkManager() {
        if (linkManager != null) {
            return linkManager;
        }
        LinkManager linkManager = new LinkManager().setCompositeLogicEnabled(false);
        linkManager.getEngineState().registerStringValueAction("rusEfiVersion", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String firmwareVersion1) {
                firmwareVersion = firmwareVersion1;
            }
        });
        TestingUtils.isRealHardware = true;
        FileLog.MAIN.start();
        String port = System.getenv("HARDWARE_CI_SERIAL_DEVICE");
        if (port == null && (port = System.getProperty("ecu.port")) == null) {
            port = PortDetector.autoDetectSerial(null).getSerialPort();
            if (port == null) {
                throw new IllegalStateException("ECU serial not detected");
            }
            System.out.println("Auto-connected to " + port);
        }
        IoUtil.realHardwareConnect(linkManager, port);
        ControllerConnectorState.linkManager = linkManager;
        return linkManager;
    }
}

