/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.devexperts.logging.Logging;
import com.fazecast.jSerialComm.SerialPort;
import com.rusefi.Callable;
import com.rusefi.NamedThreadFactory;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.BinaryProtocolState;
import com.rusefi.core.EngineState;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.ConnectionFailedListener;
import com.rusefi.io.ConnectionStateListener;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.io.ConnectionStatusValue;
import com.rusefi.io.HeartBeatListeners;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkConnector;
import com.rusefi.io.LinkDecoder;
import com.rusefi.io.can.PCanIoStream;
import com.rusefi.io.can.SocketCANIoStream;
import com.rusefi.io.serial.BufferedSerialIoStream;
import com.rusefi.io.serial.StreamConnector;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.io.tcp.TcpIoStream;
import com.rusefi.util.IoUtils;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LinkManager
implements Closeable {
    private static final Logging log = Logging.getLogging(LinkManager.class);
    public static final String PCAN = "PCAN";
    public static final String SOCKET_CAN = "SocketCAN";
    @NotNull
    public static final LogLevel LOG_LEVEL = LogLevel.INFO;
    public static final LinkDecoder ENCODER = new LinkDecoder(){

        @Override
        public String unpack(String packedLine) {
            return packedLine;
        }
    };
    public static final String LOG_VIEWER = "log viewer";
    private final CommandQueue commandQueue;
    private String lastTriedPort;
    private LinkConnector connector = LinkConnector.VOID;
    private boolean isStarted;
    private boolean compositeLogicEnabled = true;
    private boolean needPullData = true;
    private boolean needPullText = true;
    private boolean needPullLiveData = true;
    public final MessagesListener messageListener = (source, message) -> log.info(source + ": " + message);
    private Thread communicationThread;
    private boolean isDisconnectedByUser;
    public final LinkedBlockingQueue<Runnable> COMMUNICATION_QUEUE = new LinkedBlockingQueue();
    public final ExecutorService COMMUNICATION_EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.COMMUNICATION_QUEUE, new NamedThreadFactory("ECU Communication Executor", true));
    private final EngineState engineState;
    public static boolean isSimulationMode;

    public LinkManager() {
        Future future = this.submit(() -> {
            this.communicationThread = Thread.currentThread();
            log.info("communicationThread lookup DONE");
        });
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        this.engineState = new EngineState(new EngineState.EngineStateListenerImpl(){

            @Override
            public void beforeLine(String fullLine) {
                HeartBeatListeners.onDataArrived();
            }
        });
        this.commandQueue = new CommandQueue(this);
    }

    @NotNull
    public CountDownLatch connect(String port) {
        final CountDownLatch connected = new CountDownLatch(1);
        this.startAndConnect(port, new ConnectionStateListener(){

            @Override
            public void onConnectionFailed(String s) {
                IoUtils.exit("CONNECTION FAILED, did you specify the right port name?", -1);
            }

            @Override
            public void onConnectionEstablished() {
                connected.countDown();
            }
        });
        return connected;
    }

    public void execute(Runnable runnable) {
        this.COMMUNICATION_EXECUTOR.execute(runnable);
    }

    public Future submit(Runnable runnable) {
        return this.COMMUNICATION_EXECUTOR.submit(runnable);
    }

    public static String[] getCommPorts() {
        SerialPort[] ports = SerialPort.getCommPorts();
        TreeSet<String> names = new TreeSet<String>();
        for (SerialPort port : ports) {
            names.add(port.getSystemPortName());
        }
        return names.toArray(new String[0]);
    }

    public BinaryProtocol getBinaryProtocol() {
        return this.getCurrentStreamState();
    }

    public BinaryProtocol getCurrentStreamState() {
        Objects.requireNonNull(this.connector, "connector");
        return this.connector.getBinaryProtocol();
    }

    public BinaryProtocolState getBinaryProtocolState() {
        return this.connector.getBinaryProtocolState();
    }

    public CommandQueue getCommandQueue() {
        return this.commandQueue;
    }

    public LinkManager setCompositeLogicEnabled(boolean compositeLogicEnabled) {
        this.compositeLogicEnabled = compositeLogicEnabled;
        return this;
    }

    public boolean getCompositeLogicEnabled() {
        return this.compositeLogicEnabled;
    }

    public boolean getNeedPullData() {
        return this.needPullData;
    }

    public boolean isNeedPullText() {
        return this.needPullText;
    }

    public boolean isNeedPullLiveData() {
        return this.needPullLiveData;
    }

    public LinkManager setNeedPullLiveData(boolean needPullLiveData) {
        this.needPullLiveData = needPullLiveData;
        return this;
    }

    public LinkManager setNeedPullData(boolean needPullData) {
        this.needPullData = needPullData;
        return this;
    }

    public LinkManager setNeedPullText(boolean needPullText) {
        this.needPullText = needPullText;
        return this;
    }

    public void disconnect() {
        this.isDisconnectedByUser = true;
        this.close();
    }

    public void reconnect() {
        this.isDisconnectedByUser = false;
        this.restart();
    }

    public void assertCommunicationThread() {
        if (Thread.currentThread() != this.communicationThread) {
            IllegalStateException e = new IllegalStateException("Communication on wrong thread. Use linkManager.execute or linkManager.submit");
            e.printStackTrace();
            log.error(e.getMessage(), e);
            throw e;
        }
    }

    public EngineState getEngineState() {
        return this.engineState;
    }

    public void startAndConnect(String port, ConnectionStateListener stateListener) {
        Objects.requireNonNull(port, "port");
        this.start(port, stateListener);
        this.connector.connectAndReadConfiguration(new BinaryProtocol.Arguments(true), stateListener);
    }

    @NotNull
    public LinkConnector getConnector() {
        return this.connector;
    }

    public void start(final String port, final ConnectionFailedListener stateListener) {
        Objects.requireNonNull(port, "port");
        log.info("LinkManager: Starting " + port);
        this.lastTriedPort = port;
        if (LinkManager.isLogViewerMode(port)) {
            this.setConnector(LinkConnector.VOID);
        } else if (PCAN.equals(port)) {
            Callable<IoStream> streamFactory = PCanIoStream::createStream;
            this.setConnector(new StreamConnector(this, streamFactory));
        } else if (SOCKET_CAN.equals(port)) {
            Callable<IoStream> streamFactory = SocketCANIoStream::createStream;
            this.setConnector(new StreamConnector(this, streamFactory));
        } else if (TcpConnector.isTcpPort(port)) {
            Callable<IoStream> streamFactory = new Callable<IoStream>(){

                @Override
                public IoStream call() {
                    LinkManager.this.messageListener.postMessage(this.getClass(), "Opening TCP port: " + port);
                    try {
                        return TcpIoStream.open(port);
                    }
                    catch (Throwable e) {
                        log.error("TCP error " + e);
                        stateListener.onConnectionFailed("Error " + e);
                        return null;
                    }
                }
            };
            this.setConnector(new StreamConnector(this, streamFactory));
            isSimulationMode = true;
        } else {
            Callable<IoStream> ioStreamCallable = new Callable<IoStream>(){

                @Override
                public IoStream call() {
                    LinkManager.this.messageListener.postMessage(this.getClass(), "Opening port: " + port);
                    IoStream stream = BufferedSerialIoStream.openPort(port);
                    if (stream == null) {
                        return null;
                    }
                    return stream;
                }
            };
            this.setConnector(new StreamConnector(this, ioStreamCallable));
        }
    }

    public void setConnector(LinkConnector connector) {
        if (this.isStarted) {
            throw new IllegalStateException("Already started");
        }
        this.isStarted = true;
        this.connector = connector;
    }

    public static boolean isLogViewerMode(String port) {
        Objects.requireNonNull(port, "port");
        return port.equals(LOG_VIEWER);
    }

    public boolean isLogViewer() {
        return this.connector == LinkConnector.VOID;
    }

    public void send(String command, boolean fireEvent) throws InterruptedException {
        if (this.connector == null) {
            throw new NullPointerException("connector");
        }
        this.connector.send(command, fireEvent);
    }

    public void restart() {
        if (this.isDisconnectedByUser) {
            return;
        }
        this.close();
        String[] ports = LinkManager.getCommPorts();
        boolean isPortAvailableAgain = Arrays.asList(ports).contains(this.lastTriedPort);
        log.info("restart isPortAvailableAgain=" + isPortAvailableAgain);
        if (isPortAvailableAgain) {
            this.connect(this.lastTriedPort);
        }
    }

    @Override
    public void close() {
        ConnectionStatusLogic.INSTANCE.setValue(ConnectionStatusValue.NOT_CONNECTED);
        if (this.connector != null) {
            this.connector.stop();
        }
        this.isStarted = false;
    }

    public static String unpackConfirmation(String message) {
        if (message.startsWith("confirmation_")) {
            return message.substring("confirmation_".length());
        }
        return null;
    }

    public static String getDefaultPort() {
        Object[] ports = LinkManager.getCommPorts();
        if (ports.length == 0) {
            System.out.println("Port not specified and no ports found");
            return null;
        }
        String port = ports[ports.length - 1];
        System.out.println("Using last of " + ports.length + " port(s)");
        System.out.println("All ports: " + Arrays.toString(ports));
        return port;
    }

    public static interface MessagesListener {
        public void postMessage(Class<?> var1, String var2);
    }

    public static enum LogLevel {
        INFO,
        DEBUG,
        TRACE;


        public boolean isDebugEnabled() {
            return this == DEBUG || this == TRACE;
        }
    }
}

