/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autodetect;

import com.devexperts.logging.Logging;
import com.rusefi.NamedThreadFactory;
import com.rusefi.autodetect.SerialAutoChecker;
import com.rusefi.io.LinkManager;
import com.rusefi.io.serial.BaudRateHolder;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortDetector {
    private static final Logging log = Logging.getLogging(PortDetector.class);
    private static final NamedThreadFactory AUTO_DETECT_PORT = new NamedThreadFactory("ECU AutoDetectPort", true);
    public static final String AUTO = "auto";

    @NotNull
    public static SerialAutoChecker.AutoDetectResult autoDetectSerial(Function<SerialAutoChecker.CallbackContext, Void> callback, DetectorMode mode) {
        String rusEfiAddress = System.getProperty("rusefi.address");
        if (rusEfiAddress != null) {
            return PortDetector.getSignatureFromPorts(mode, callback, Set.of(rusEfiAddress));
        }
        Set<String> serialPorts = LinkManager.getCommPorts();
        if (serialPorts.isEmpty()) {
            log.error("No serial ports detected");
            return new SerialAutoChecker.AutoDetectResult(null, null);
        }
        log.info("Trying [" + String.join((CharSequence)", ", serialPorts) + "]");
        return PortDetector.getSignatureFromPorts(mode, callback, serialPorts);
    }

    @NotNull
    private static SerialAutoChecker.AutoDetectResult getSignatureFromPorts(final DetectorMode mode, final Function<SerialAutoChecker.CallbackContext, Void> callback, Set<String> serialPorts) {
        ArrayList<Thread> serialFinder = new ArrayList<Thread>();
        final CountDownLatch portFound = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        for (final String serialPort : serialPorts) {
            Thread thread = AUTO_DETECT_PORT.newThread(new Runnable(){

                @Override
                public void run() {
                    if (mode == DetectorMode.DETECT_ELM327) {
                        BaudRateHolder.INSTANCE.baudRate = 38400;
                    }
                    new SerialAutoChecker(mode, serialPort, portFound).openAndCheckResponse(mode, result, callback);
                }

                public String toString() {
                    return serialPort + " " + super.toString();
                }
            });
            serialFinder.add(thread);
            thread.start();
        }
        try {
            portFound.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        log.info("Now interrupting " + serialFinder);
        try {
            for (Thread thread : serialFinder) {
                log.info("Interrupting " + thread);
                thread.interrupt();
            }
        }
        catch (RuntimeException e) {
            log.error("Unexpected runtime", e);
        }
        log.info("Done interrupting!");
        SerialAutoChecker.AutoDetectResult autoDetectResult = (SerialAutoChecker.AutoDetectResult)result.get();
        if (autoDetectResult == null) {
            autoDetectResult = new SerialAutoChecker.AutoDetectResult(null, null);
        }
        log.debug("Found " + autoDetectResult + " now stopping threads");
        return autoDetectResult;
    }

    public static SerialAutoChecker.AutoDetectResult autoDetectSerial(Function<SerialAutoChecker.CallbackContext, Void> callback) {
        return PortDetector.autoDetectSerial(callback, DetectorMode.DETECT_TS);
    }

    @Nullable
    public static SerialAutoChecker.AutoDetectResult autoDetectPort(JFrame parent) {
        SerialAutoChecker.AutoDetectResult autoDetectedPort = PortDetector.autoDetectSerial(null);
        if (autoDetectedPort.getSerialPort() == null) {
            JOptionPane.showMessageDialog(parent, "Failed to locate rusEFI");
            return null;
        }
        return autoDetectedPort;
    }

    public static String autoDetectSerialIfNeeded(String port) {
        if (!PortDetector.isAutoPort(port)) {
            return port;
        }
        return PortDetector.autoDetectSerial(null).getSerialPort();
    }

    public static boolean isAutoPort(String port) {
        return port.toLowerCase().startsWith(AUTO);
    }

    public static enum DetectorMode {
        DETECT_TS,
        DETECT_ELM327;

    }
}

