/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.FileLog;
import com.rusefi.SerialPortScanner;
import com.rusefi.StartupFrame;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.maintenance.UpdateStatusWindow;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.util.DefaultExceptionHandler;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.ToolButtons;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class BasicStartupFrame {
    private final FrameHelper frame;

    public static void main(String[] args) {
        BasicStartupFrame.runTool(null);
    }

    public static void runTool(String[] args) {
        DefaultExceptionHandler.install();
        new BasicStartupFrame().runTool();
    }

    public BasicStartupFrame() {
        String whiteLabel = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties());
        String title = whiteLabel + " basic console 20240808";
        this.frame = FrameHelper.createFrame(title);
        JPanel panel = new JPanel(new VerticalFlowLayout());
        if (FileLog.isWindows()) {
            panel.add(ToolButtons.createShowDeviceManagerButton());
            panel.add(StartupFrame.binaryModificationControl());
            JButton update = ProgramSelector.createUpdateFirmwareButton();
            boolean requireBlt = FindFileHelper.isObfuscated();
            if (requireBlt) {
                update.setEnabled(false);
                JLabel noPortsMessage = new JLabel();
                noPortsMessage.setForeground(Color.red);
                panel.add(noPortsMessage);
                StatusAnimation status = new StatusAnimation(noPortsMessage::setText, "Scanning ports");
                SerialPortScanner.INSTANCE.addListener(currentHardware -> SwingUtilities.invokeLater(() -> {
                    status.stop();
                    this.frame.getFrame().pack();
                    List ecuPorts = currentHardware.getKnownPorts().stream().filter(portResult -> portResult.type == SerialPortScanner.SerialPortType.EcuWithOpenblt).collect(Collectors.toList());
                    List bootloaderPorts = currentHardware.getKnownPorts().stream().filter(portResult -> portResult.type == SerialPortScanner.SerialPortType.OpenBlt).collect(Collectors.toList());
                    if (!ecuPorts.isEmpty()) {
                        noPortsMessage.setVisible(false);
                        update.setEnabled(true);
                        update.setText("Auto Update Firmware");
                        update.addActionListener(e -> ProgramSelector.executeJob(update, "Auto OpenBLT Update", (SerialPortScanner.PortResult)ecuPorts.get(0)));
                    } else if (!bootloaderPorts.isEmpty()) {
                        noPortsMessage.setVisible(false);
                        update.setEnabled(true);
                        update.setText("Blt Update Firmware");
                        update.addActionListener(e -> ProgramSelector.executeJob(update, "Manual OpenBLT Update", (SerialPortScanner.PortResult)bootloaderPorts.get(0)));
                    } else {
                        noPortsMessage.setText("ECU not found");
                    }
                }));
            } else {
                update.addActionListener(e -> DfuFlasher.doAutoDfu(update, "auto", new UpdateStatusWindow("Update")));
            }
            panel.add(update);
        } else {
            panel.add(new JLabel("Sorry only works on Windows"));
        }
        panel.add(new HorizontalLine());
        JLabel logoLabel = LogoHelper.createLogoLabel();
        if (logoLabel != null) {
            panel.add(logoLabel);
        }
        if (ConnectionAndMeta.isDefaultWhitelabel(whiteLabel)) {
            panel.add(LogoHelper.createUrlLabel());
        }
        this.frame.showFrame(panel, false);
        UiUtils.centerWindow(this.frame.getFrame());
    }

    private void runTool() {
    }
}

