/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.rusefi.FileLog;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.models.Utils;
import com.rusefi.ui.util.URLLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VersionChecker {
    private static final Logging log = Logging.getLogging(VersionChecker.class);
    private static final String JAVA_CONSOLE_TAG = "java_console";
    private static final String FIRMWARE_TAG = "firmware";
    private static final String VERSIONS_URL = "https://rusefi.com/console/versions.txt";
    private static final VersionChecker instance = new VersionChecker();
    private final Map<String, String> map = new HashMap<String, String>();
    private int previousReportedVersion;

    private VersionChecker() {
    }

    public static void start() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    instance.readAndProcess();
                }
                catch (IOException e) {
                    FileLog.MAIN.logLine("Failed to read from https://rusefi.com/console/versions.txt" + e);
                }
            }
        }, "version checker");
        t.setDaemon(true);
        t.start();
    }

    private void readAndProcess() throws IOException {
        String line;
        URL url = new URL(VERSIONS_URL);
        BufferedReader s = new BufferedReader(new InputStreamReader(url.openStream()));
        log.info("Reading from https://rusefi.com/console/versions.txt");
        while ((line = s.readLine()) != null) {
            String[] pair = line.split("=");
            if (pair.length != 2) continue;
            this.map.put(pair[0], pair[1]);
        }
        Integer javaVersion = this.parseNotNull(this.map.get(JAVA_CONSOLE_TAG), "VC value");
        log.info("Server recommends java_console version " + javaVersion + " or newer");
        VersionChecker.showUpdateWarningIfNeeded("dev console", javaVersion, 20240812);
        log.info("Server recommends firmware " + this.map.get(FIRMWARE_TAG) + " or newer");
        String criticalUrl = this.map.get("critical_url");
        if (criticalUrl != null && !criticalUrl.trim().isEmpty()) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel("WARNING! CRITICAL ISSUE! Are you sure you want to run rusEFI?"), "North");
            panel.add((Component)new URLLabel(criticalUrl, criticalUrl), "Center");
            JOptionPane.showMessageDialog(VersionChecker.getPaneParent(), panel);
        }
    }

    private int parseNotNull(String value, String reason) throws IOException {
        if (value == null) {
            throw new IOException("Unexpected file format");
        }
        return Utils.parseIntWithReason(value, reason);
    }

    private static void showUpdateWarningIfNeeded(final String componentName, final Integer latestVersion, final int currentVersion) {
        if (latestVersion == null || currentVersion >= latestVersion) {
            return;
        }
        if (PersistentConfiguration.getConfig().getRoot().getProperty(componentName).equals(Integer.toString(latestVersion))) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel panel = new JPanel(new BorderLayout());
                String message = "<html>It's time to update " + componentName + "!<br>Your version: " + currentVersion + "<br>Latest version: " + latestVersion;
                panel.add((Component)new JLabel(message), "North");
                JCheckBox doNotShowForThisVersion = new JCheckBox("Do not show for this version");
                panel.add((Component)doNotShowForThisVersion, "Center");
                JOptionPane.showMessageDialog(VersionChecker.getPaneParent(), panel, "Update", 2);
                if (doNotShowForThisVersion.isSelected()) {
                    PersistentConfiguration.getConfig().getRoot().setProperty(componentName, latestVersion);
                }
            }
        });
    }

    private static Component getPaneParent() {
        return JFrame.getFrames()[0];
    }

    public static VersionChecker getInstance() {
        return instance;
    }

    public void onFirmwareVersion(String firmwareString) {
        int version;
        String suggestedFirmware = this.map.get(FIRMWARE_TAG);
        if (suggestedFirmware == null) {
            return;
        }
        int latestVersion = Utils.parseIntWithReason(suggestedFirmware, "VC value");
        String[] tokens = firmwareString.split("[@\\s]");
        try {
            version = Integer.parseInt(tokens[1]);
        }
        catch (NumberFormatException e) {
            FileLog.MAIN.logLine("Error processing version [" + firmwareString + "]");
            return;
        }
        if (version == this.previousReportedVersion) {
            return;
        }
        this.previousReportedVersion = version;
        VersionChecker.showUpdateWarningIfNeeded(FIRMWARE_TAG, latestVersion, version);
    }
}

