/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class FindFileHelper {
    public static final String INPUT_FILES_PATH = System.getProperty("input_files_path", "..");
    public static final String FIRMWARE_BIN_FILE = INPUT_FILES_PATH + "/rusefi.bin";

    @Nullable
    public static String findFile(String fileDirectory, String prefix, String suffix) {
        File dir = new File(fileDirectory);
        if (!dir.isDirectory()) {
            return null;
        }
        System.out.println("Searching for " + prefix + "*" + suffix + " in " + dir.getAbsolutePath());
        for (String file : Objects.requireNonNull(dir.list())) {
            if (file.contains(" ") || !file.startsWith(prefix) || !file.endsWith(suffix)) continue;
            return fileDirectory + File.separator + file;
        }
        return null;
    }

    @Nullable
    public static String findSrecFile() {
        return FindFileHelper.findFile(INPUT_FILES_PATH, "", "srec");
    }

    public static boolean isObfuscated() {
        String srecFile = FindFileHelper.findSrecFile();
        return srecFile != null && srecFile.contains("obfuscated");
    }
}

