/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ConnectionAndMeta {
    public static final String BASE_URL_RELEASE = "https://github.com/rusefi/rusefi/releases/latest/download/";
    public static final String DEFAULT_WHITE_LABEL = "rusefi";
    public static final String AUTOUPDATE = "/autoupdate/";
    private static final int BUFFER_SIZE = 32768;
    public static final int CENTUM = 100;
    public static final String IO_PROPERTIES = "/shared_io.properties";
    private final String zipFileName;
    private HttpsURLConnection httpConnection;
    private long completeFileSize;
    private long lastModified;

    public ConnectionAndMeta(String zipFileName) {
        this.zipFileName = zipFileName;
    }

    public static String getBaseUrl() {
        String result = ConnectionAndMeta.getProperties().getProperty("auto_update_root_url");
        System.out.println(ConnectionAndMeta.class + ": got [" + result + "]");
        return result;
    }

    public static String getWhiteLabel(Properties properties) {
        return Optional.ofNullable(properties.getProperty("white_label")).map(String::trim).orElse(DEFAULT_WHITE_LABEL);
    }

    public static String getSignatureWhiteLabel() {
        String signatureWhiteLabel = ConnectionAndMeta.getProperties().getProperty("signature_white_label");
        signatureWhiteLabel = signatureWhiteLabel == null ? null : signatureWhiteLabel.trim();
        return signatureWhiteLabel;
    }

    public static boolean flexibleAutoscale() {
        return ConnectionAndMeta.getBoolean("flexible_autoscale");
    }

    public static boolean getBoolean(String propertyName) {
        return ConnectionAndMeta.getBoolean(propertyName, ConnectionAndMeta.getProperties());
    }

    public static boolean getBoolean(String propertyName, Properties properties) {
        String flag = properties.getProperty(propertyName);
        return Boolean.TRUE.toString().equalsIgnoreCase(flag);
    }

    public static Properties getProperties() throws RuntimeException {
        Properties props = new Properties();
        try {
            InputStream stream = ConnectionAndMeta.class.getResourceAsStream(IO_PROPERTIES);
            Objects.requireNonNull(stream, "Error reading /shared_io.properties");
            props.load(stream);
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDefaultAutoUpdateUrl() {
        return ConnectionAndMeta.getBaseUrl() + AUTOUPDATE;
    }

    public static void downloadFile(String localTargetFileName, ConnectionAndMeta connectionAndMeta, DownloadProgressListener listener) throws IOException {
        int newDataSize;
        HttpURLConnection httpConnection = connectionAndMeta.getHttpConnection();
        long completeFileSize = connectionAndMeta.getCompleteFileSize();
        Objects.requireNonNull(httpConnection, "httpConnection");
        BufferedInputStream in = new BufferedInputStream(httpConnection.getInputStream());
        FileOutputStream fos = new FileOutputStream(localTargetFileName);
        BufferedOutputStream bout = new BufferedOutputStream(fos, 32768);
        byte[] data = new byte[32768];
        long downloadedFileSize = 0L;
        int printedPercentage = 0;
        while ((newDataSize = in.read(data, 0, 32768)) >= 0) {
            int currentPercentage = (int)(100L * (downloadedFileSize += (long)newDataSize) / completeFileSize);
            if (currentPercentage > printedPercentage + 5) {
                System.out.println("Downloaded " + currentPercentage + "%");
                printedPercentage = currentPercentage;
                listener.onPercentage(currentPercentage);
            }
            bout.write(data, 0, newDataSize);
        }
        bout.close();
        in.close();
        new File(localTargetFileName).setLastModified(connectionAndMeta.getLastModified());
    }

    public static boolean isDefaultWhitelabel(String whiteLabel) {
        return DEFAULT_WHITE_LABEL.equals(whiteLabel);
    }

    public HttpURLConnection getHttpConnection() {
        return this.httpConnection;
    }

    public long getCompleteFileSize() {
        return this.completeFileSize;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public ConnectionAndMeta invoke(String baseUrl) throws IOException {
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new AcceptAnyCertificateTrustManager()}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException("TLS exception", e);
        }
        URL url = new URL(baseUrl + this.zipFileName);
        System.out.println("Connecting to " + url);
        this.httpConnection = (HttpsURLConnection)url.openConnection();
        this.httpConnection.setSSLSocketFactory(ctx.getSocketFactory());
        this.completeFileSize = this.httpConnection.getContentLength();
        this.lastModified = this.httpConnection.getLastModified();
        return this;
    }

    private static class AcceptAnyCertificateTrustManager
    implements X509TrustManager {
        private AcceptAnyCertificateTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public static interface DownloadProgressListener {
        public void onPercentage(int var1);
    }
}

