/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.rusefi.FileLog;
import com.rusefi.SerialPortScanner;
import com.rusefi.StartupFrame;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.maintenance.UpdateStatusWindow;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.util.DefaultExceptionHandler;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.ToolButtons;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class BasicStartupFrame {
    private static final Logging log = Logging.getLogging(BasicStartupFrame.class);
    private final FrameHelper frame;
    private final JLabel noPortsMessage = new JLabel();
    private final StatusAnimation status = new StatusAnimation(this.noPortsMessage::setText, "Scanning ports");
    private final JButton update = ProgramSelector.createUpdateFirmwareButton();
    private volatile Optional<SerialPortScanner.PortResult> portToUpdateFirmware = Optional.empty();

    public static void main(String[] args) {
        BasicStartupFrame.runTool(null);
    }

    public static void runTool(String[] args) {
        DefaultExceptionHandler.install();
        new BasicStartupFrame().runTool();
    }

    public BasicStartupFrame() {
        String whiteLabel = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties());
        String title = whiteLabel + " basic console 20240814";
        this.frame = FrameHelper.createFrame(title);
        JPanel panel = new JPanel(new VerticalFlowLayout());
        if (FileLog.isWindows()) {
            panel.add(ToolButtons.createShowDeviceManagerButton());
            panel.add(StartupFrame.binaryModificationControl());
            boolean requireBlt = FindFileHelper.isObfuscated();
            if (requireBlt) {
                this.update.addActionListener(e -> this.onUpdateButtonClicked());
                this.update.setEnabled(false);
                this.noPortsMessage.setForeground(Color.red);
                panel.add(this.noPortsMessage);
                SerialPortScanner.INSTANCE.addListener(currentHardware -> SwingUtilities.invokeLater(() -> this.onHardwareUpdated(currentHardware)));
            } else {
                this.update.addActionListener(e -> DfuFlasher.doAutoDfu(this.update, "auto", new UpdateStatusWindow("Update")));
            }
            panel.add(this.update);
        } else {
            panel.add(new JLabel("Sorry only works on Windows"));
        }
        panel.add(new HorizontalLine());
        JLabel logoLabel = LogoHelper.createLogoLabel();
        if (logoLabel != null) {
            panel.add(logoLabel);
        }
        if (ConnectionAndMeta.isDefaultWhitelabel(whiteLabel)) {
            panel.add(LogoHelper.createUrlLabel());
        }
        this.frame.showFrame(panel, false);
        UiUtils.centerWindow(this.frame.getFrame());
    }

    private void onHardwareUpdated(SerialPortScanner.AvailableHardware currentHardware) {
        this.status.stop();
        this.frame.getFrame().pack();
        List<SerialPortScanner.PortResult> ecuPorts = currentHardware.getKnownPorts(SerialPortScanner.SerialPortType.EcuWithOpenblt);
        List<SerialPortScanner.PortResult> bootloaderPorts = currentHardware.getKnownPorts(SerialPortScanner.SerialPortType.OpenBlt);
        int availablePortCount = ecuPorts.size() + bootloaderPorts.size();
        switch (availablePortCount) {
            case 0: {
                this.resetPort("ECU not found");
                break;
            }
            case 1: {
                if (!ecuPorts.isEmpty()) {
                    this.switchToPort(ecuPorts.get(0), "Auto Update Firmware");
                    break;
                }
                if (!bootloaderPorts.isEmpty()) {
                    this.switchToPort(bootloaderPorts.get(0), "Blt Update Firmware");
                    break;
                }
                log.error("Do nothing.");
                break;
            }
            default: {
                this.resetPort(String.format("Multiple ECUs found on: %s", Stream.concat(ecuPorts.stream(), bootloaderPorts.stream()).map(portResult -> portResult.port).collect(Collectors.joining(", "))));
            }
        }
    }

    private void switchToPort(SerialPortScanner.PortResult port, String updateButtonText) {
        this.portToUpdateFirmware = Optional.of(port);
        this.noPortsMessage.setVisible(false);
        this.update.setEnabled(true);
        this.update.setText(updateButtonText);
    }

    private void resetPort(String reason) {
        this.portToUpdateFirmware = Optional.empty();
        this.update.setEnabled(false);
        this.noPortsMessage.setText(reason);
        this.noPortsMessage.setVisible(true);
    }

    private void onUpdateButtonClicked() {
        this.portToUpdateFirmware.ifPresentOrElse(port -> {
            switch (port.type) {
                case EcuWithOpenblt: {
                    ProgramSelector.executeJob(this.update, "Auto OpenBLT Update", port);
                    break;
                }
                case OpenBlt: {
                    ProgramSelector.executeJob(this.update, "Manual OpenBLT Update", port);
                    break;
                }
                default: {
                    log.error(String.format("Unexpected port type: %s (%s)", new Object[]{port.type, port}));
                }
            }
        }, () -> log.error("Port to update firmware is not defined."));
    }

    private void runTool() {
    }
}

