/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public enum Scaler {
    INSTANCE;


    private double calcSignedPolygonArea(Point2D[] POLYGON) {
        int N = POLYGON.length;
        double area = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            area += POLYGON[i].getX() * POLYGON[j].getY();
            area -= POLYGON[i].getY() * POLYGON[j].getX();
        }
        return area /= 2.0;
    }

    public Point2D calcCenterOfMass(Point2D[] POLYGON) {
        int N = POLYGON.length;
        double cx = 0.0;
        double cy = 0.0;
        double area = this.calcSignedPolygonArea(POLYGON);
        Point2D.Double CENTROID = new Point2D.Double();
        double factor = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            factor = POLYGON[i].getX() * POLYGON[j].getY() - POLYGON[j].getX() * POLYGON[i].getY();
            cx += (POLYGON[i].getX() + POLYGON[j].getX()) * factor;
            cy += (POLYGON[i].getY() + POLYGON[j].getY()) * factor;
        }
        factor = 1.0 / (area *= 6.0);
        ((Point2D)CENTROID).setLocation(cx *= factor, cy *= factor);
        return CENTROID;
    }

    public Point2D[] getPointArrayOfShape(Shape SHAPE) {
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>(32);
        PathIterator PATH_ITERATOR = SHAPE.getPathIterator(null);
        int lastMoveToIndex = -1;
        while (!PATH_ITERATOR.isDone()) {
            double[] COORDINATES = new double[6];
            switch (PATH_ITERATOR.currentSegment(COORDINATES)) {
                case 0: {
                    pointList.add(new Point2D.Double(COORDINATES[0], COORDINATES[1]));
                    ++lastMoveToIndex;
                    break;
                }
                case 1: {
                    pointList.add(new Point2D.Double(COORDINATES[0], COORDINATES[1]));
                    break;
                }
                case 2: {
                    pointList.add(new Point2D.Double(COORDINATES[0], COORDINATES[1]));
                    pointList.add(new Point2D.Double(COORDINATES[2], COORDINATES[3]));
                    break;
                }
                case 3: {
                    pointList.add(new Point2D.Double(COORDINATES[0], COORDINATES[1]));
                    pointList.add(new Point2D.Double(COORDINATES[2], COORDINATES[3]));
                    pointList.add(new Point2D.Double(COORDINATES[4], COORDINATES[5]));
                    break;
                }
                case 4: {
                    if (lastMoveToIndex < 0) break;
                    pointList.add((Point2D.Double)pointList.get(lastMoveToIndex));
                }
            }
            PATH_ITERATOR.next();
        }
        Point2D[] POINT_ARRAY = new Point2D[pointList.size()];
        return POINT_ARRAY;
    }

    public Point2D getCentroid(Shape SHAPE) {
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>(32);
        PathIterator PATH_ITERATOR = SHAPE.getPathIterator(null);
        int lastMoveToIndex = -1;
        while (!PATH_ITERATOR.isDone()) {
            double[] COORDINATES = new double[6];
            switch (PATH_ITERATOR.currentSegment(COORDINATES)) {
                case 0: {
                    pointList.add(new Point2D.Double(COORDINATES[0], COORDINATES[1]));
                    ++lastMoveToIndex;
                    break;
                }
                case 1: {
                    pointList.add(new Point2D.Double(COORDINATES[0], COORDINATES[1]));
                    break;
                }
                case 2: {
                    pointList.add(new Point2D.Double(COORDINATES[0], COORDINATES[1]));
                    pointList.add(new Point2D.Double(COORDINATES[2], COORDINATES[3]));
                    break;
                }
                case 3: {
                    pointList.add(new Point2D.Double(COORDINATES[0], COORDINATES[1]));
                    pointList.add(new Point2D.Double(COORDINATES[2], COORDINATES[3]));
                    pointList.add(new Point2D.Double(COORDINATES[4], COORDINATES[5]));
                    break;
                }
                case 4: {
                    if (lastMoveToIndex < 0) break;
                    pointList.add((Point2D.Double)pointList.get(lastMoveToIndex));
                }
            }
            PATH_ITERATOR.next();
        }
        Point2D[] POINT_ARRAY = new Point2D[pointList.size()];
        pointList.toArray(POINT_ARRAY);
        return this.calcCenterOfMass(POINT_ARRAY);
    }

    public Point2D getCentroid(Point2D[] POINT_ARRAY) {
        return this.calcCenterOfMass(POINT_ARRAY);
    }

    public Shape scale(Shape SHAPE, double SCALE_FACTOR) {
        Point2D CENTROID = this.getCentroid(SHAPE);
        AffineTransform TRANSFORM = AffineTransform.getTranslateInstance((1.0 - SCALE_FACTOR) * CENTROID.getX(), (1.0 - SCALE_FACTOR) * CENTROID.getY());
        TRANSFORM.scale(SCALE_FACTOR, SCALE_FACTOR);
        return TRANSFORM.createTransformedShape(SHAPE);
    }

    public Shape scale(Shape SHAPE, double SCALE_FACTOR, Point2D SCALE_CENTER) {
        AffineTransform TRANSFORM = AffineTransform.getTranslateInstance((1.0 - SCALE_FACTOR) * SCALE_CENTER.getX(), (1.0 - SCALE_FACTOR) * SCALE_CENTER.getY());
        TRANSFORM.scale(SCALE_FACTOR, SCALE_FACTOR);
        return TRANSFORM.createTransformedShape(SHAPE);
    }
}

