/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.proxy;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.config.generated.Fields;
import com.rusefi.io.AbstractConnectionStateListener;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkManager;
import com.rusefi.io.commands.HelloCommand;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.io.tcp.TcpIoStream;
import com.rusefi.proxy.BaseBroadcastingThread;
import com.rusefi.proxy.NetworkConnectorContext;
import com.rusefi.server.ControllerInfo;
import com.rusefi.server.SessionDetails;
import com.rusefi.server.rusEFISSLContext;
import com.rusefi.tools.VehicleToken;
import com.rusefi.tools.online.HttpUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NetworkConnector
implements Closeable {
    public static final byte DISCONNECT = 14;
    public static final byte UPDATE_CONNECTOR_SOFTWARE_LATEST = 15;
    public static final byte UPDATE_FIRMWARE_LATEST = 16;
    public static final byte UPDATE_CONNECTOR_SOFTWARE_RELEASE = 17;
    public static final byte UPDATE_FIRMWARE_RELEASE = 17;
    private static final Logging log = Logging.getLogging(NetworkConnector.class);
    private boolean isClosed;

    public NetworkConnectorResult start(Implementation implementation, String authToken, String controllerPort, NetworkConnectorContext context) {
        return this.start(implementation, authToken, controllerPort, context, new ReconnectListener(){

            @Override
            public void onReconnect() {
                log.info("onReconnect");
            }
        });
    }

    public NetworkConnectorResult start(Implementation implementation, String authToken, String controllerPort, NetworkConnectorContext context, ReconnectListener reconnectListener) {
        LinkManager controllerConnector = new LinkManager().setCompositeLogicEnabled(false).setNeedPullData(false);
        final CountDownLatch onConnected = new CountDownLatch(1);
        controllerConnector.startAndConnect(controllerPort, new AbstractConnectionStateListener(){

            @Override
            public void onConnectionEstablished() {
                onConnected.countDown();
            }
        });
        log.info("Connecting to controller...");
        try {
            onConnected.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        if (onConnected.getCount() != 0L) {
            log.info("Connection to controller failed");
            return NetworkConnectorResult.ERROR;
        }
        return this.start(implementation, authToken, context, reconnectListener, controllerConnector, ActivityListener.VOID);
    }

    public NetworkConnectorResult start(Implementation implementation, String authToken, NetworkConnectorContext context, ReconnectListener reconnectListener, LinkManager linkManager, ActivityListener activityListener) {
        ControllerInfo controllerInfo;
        try {
            controllerInfo = NetworkConnector.getControllerInfo(linkManager, linkManager.getConnector().getBinaryProtocol().getStream());
        }
        catch (IOException e) {
            return NetworkConnectorResult.ERROR;
        }
        int vehicleToken = VehicleToken.getOrCreate();
        BinaryProtocolServer.getThreadFactory("Proxy Reconnect").newThread(() -> {
            Semaphore proxyReconnectSemaphore = new Semaphore(1);
            try {
                while (!this.isClosed) {
                    proxyReconnectSemaphore.acquire();
                    try {
                        NetworkConnector.start(implementation, activityListener, context.serverPortForControllers(), linkManager, authToken, message -> {
                            log.error(message + " Disconnect from proxy server detected, now sleeping " + context.reconnectDelay() + " seconds");
                            BinaryProtocol.sleep(context.reconnectDelay() * 1000);
                            log.debug("Releasing semaphore");
                            proxyReconnectSemaphore.release();
                            reconnectListener.onReconnect();
                        }, vehicleToken, controllerInfo, context);
                    }
                    catch (IOException e) {
                        log.error("IO error", e);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }).start();
        return new NetworkConnectorResult(controllerInfo, vehicleToken);
    }

    @NotNull
    private static SessionDetails start(Implementation implementation, final ActivityListener activityListener, int serverPortForControllers, LinkManager linkManager, String authToken, TcpIoStream.DisconnectListener disconnectListener, int oneTimeToken, ControllerInfo controllerInfo, final NetworkConnectorContext context) throws IOException {
        Socket socket;
        final IoStream targetEcuSocket = linkManager.getConnector().getBinaryProtocol().getStream();
        SessionDetails deviceSessionDetails = new SessionDetails(implementation, controllerInfo, authToken, oneTimeToken, 20240817);
        try {
            log.info("Connecting to proxy server " + HttpUtil.RUSEFI_PROXY_HOSTNAME + " " + serverPortForControllers);
            socket = rusEFISSLContext.getSSLSocket(HttpUtil.RUSEFI_PROXY_HOSTNAME, serverPortForControllers);
        }
        catch (IOException e) {
            disconnectListener.onDisconnect("on socket open");
            return deviceSessionDetails;
        }
        BaseBroadcastingThread baseBroadcastingThread = new BaseBroadcastingThread(socket, deviceSessionDetails, disconnectListener, context){

            @Override
            protected void handleCommand(BinaryProtocolServer.Packet packet, TcpIoStream stream) throws IOException {
                super.handleCommand(packet, stream);
                byte command = packet.getPacket()[0];
                if (command == 122) {
                    byte connectorCommand = packet.getPacket()[1];
                    log.info("Got connector command " + packet.getPacket());
                    if (connectorCommand == 15) {
                        context.onConnectorSoftwareUpdateToLatestRequest();
                    } else if (connectorCommand == 17) {
                        context.onConnectorSoftwareUpdateToReleaseRequest();
                    } else if (connectorCommand == 16) {
                        context.onFirmwareUpdateToLatestRequest();
                    } else if (connectorCommand == 17) {
                        context.onFirmwareUpdateToReleaseRequest();
                    }
                    return;
                }
                log.info("Relaying request to controller " + BinaryProtocol.findCommand(command));
                targetEcuSocket.sendPacket(packet);
                BinaryProtocolServer.Packet response = targetEcuSocket.readPacket();
                log.info("Relaying response to proxy size=" + response.getPacket().length);
                stream.sendPacket(response);
                activityListener.onActivity(targetEcuSocket);
            }
        };
        baseBroadcastingThread.start();
        return deviceSessionDetails;
    }

    @NotNull
    private static ControllerInfo getControllerInfo(LinkManager linkManager, IoStream targetEcuSocket) throws IOException {
        HelloCommand.send(targetEcuSocket);
        String helloResponse = HelloCommand.getHelloResponse(targetEcuSocket.getDataBuffer());
        if (helloResponse == null) {
            throw new IOException("Error getting hello response");
        }
        String controllerSignature = helloResponse.trim();
        ConfigurationImage image = linkManager.getConnector().getBinaryProtocol().getControllerConfiguration();
        String vehicleName = Fields.VEHICLENAME.getStringValue(image);
        String engineMake = Fields.ENGINEMAKE.getStringValue(image);
        String engineCode = Fields.ENGINECODE.getStringValue(image);
        return new ControllerInfo(vehicleName, engineMake, engineCode, controllerSignature);
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public static enum Implementation {
        Android,
        Plugin,
        SBC,
        Unknown;


        public static Implementation find(String name) {
            for (Implementation implementation : Implementation.values()) {
                if (!implementation.name().equalsIgnoreCase(name)) continue;
                return implementation;
            }
            return Unknown;
        }
    }

    public static interface ActivityListener {
        public static final ActivityListener VOID = new ActivityListener(){

            @Override
            public void onActivity(IoStream targetEcuSocket) {
            }
        };

        public void onActivity(IoStream var1);
    }

    public static interface ReconnectListener {
        public static final ReconnectListener VOID = new ReconnectListener(){

            @Override
            public void onReconnect() {
            }
        };

        public void onReconnect();
    }

    public static class NetworkConnectorResult {
        static NetworkConnectorResult ERROR = new NetworkConnectorResult(null, 0);
        private final ControllerInfo controllerInfo;
        private final int oneTimeToken;

        public NetworkConnectorResult(ControllerInfo controllerInfo, int oneTimeToken) {
            this.controllerInfo = controllerInfo;
            this.oneTimeToken = oneTimeToken;
        }

        public ControllerInfo getControllerInfo() {
            return this.controllerInfo;
        }

        public int getOneTimeToken() {
            return this.oneTimeToken;
        }

        public String toString() {
            return "NetworkConnectorResult{controllerInfo=" + this.controllerInfo + "}";
        }
    }
}

