/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.FileLogger;
import com.rusefi.util.LazyFileImpl;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.jetbrains.annotations.Nullable;

@Deprecated
public enum FileLog {
    MAIN,
    SIMULATOR_CONSOLE;

    public static final String LOG_INFO_TEXT = "Writing logs to 'logs/'";
    public static final String OS_VERSION = "os.version";
    private static final String WIKI_URL = "https://github.com/rusefi/rusefi/wiki/rusEFI-logs-folder";
    public static String currentLogName;
    @Nullable
    private OutputStream fileLog;
    public static boolean suspendLogging;

    public static String getDate() {
        return FileLogger.getDate();
    }

    public void start() {
        if (this.fileLog != null) {
            return;
        }
        try {
            this.fileLog = this.openLog();
        }
        catch (FileNotFoundException e) {
            return;
        }
        new Thread(FileLog::writeReadmeFile).start();
    }

    private static void writeReadmeFile() {
        LazyFileImpl file = new LazyFileImpl("logs/README.html");
        file.write("<center><a href='https://github.com/rusefi/rusefi/wiki/rusEFI-logs-folder'>More info online<br/><img src=https://raw.githubusercontent.com/wiki/rusefi/rusefi/logo.gif></a>");
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isLinux() {
        return FileLog.getOsName().equalsIgnoreCase("Linux");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean is32bitJava() {
        return System.getProperty("os.arch").contains("86");
    }

    public static boolean isWindows() {
        return FileLog.getOsName().contains("Windows");
    }

    private FileOutputStream openLog() throws FileNotFoundException {
        FileLogger.createFolderIfNeeded();
        String shortFileName = this.name() + "_rfi_report_" + FileLogger.date;
        currentLogName = shortFileName + ".csv";
        String fullFileName = "logs/" + currentLogName;
        FileLog.rlog("Writing to " + fullFileName);
        return new FileOutputStream(fullFileName, true);
    }

    public synchronized void logLine(String fullLine) {
        String withDate = FileLog.getDate() + "<EOT>: " + fullLine;
        System.out.println(withDate);
        if (suspendLogging) {
            return;
        }
        if (this.fileLog == null) {
            return;
        }
        try {
            this.fileLog.write((withDate + "\r\n").getBytes());
            this.fileLog.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void close() {
        if (this.fileLog == null) {
            return;
        }
        try {
            FileLog.rlog("Closing file...");
            this.fileLog.close();
            this.fileLog = null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void rlog(String msg) {
        System.out.println("rlog " + msg);
    }

    public void log(Throwable exception) {
        if (this.fileLog == null) {
            throw new NullPointerException("fileLog while " + exception);
        }
        OutputStreamWriter os = new OutputStreamWriter(this.fileLog);
        exception.printStackTrace(new PrintWriter(os));
    }
}

