/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.util;

import com.devexperts.logging.Logging;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DefaultExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logging log = Logging.getLogging(DefaultExceptionHandler.class);
    private static boolean hadExceptionAlready;

    public static void install() {
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        DefaultExceptionHandler.handleException(e);
    }

    public static void handleException(Throwable e) {
        if (e == null) {
            log.info("Null exception?");
            throw new NullPointerException("Throwable e");
        }
        e.printStackTrace();
        if (hadExceptionAlready) {
            return;
        }
        hadExceptionAlready = true;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)new JLabel(e.toString()), "North");
        JTextArea textArea = new JTextArea(baos.toString());
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(textArea){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(500, 400);
            }
        };
        content.add((Component)scrollPane, "Center");
        JOptionPane.showConfirmDialog(DefaultExceptionHandler.findActiveFrame(), content, "20240826: Exception Occurred", -1);
        log.info("handleException: " + baos.toString());
    }

    private static Frame findActiveFrame() {
        Frame[] frames;
        for (Frame frame : frames = JFrame.getFrames()) {
            if (!frame.isVisible()) continue;
            return frame;
        }
        return null;
    }
}

