/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.io.IoStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractIoStream
implements IoStream {
    private boolean isClosed;
    protected final StreamStats streamStats = new StreamStats();
    private final AtomicInteger bytesOut = new AtomicInteger();
    private long latestActivity;

    public IncomingDataBuffer createDataBuffer() {
        IncomingDataBuffer incomingData = new IncomingDataBuffer(this.getClass().getSimpleName(), this.getStreamStats());
        this.setInputListener(incomingData::addData);
        return incomingData;
    }

    @Override
    public StreamStats getStreamStats() {
        return this.streamStats;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.bytesOut.addAndGet(bytes.length);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void onActivity() {
        this.latestActivity = System.currentTimeMillis();
    }

    @Override
    public long latestActivityTime() {
        return this.latestActivity;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int getBytesIn() {
        return this.streamStats.totalBytesArrived.get();
    }

    @Override
    public int getBytesOut() {
        return this.bytesOut.get();
    }

    public class StreamStats {
        private long previousPacketArrivalTime;
        private int maxPacketGap;
        private final AtomicInteger totalBytesArrived = new AtomicInteger();

        public long getPreviousPacketArrivalTime() {
            return this.previousPacketArrivalTime;
        }

        public int getMaxPacketGap() {
            return this.maxPacketGap;
        }

        public void onPacketArrived() {
            long now = System.currentTimeMillis();
            if (this.previousPacketArrivalTime != 0L) {
                this.maxPacketGap = (int)Math.max((long)this.maxPacketGap, now - this.previousPacketArrivalTime);
            }
            this.previousPacketArrivalTime = now;
            AbstractIoStream.this.onActivity();
        }

        public void onArrived(int length) {
            this.totalBytesArrived.addAndGet(length);
        }
    }
}

