/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.SerialPortScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AvailableHardware {
    private final List<SerialPortScanner.PortResult> ports;
    private final boolean dfuFound;
    private final boolean stLinkConnected;
    private final boolean PCANConnected;

    public AvailableHardware(List<SerialPortScanner.PortResult> ports, boolean dfuFound, boolean stLinkConnected, boolean PCANConnected) {
        this.ports = ports;
        this.dfuFound = dfuFound;
        this.stLinkConnected = stLinkConnected;
        this.PCANConnected = PCANConnected;
    }

    @NotNull
    public List<SerialPortScanner.PortResult> getKnownPorts() {
        return new ArrayList<SerialPortScanner.PortResult>(this.ports);
    }

    public List<SerialPortScanner.PortResult> getKnownPorts(SerialPortScanner.SerialPortType type) {
        return this.ports.stream().filter(port -> port.type == type).collect(Collectors.toList());
    }

    public boolean isDfuFound() {
        return this.dfuFound;
    }

    public boolean isStLinkConnected() {
        return this.stLinkConnected;
    }

    public boolean isPCANConnected() {
        return this.PCANConnected;
    }

    public boolean isPortAvailable(SerialPortScanner.PortResult port) {
        return this.ports.contains(port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableHardware that = (AvailableHardware)o;
        return this.dfuFound == that.dfuFound && this.stLinkConnected == that.stLinkConnected && this.PCANConnected == that.PCANConnected && this.ports.equals(that.ports);
    }

    public boolean isEmpty() {
        return !this.dfuFound && !this.stLinkConnected && !this.PCANConnected && this.ports.isEmpty();
    }
}

