/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.io;

import com.opensr5.ConfigurationImage;
import com.opensr5.ConfigurationImageMeta;
import com.opensr5.ConfigurationImageMetaVersion0_0;
import com.opensr5.ConfigurationImageWithMeta;
import com.opensr5.io.ConfigurationImageMetaYamlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public class ConfigurationImageFile {
    private static final Log log = LogFactory.getLog(ConfigurationImageFile.class);
    private static final String IMAGE_ZIP_ENTRY_NAME = "Image.bin";

    private ConfigurationImageFile() {
    }

    public static ConfigurationImageWithMeta readFromFile(String fileName) throws IOException {
        try (ZipFile zipFile = new ZipFile(fileName);){
            Optional<Object> meta = Optional.empty();
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                String zipEntryName = zipEntry.getName();
                if (ConfigurationImageMeta.getZipEntryName(ConfigurationImageMetaVersion0_0.class).equals(zipEntryName)) {
                    if (meta.isPresent()) continue;
                    ConfigurationImageMetaVersion0_0 metaVersion0_0 = ConfigurationImageMetaYamlUtil.loadMeta(ConfigurationImageMetaVersion0_0.class, zipFile.getInputStream(zipEntry));
                    meta = Optional.of(metaVersion0_0);
                    continue;
                }
                if (IMAGE_ZIP_ENTRY_NAME.equals(zipEntryName)) continue;
                log.warn(String.format("Unexpected entry: `%s` in file `%s`", zipEntryName, fileName));
            }
            if (meta.isPresent()) {
                ConfigurationImageMeta foundMeta = (ConfigurationImageMeta)meta.get();
                ZipEntry calibrationsZipEntry = zipFile.getEntry(IMAGE_ZIP_ENTRY_NAME);
                try (InputStream calibrationsInputStream = zipFile.getInputStream(calibrationsZipEntry);){
                    byte[] content = ConfigurationImageFile.readFromStream(foundMeta.getImageSize(), calibrationsInputStream);
                    if (content != null) {
                        ConfigurationImageWithMeta configurationImageWithMeta = new ConfigurationImageWithMeta(foundMeta, content);
                        return configurationImageWithMeta;
                    }
                    log.warn(String.format("Loading content from file `%s` failed", fileName));
                }
            } else {
                log.warn(String.format("Meta is not found in file `%s`", fileName));
            }
            ConfigurationImageWithMeta configurationImageWithMeta = null;
            return configurationImageWithMeta;
        }
    }

    private static byte @Nullable [] readFromStream(int size, InputStream fis) throws IOException {
        byte[] image = new byte[size];
        int result = fis.read(image);
        if (result == image.length) {
            log.warn(String.format("%d bytes are read instead of expected %d", result, size));
            return image;
        }
        return null;
    }

    private static byte[] getFileContent(ConfigurationImage configurationImage) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(configurationImage.getContent());
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        baos.close();
        return byArray;
    }

    public static void saveToFile(ConfigurationImageWithMeta configurationImage, String fileName) throws IOException {
        System.out.printf("Saving " + configurationImage.getSize() + " bytes of configuration into " + fileName, new Object[0]);
        File outputFile = new File(fileName);
        byte[] calibrationsFileContent = ConfigurationImageFile.getFileContent(configurationImage);
        int calibrationsFileSize = calibrationsFileContent.length;
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ZipEntry calibrationsZipEntry = new ZipEntry(IMAGE_ZIP_ENTRY_NAME);
            zos.putNextEntry(calibrationsZipEntry);
            calibrationsZipEntry.setSize(calibrationsFileSize);
            zos.write(calibrationsFileContent);
            zos.closeEntry();
            ConfigurationImageMeta meta = configurationImage.getMeta();
            ZipEntry metaZipEntry = new ZipEntry(meta.getZipEntryName());
            zos.putNextEntry(metaZipEntry);
            ConfigurationImageMetaYamlUtil.dump(meta, zos);
            zos.closeEntry();
        }
    }
}

