/*
 * Decompiled with CFR 0.152.
 */
package etch.util;

import java.io.EOFException;
import java.nio.BufferOverflowException;

public abstract class ByteBuffer {
    public boolean isEmpty() {
        return this.length() == 0;
    }

    public boolean isFull() {
        return this.length() == this.size();
    }

    public abstract int size();

    public abstract int length();

    public abstract byte get() throws EOFException;

    public int get(byte[] buf) {
        return this.get(buf, 0, buf.length);
    }

    public int get(byte[] buf, int off, int len) {
        if (off < 0) {
            throw new IllegalArgumentException("off < 0");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (off + len > buf.length) {
            throw new IllegalArgumentException("off+len > buf.length");
        }
        if (len == 0) {
            return 0;
        }
        int count = 0;
        try {
            while (len > 0) {
                buf[off] = this.get();
                ++count;
                ++off;
                --len;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return count;
    }

    public abstract void put(byte var1) throws BufferOverflowException;

    public int put(byte[] buf) {
        return this.put(buf, 0, buf.length);
    }

    public int put(byte[] buf, int off, int len) {
        if (off < 0) {
            throw new IllegalArgumentException("off < 0");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (off + len > buf.length) {
            throw new IllegalArgumentException("off+len > buf.length");
        }
        if (len == 0) {
            return 0;
        }
        int count = 0;
        try {
            while (len > 0) {
                this.put(buf[off]);
                ++count;
                ++off;
                --len;
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        return count;
    }

    public abstract void clear();

    public int getInt() throws EOFException {
        int b0 = this.get() & 0xFF;
        int b1 = this.get() & 0xFF;
        int b2 = this.get() & 0xFF;
        int b3 = this.get() & 0xFF;
        return b0 | b1 << 8 | b2 << 16 | b3 << 24;
    }

    public int getShort() throws EOFException {
        int b0 = this.get() & 0xFF;
        int b1 = this.get() & 0xFF;
        return b0 | b1 << 8;
    }

    public int getByte() throws EOFException {
        int b0 = this.get() & 0xFF;
        return b0;
    }
}

