/*
 * Decompiled with CFR 0.152.
 */
package neoe.formatter.lua;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import neoe.formatter.lua.LuaTokenType;
import neoe.formatter.lua.LuaTokens;
import neoe.util.FileIterator;
import neoe.util.FileUtil;

public class LuaFormatter {
    private static boolean TESTING_LEVEL = false;
    private static boolean DEBUG = false;
    List<String> fs = new ArrayList<String>();
    private String encoding = "utf8";
    private boolean overwritesource = false;
    private Writer debug;
    private int err;
    private int ok;
    private int skip;
    StringBuilder sb;
    LuaTokens tokens;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            LuaFormatter.usage();
        } else {
            new LuaFormatter().run(args);
        }
    }

    private static void usage() {
        System.out.println("luaformatter: args:\n -o  -- overwrite source\n -e<ENCODING> -- use ENCODING\n -d -- debug\n  input-files\n");
    }

    public void run(String[] args) throws Exception {
        for (String s : args) {
            if (s.startsWith("-")) {
                this.doOpt(s);
                continue;
            }
            this.addFile(s);
        }
        if (this.fs.isEmpty()) {
            System.out.println("no input files");
        } else {
            for (String fn : this.fs) {
                this.formatFile(fn);
            }
        }
        System.out.printf("OK: %d, Error:%d, skip: %d\n", this.ok, this.err, this.skip);
    }

    private void addFile(String fn) {
        File f = new File(fn);
        if (f.isDirectory()) {
            for (File f1 : new FileIterator(fn)) {
                String name = f1.getName();
                if (!name.endsWith(".lua") || name.endsWith(".fmt.lua") || name.endsWith(".fmt-err.lua")) continue;
                this.fs.add(f1.getAbsolutePath());
            }
        } else if (f.isFile()) {
            this.fs.add(fn);
        }
    }

    private void doOpt(String s) {
        if (s.startsWith("-e")) {
            this.encoding = s.substring(2);
        } else if (s.startsWith("-o")) {
            this.overwritesource = true;
        } else if (s.startsWith("-d")) {
            DEBUG = true;
            TESTING_LEVEL = true;
            this.overwritesource = false;
        }
    }

    public void formatFile(String fn) {
        try {
            Env env = new Env();
            if (DEBUG) {
                this.debug = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("debug.log"), "utf8"));
            }
            if (DEBUG) {
                this.debug.write("read " + fn + "\n");
            }
            String txt = FileUtil.readString(new FileInputStream(fn), this.encoding);
            try {
                byte[] bs2;
                String res = this.format(txt, env);
                if (env.indent != 0) {
                    env.indent = 0;
                    throw new RuntimeException("indent not correct:" + fn);
                }
                String res2 = this.format(res, new Env());
                byte[] bs1 = res.getBytes(this.encoding);
                if (bs1.length != (bs2 = res2.getBytes(this.encoding)).length) {
                    FileUtil.save(bs1, fn + ".fmt-err1.lua");
                    FileUtil.save(bs2, fn + ".fmt-err2.lua");
                    byte[] bs3 = FileUtil.read(new FileInputStream(fn + ".fmt-err1.lua"));
                    System.out.printf("bs1 vs bs3(after wrote),len %d vs %d\n", bs1.length, bs3.length);
                    int len = Math.min(bs1.length, bs2.length);
                    for (int i = 0; i < len; ++i) {
                        if (bs1[i] == bs2[i]) continue;
                        System.out.printf("pos %,d not match:%x vs %x, '%s' vs '%s'\n", i, bs1[i], bs2[i], new String(bs1, i, 10), new String(bs2, i, 10));
                        break;
                    }
                    throw new RuntimeException(String.format("reformat not test ok, size  %,d -> %,d , fn:%s, debug[%x %x %x %x]", bs1.length, bs2.length, fn, bs1[0], bs2[0], bs1[bs1.length - 1], bs2[bs2.length - 1]));
                }
                if (txt.equals(res)) {
                    ++this.skip;
                } else {
                    File f2 = new File(fn + (this.overwritesource ? "" : ".fmt.lua"));
                    FileUtil.save(res.getBytes(this.encoding), f2.getAbsolutePath());
                    if (DEBUG) {
                        System.out.println("wrote to " + f2.getAbsolutePath());
                    }
                    ++this.ok;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                File f2 = new File(fn + ".fmt-err.lua");
                FileUtil.save(this.sb.toString().getBytes(this.encoding), f2.getAbsolutePath());
                System.out.println("wrote to " + f2.getAbsolutePath());
                ++this.err;
            }
            if (DEBUG) {
                this.debug.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.printf("when formatting [%s]\n", fn);
        }
    }

    public String format(String txt, Env env) {
        this.sb = new StringBuilder();
        this.tokens = new LuaTokens(txt);
        this.loop(null, null, null, env);
        return this.sb.toString();
    }

    private void loop(LuaTokenType preType, String until, LuaTokenType operator, Env env) {
        LuaTokens.TypeAndValue tt;
        env.lastType = preType;
        while ((tt = this.tokens.next()) != null) {
            this.addSpaceOnNeed(env, tt);
            LuaTokenType type = tt.getType();
            String token = tt.getValue();
            if (token == null) break;
            if (DEBUG) {
                try {
                    this.debug.write(String.format("t:%s,v:%s\n", new Object[]{type, token}));
                    this.debug.flush();
                }
                catch (IOException e) {
                    System.out.println("Unexpected e");
                }
            }
            this.addToken(env, tt);
            if ((!LuaTokenType.OPERATOR.equals((Object)operator) || token.indexOf(until) < 0) && !token.equals(until)) continue;
            break;
        }
    }

    private void addToken(Env env, LuaTokens.TypeAndValue tt) {
        LuaTokenType type = tt.getType();
        String token = tt.getValue();
        env.forcedChangeLine = false;
        if (type.equals((Object)LuaTokenType.COMMENT)) {
            this.pre(env, tt);
            if (this.isMultiLineToken(token)) {
                this.sb.append(token);
            } else {
                this.sb.append(this.normalComment(token.trim()));
            }
        } else if (type.equals((Object)LuaTokenType.SPACE)) {
            int cnt = this.printSpaceLines(env, token);
            if (cnt <= 0) {
                this.addSpaceOnNeed(env, tt);
            } else {
                env.changedLine = cnt;
            }
        } else if (type.equals((Object)LuaTokenType.IDENTIFIER)) {
            if ("end".equals(token)) {
                String key = this.decIndent(env);
                this.changeLineOnNeed(env);
                this.printToken(env, tt);
                this.changeLineOnNeed(env);
                if ("function".equals(key)) {
                    this.sb.append("\n");
                    ++env.changedLine;
                }
            } else if ("else".equals(token)) {
                String key = this.decIndent(env);
                this.changeLineOnNeed(env);
                this.printToken(env, tt);
                this.incIndent(env, key);
                this.changeLineOnNeed(env);
            } else if ("elseif".equals(token)) {
                this.changeLineOnNeed(env);
                String key = this.decIndent(env);
                this.printToken(env, tt);
            } else if ("until".equals(token)) {
                this.decIndent(env);
                this.printToken(env, tt);
            } else if ("do".equals(token)) {
                this.printToken(env, tt);
                this.incIndent(env, token);
                this.changeLineOnNeed(env);
            } else if ("local".equals(token)) {
                this.changeLineOnNeed(env);
                this.printToken(env, tt);
            } else if ("if".equals(token)) {
                this.changeLineOnNeed(env);
                this.printToken(env, tt);
            } else if ("then".equals(token)) {
                this.printToken(env, tt);
                this.forceChangeLine(env);
                this.incIndent(env, token);
            } else if ("function".equals(token)) {
                this.printToken(env, tt);
                env.changedLine = 0;
                this.loop(type, ")", LuaTokenType.OPERATOR, env);
                this.forceChangeLine(env);
                this.incIndent(env, token);
            } else if ("while".equals(token)) {
                this.changeLineOnNeed(env);
                this.printToken(env, tt);
            } else if ("for".equals(token)) {
                this.changeLineOnNeed(env);
                this.printToken(env, tt);
            } else if ("print".equals(token)) {
                this.changeLineOnNeed(env);
                this.printToken(env, tt);
            } else if ("repeat".equals(token)) {
                this.changeLineOnNeed(env);
                this.printToken(env, tt);
                this.forceChangeLine(env);
                this.incIndent(env, token);
                this.loop(type, "until", null, env);
            } else {
                this.printToken(env, tt);
            }
        } else if (type.equals((Object)LuaTokenType.OPERATOR)) {
            if (token.equals(".")) {
                this.sb.append(token);
            } else if ("}])".indexOf(token) >= 0) {
                this.decIndent(env);
                this.printToken(env, tt);
            } else if ("{[(".indexOf(token) >= 0) {
                this.printToken(env, tt);
                this.incIndent(env, token);
            } else if (token.equals(";")) {
                if (env.changedLine <= 0) {
                    this.newline();
                    env.forcedChangeLine = true;
                    env.changedLine = 1;
                } else if (!env.lastType.equals((Object)LuaTokenType.SPACE)) {
                    if (env.changedLine <= 0) {
                        this.sb.append(" ");
                    }
                    type = LuaTokenType.SPACE;
                }
            } else {
                this.printToken(env, tt);
            }
        } else {
            this.printToken(env, tt);
        }
        env.lastType = type;
        env.lastToken = token;
    }

    private void printToken(Env env, LuaTokens.TypeAndValue tt) {
        this.pre(env, tt);
        this.sb.append(tt.getValue());
    }

    private int printSpaceLines(Env env, String token) {
        int cnt = 0;
        for (char c : token.toCharArray()) {
            if (c != '\n') continue;
            if (cnt >= env.changedLine) {
                this.newline();
            }
            ++cnt;
        }
        return cnt;
    }

    private void pre(Env env, LuaTokens.TypeAndValue tt) {
        if (env.changedLine > 0) {
            this.printIndent(env);
            env.changedLine = 0;
        } else {
            this.addSpaceOnNeed(env, tt);
        }
    }

    private String normalComment(String s) {
        if (((String)s).startsWith("--") && ((String)s).length() > 2 && ((String)s).charAt(2) != ' ' && ((String)s).charAt(2) != '-') {
            s = "-- " + ((String)s).substring(2);
        }
        return s;
    }

    private boolean isMultiLineToken(String token) {
        return token.startsWith("--[") && token.endsWith("]");
    }

    private void printIndent(Env env) {
        if (TESTING_LEVEL) {
            this.sb.append("[" + env.indent + "]");
        }
        for (int i = 0; i < env.indent; ++i) {
            this.sb.append("\t");
        }
    }

    private void incIndent(Env env, String key) {
        ++env.indent;
        env.stack.push(key);
    }

    private void changeLineOnNeed(Env env) {
        if (env.changedLine <= 0) {
            this.newline();
            env.forcedChangeLine = true;
            env.changedLine = 1;
        }
    }

    private void newline() {
        char c;
        int p = this.sb.length();
        while (p > 0 && ((c = this.sb.charAt(p - 1)) == ' ' || c == '\t')) {
            this.sb.setLength(--p);
        }
        this.sb.append("\n");
    }

    private void forceChangeLine(Env env) {
        this.newline();
        env.forcedChangeLine = true;
        env.changedLine = 1;
    }

    private String decIndent(Env env) {
        --env.indent;
        return (String)env.stack.pop();
    }

    private void addSpaceOnNeed(Env env, LuaTokens.TypeAndValue currentToken) {
        if (env.lastType != null && !LuaTokenType.SPACE.equals((Object)env.lastType) && !".".equals(env.lastToken) && env.changedLine <= 0) {
            if ("(".equals(env.lastToken) || "[".equals(env.lastToken)) {
                return;
            }
            if (currentToken != null && (")".equals(currentToken.getValue()) || "(".equals(currentToken.getValue()) || ".".equals(currentToken.getValue()) || ",".equals(currentToken.getValue()) || "[".equals(currentToken.getValue()) || "]".equals(currentToken.getValue()))) {
                return;
            }
            this.sb.append(" ");
            env.lastType = LuaTokenType.SPACE;
            env.changedLine = 0;
        }
    }

    public static class Env {
        LuaTokenType lastType = LuaTokenType.SPACE;
        int indent;
        int changedLine;
        String lastToken;
        boolean forcedChangeLine;
        Stack stack = new Stack();
    }
}

