/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.can.elm;

import com.devexperts.logging.Logging;
import com.opensr5.io.DataListener;
import com.rusefi.io.IoStream;
import com.rusefi.io.can.HexUtil;
import com.rusefi.io.can.elm.Elm327IoStream;
import com.rusefi.io.can.isotp.IsoTpConnector;
import com.rusefi.util.HexBinary;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Elm327Connector
implements Closeable {
    private static final Logging log = Logging.getLogging(Elm327Connector.class);
    public static final int ELM327_DEFAULT_BAUDRATE = 38400;
    private static final int BIG_TIMEOUT = 2000;
    private static final int TIMEOUT = 70;
    public static final String HELLO = "ATZ";
    public static final String ELM_EOL = "\r";
    private static final int CAN_PC_SERIAL_RX_ID = 1824;
    private static final int CAN_PC_SERIAL_TX_ID = 1808;
    private final Object lock = new Object();
    private final IoStream underlyingStream;
    private final Elm327IoStream tsStream;
    private String partialLine = "";
    private final List<String> completeLines = new ArrayList<String>();
    private boolean isCommandMode = false;
    private final DataListener listener = freshData -> {
        int newL;
        String freshStr = new String(freshData);
        while ((newL = freshStr.indexOf(13)) >= 0) {
            Object curLine = this.partialLine;
            this.partialLine = "";
            if (newL > 0) {
                curLine = (String)curLine + freshStr.substring(0, newL);
            }
            if (((String)curLine).length() > 0) {
                this.processLine((String)curLine);
            }
            freshStr = freshStr.substring(newL + 1);
        }
        this.partialLine = this.partialLine + freshStr;
    };
    private final IsoTpConnector connector = new IsoTpConnector(1808){

        @Override
        public void sendCanData(byte[] total) {
            Elm327Connector.this.sendCanData(total);
        }

        @Override
        public void receiveData() {
            Elm327Connector.this.receiveData();
        }
    };

    public Elm327Connector(IoStream underlyingStream) {
        this.underlyingStream = underlyingStream;
        underlyingStream.setInputListener(this.listener);
        this.tsStream = new Elm327IoStream(this);
    }

    public static void whyDoWeNeedToSleepBetweenCommands() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public Elm327IoStream getTsStream() {
        return this.tsStream;
    }

    public boolean start(String msg) {
        log.info("* Elm327.start()");
        boolean initConnection = this.initConnection(msg);
        if (initConnection) {
            this.sendCommand("ATD", "OK");
            this.sendCommand("ATE0", "OK");
            this.sendCommand("ATSP6", "OK");
            this.sendCommand("ATCF " + Integer.toHexString(1824), "OK");
            this.sendCommand("ATCM FFF", "OK");
            this.sendCommand("ATSH " + Integer.toHexString(1808), "OK");
            this.sendCommand("ATFCSH " + Integer.toHexString(1808), "OK");
            this.sendCommand("ATFCSD 30 00 00", "OK");
            this.sendCommand("ATFCSM 1", "OK");
            this.sendCommand("ATCAF 0", "OK");
            this.sendCommand("ATAL", "OK");
            this.sendCommand("ATS 0", "OK");
            this.sendCommand("ATCSM 0", "OK");
            String voltage = this.sendCommand("ATRV", "([0-9\\.]+)V");
            log.info("* Ignition voltage = " + voltage);
        }
        return initConnection;
    }

    @Override
    public void close() {
        log.info("* Elm327.close()");
        if (this.underlyingStream != null) {
            this.underlyingStream.close();
        }
    }

    public void sendBytesToSerial(byte[] bytes) {
        IsoTpConnector.sendStrategy(bytes, this.connector);
    }

    private boolean initConnection(String msg) {
        if (this.sendCommand(HELLO, "ELM327 v[0-9]+\\.[0-9]+", 2000) != null) {
            log.info("ELM DETECTED on " + msg + "! 38400");
            return true;
        }
        log.info("ELM NOT FOUND on " + msg + "! 38400");
        return false;
    }

    private String sendCommand(String command, String responseFilter) {
        return this.sendCommand(command, responseFilter, 70);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendCommand(String command, String responseFilter, int timeout) {
        String inputLine;
        Pattern pattern;
        Matcher matcher;
        log.info("* Elm327.cmd: " + command);
        this.isCommandMode = true;
        this.completeLines.clear();
        try {
            this.underlyingStream.write((command + ELM_EOL).getBytes());
            this.waitForResponse(timeout);
        }
        catch (IOException | InterruptedException ignore) {
            String string = null;
            return string;
        }
        finally {
            this.isCommandMode = false;
        }
        if (this.completeLines.size() < 1) {
            return null;
        }
        int responseIdx = 0;
        if (this.completeLines.get(0).equals(command)) {
            responseIdx = 1;
        }
        if ((matcher = (pattern = Pattern.compile(responseFilter)).matcher(inputLine = this.completeLines.get(responseIdx))).find()) {
            return matcher.groupCount() > 0 ? matcher.group(1) : matcher.group();
        }
        return null;
    }

    private void sendCanData(byte[] data) {
        if (log.debugEnabled()) {
            log.debug("sendCanData total  " + HexBinary.printByteArray(data));
        }
        byte[] hexData = Elm327Connector.byteToString(data);
        try {
            this.underlyingStream.write(hexData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public static byte[] byteToString(byte[] data) {
        int length = data.length;
        byte[] hexData = new byte[length * 2 + 1];
        for (int i = 0; i < length; ++i) {
            int j = i * 2;
            int v = data[i] & 0xFF;
            hexData[j] = HexUtil.HEX_BYTE_ARRAY[v >>> 4];
            hexData[j + 1] = HexUtil.HEX_BYTE_ARRAY[v & 0xF];
        }
        hexData[length * 2] = 13;
        return hexData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] receiveData() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.waitForResponse(70);
                return null;
            }
            catch (InterruptedException ignore) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResponse(int timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            int numLines;
            do {
                numLines = this.completeLines.size();
                this.lock.wait(timeout);
            } while (this.completeLines.size() != numLines);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLine(String line) {
        Object object = this.lock;
        synchronized (object) {
            log.info("Elm327Connector.processLine(): {" + line + "}");
            if (line.charAt(0) == '>') {
                line = line.substring(1);
            }
            if (this.isCommandMode) {
                this.completeLines.add(line);
                this.lock.notifyAll();
            } else {
                this.sendDataBack(line);
            }
        }
    }

    private void sendDataBack(String line) {
        byte[] canPacket = HexUtil.asBytes(line);
        this.tsStream.processCanPacket(canPacket);
    }

    public static boolean checkConnection(String serialPort, IoStream stream) {
        Elm327Connector con = new Elm327Connector(stream);
        boolean found = con.initConnection(serialPort);
        con.close();
        return found;
    }

    static {
        log.configureDebugEnabled(false);
    }
}

