/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.opensr5.ini.IniFileModelImpl;
import com.rusefi.FileLog;
import com.rusefi.IoUtil;
import com.rusefi.SimulatorExecHelper;
import com.rusefi.TestingUtils;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.LinkManager;
import com.rusefi.simulator.SimulatorFunctionalTest;
import java.io.File;
import java.io.IOException;

public class SimulatorFunctionalTestLauncher {
    static volatile boolean isHappy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            e.printStackTrace();
            System.exit(66);
        });
        String iniFileName = args[0];
        IniFileModelImpl ini = new IniFileModelImpl().readIniFile(iniFileName);
        BinaryProtocol.iniFileProvider = signature -> ini;
        boolean startSimulator = args.length > 1 && args[1].equalsIgnoreCase("start");
        long start = System.currentTimeMillis();
        FileLog.SIMULATOR_CONSOLE.start();
        FileLog.MAIN.start();
        boolean failed = false;
        try {
            LinkManager linkManager = new LinkManager();
            IoUtil.connectToSimulator(linkManager, startSimulator);
            TestingUtils.installVoidEngineSnifferAction(linkManager.getCommandQueue());
            new SimulatorFunctionalTest(linkManager).mainTestBody();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            failed = true;
        }
        finally {
            SimulatorExecHelper.destroy();
        }
        if (failed) {
            System.exit(-1);
        }
        isHappy = true;
        FileLog.MAIN.logLine("*******************************************************************************");
        FileLog.MAIN.logLine("**** SimulatorFunctionalTestLauncher  Looks good! *****************************");
        FileLog.MAIN.logLine("*******************************************************************************");
        long time = (System.currentTimeMillis() - start) / 1000L;
        FileLog.MAIN.logLine("Done in " + time + "secs");
        System.exit(0);
    }

    private static void buildSimulator() throws IOException, InterruptedException {
        Process makeProcess = Runtime.getRuntime().exec("make -j8", null, new File("../simulator"));
        SimulatorExecHelper.dumpProcessOutput(makeProcess, null);
        makeProcess.waitFor();
    }
}

