/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.rusefi.AvailableHardware;
import com.rusefi.FileLog;
import com.rusefi.SerialPortScanner;
import com.rusefi.StartupFrame;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.maintenance.UpdateStatusWindow;
import com.rusefi.ui.BasicLogoHelper;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.basic.UpdateCalibrations;
import com.rusefi.ui.util.DefaultExceptionHandler;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.ToolButtons;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class BasicStartupFrame {
    private static final Logging log = Logging.getLogging(BasicStartupFrame.class);
    private final String whiteLabel = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties());
    private final FrameHelper frame = FrameHelper.createFrame(this.whiteLabel + " basic console 20240918");
    private final boolean isObfuscated = FindFileHelper.isObfuscated();
    private final JLabel statusMessage = new JLabel();
    private final StatusAnimation status = new StatusAnimation(this::updateStatus, "Scanning ports");
    private final JButton updateFirmwareButton = ProgramSelector.createUpdateFirmwareButton();
    private final JButton updateCalibrationsButton = new JButton("Update Calibrations", AutoupdateUtil.loadIcon("writeconfig48.png"));
    private final UpdateCalibrations updateCalibrations = new UpdateCalibrations();
    private volatile Optional<SerialPortScanner.PortResult> portToUpdateObfuscatedFirmware = Optional.empty();
    private volatile Optional<SerialPortScanner.PortResult> portToUpdateCalibrations = Optional.empty();

    public static void main(String[] args) {
        BasicStartupFrame.runTool(null);
    }

    public static void runTool(String[] args) {
        DefaultExceptionHandler.install();
        new BasicStartupFrame();
    }

    public BasicStartupFrame() {
        JPanel panel = new JPanel(new VerticalFlowLayout());
        if (FileLog.isWindows()) {
            panel.add(ToolButtons.createShowDeviceManagerButton());
            panel.add(StartupFrame.binaryModificationControl());
            this.updateFirmwareButton.addActionListener(this::onUpdateFirmwareButtonClicked);
            if (this.isObfuscated) {
                this.updateFirmwareButton.setEnabled(false);
                this.statusMessage.setForeground(Color.red);
                panel.add(this.statusMessage);
            }
            panel.add(this.updateFirmwareButton);
        } else {
            panel.add(new JLabel("Sorry only works on Windows"));
        }
        SerialPortScanner.INSTANCE.addListener(currentHardware -> SwingUtilities.invokeLater(() -> this.onHardwareUpdated(currentHardware)));
        panel.add(new HorizontalLine());
        JLabel logoLabel = LogoHelper.createLogoLabel();
        if (logoLabel != null) {
            panel.add(logoLabel);
        }
        if (ConnectionAndMeta.isDefaultWhitelabel(this.whiteLabel)) {
            panel.add(LogoHelper.createUrlLabel());
        }
        this.updateCalibrationsButton.addActionListener(this::onUpdateCalibrationsButtonClicked);
        this.updateCalibrationsButton.setEnabled(false);
        panel.add(this.updateCalibrationsButton);
        BasicLogoHelper.setGenericFrameIcon(this.frame.getFrame());
        this.frame.showFrame(panel, false);
        UiUtils.centerWindow(this.frame.getFrame());
        this.packFrame();
    }

    private void packFrame() {
        this.frame.getFrame().pack();
    }

    private void hideStatusMessage() {
        this.statusMessage.setText(" ");
    }

    private void updateStatus(String niceStatus) {
        this.statusMessage.setText(niceStatus);
        this.packFrame();
    }

    private void onHardwareUpdated(AvailableHardware currentHardware) {
        this.status.stop();
        this.hideStatusMessage();
        this.packFrame();
        if (this.isObfuscated) {
            this.updatePortToUpdateObfuscatedFirmware(currentHardware);
        }
        this.updatePortToUpdateCalibrations(currentHardware);
    }

    private void updatePortToUpdateObfuscatedFirmware(AvailableHardware currentHardware) {
        List<SerialPortScanner.PortResult> portsToUpdateObfuscatedFirmware = currentHardware.getKnownPorts(Set.of(SerialPortScanner.SerialPortType.EcuWithOpenblt, SerialPortScanner.SerialPortType.OpenBlt));
        switch (portsToUpdateObfuscatedFirmware.size()) {
            case 0: {
                this.resetPortToUpdateObfuscatedFirmware("ECU not found");
                break;
            }
            case 1: {
                this.switchToPortToUpdateObfuscatedFirmware(portsToUpdateObfuscatedFirmware.get(0));
                break;
            }
            default: {
                this.resetPortToUpdateObfuscatedFirmware(String.format("Multiple ECUs found on: %s", portsToUpdateObfuscatedFirmware.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
            }
        }
    }

    private void switchToPortToUpdateObfuscatedFirmware(SerialPortScanner.PortResult port) {
        this.portToUpdateObfuscatedFirmware = Optional.of(port);
        this.hideStatusMessage();
        this.updateFirmwareButton.setEnabled(true);
        switch (port.type) {
            case EcuWithOpenblt: {
                this.updateFirmwareButton.setText("Auto Update Firmware");
                break;
            }
            case OpenBlt: {
                this.updateFirmwareButton.setText("Blt Update Firmware");
                break;
            }
            default: {
                log.error(String.format("Unexpected port type: %s", port));
            }
        }
    }

    private void resetPortToUpdateObfuscatedFirmware(String reason) {
        this.portToUpdateObfuscatedFirmware = Optional.empty();
        this.updateFirmwareButton.setEnabled(false);
        this.statusMessage.setText(reason);
    }

    private void updatePortToUpdateCalibrations(AvailableHardware currentHardware) {
        List<SerialPortScanner.PortResult> ecuPortsToUpdateCalibrations = currentHardware.getKnownPorts(Set.of(SerialPortScanner.SerialPortType.Ecu, SerialPortScanner.SerialPortType.EcuWithOpenblt));
        switch (ecuPortsToUpdateCalibrations.size()) {
            case 0: {
                this.resetPortToUpdateCalibrations();
                log.info("No ECU ports to update calibrations found");
                break;
            }
            case 1: {
                this.setPortToUpdateCalibrations(ecuPortsToUpdateCalibrations.get(0));
                break;
            }
            default: {
                this.resetPortToUpdateCalibrations();
                log.info(String.format("Multiple ECU ports to update calibrations found on: %s", ecuPortsToUpdateCalibrations.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
            }
        }
    }

    private void setPortToUpdateCalibrations(SerialPortScanner.PortResult port) {
        this.portToUpdateCalibrations = Optional.of(port);
        this.updateCalibrationsButton.setEnabled(true);
    }

    private void resetPortToUpdateCalibrations() {
        this.portToUpdateCalibrations = Optional.empty();
        this.updateCalibrationsButton.setEnabled(false);
    }

    private void onUpdateFirmwareButtonClicked(ActionEvent actionEvent) {
        if (this.isObfuscated) {
            this.portToUpdateObfuscatedFirmware.ifPresentOrElse(port -> {
                switch (port.type) {
                    case EcuWithOpenblt: {
                        ProgramSelector.executeJob(this.updateFirmwareButton, "Auto OpenBLT Update", port);
                        break;
                    }
                    case OpenBlt: {
                        ProgramSelector.executeJob(this.updateFirmwareButton, "Manual OpenBLT Update", port);
                        break;
                    }
                    default: {
                        log.error(String.format("Unexpected port type: %s (%s)", new Object[]{port.type, port}));
                    }
                }
            }, () -> log.error("Port to update firmware is not defined."));
        } else {
            DfuFlasher.doAutoDfu(this.updateFirmwareButton, "auto", new UpdateStatusWindow("Update"));
        }
    }

    private void onUpdateCalibrationsButtonClicked(ActionEvent actionEvent) {
        this.portToUpdateCalibrations.ifPresentOrElse(port -> this.updateCalibrations.updateCalibrationsAction((SerialPortScanner.PortResult)port, this.updateCalibrationsButton), () -> JOptionPane.showMessageDialog(this.updateCalibrationsButton, "Device is not connected", "Error", 0));
    }
}

