/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.rusefi.AvailableHardware;
import com.rusefi.FileLog;
import com.rusefi.SerialPortScanner;
import com.rusefi.StartupFrame;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.maintenance.JobType;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.ui.BasicLogoHelper;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.basic.JobParameters;
import com.rusefi.ui.basic.UpdateCalibrations;
import com.rusefi.ui.util.DefaultExceptionHandler;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.ToolButtons;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class BasicStartupFrame {
    private static final Logging log = Logging.getLogging(BasicStartupFrame.class);
    private final String whiteLabel = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties());
    private final FrameHelper frame = FrameHelper.createFrame(this.whiteLabel + " basic console 20240919");
    private final boolean isObfuscated = FindFileHelper.isObfuscated();
    private final JLabel statusMessage = new JLabel();
    private final StatusAnimation status = new StatusAnimation(this::updateStatus, "Scanning ports");
    private final JButton updateFirmwareButton = ProgramSelector.createUpdateFirmwareButton();
    private final JButton updateCalibrationsButton = new JButton("Update Calibrations", AutoupdateUtil.loadIcon("writeconfig48.png"));
    private final UpdateCalibrations updateCalibrations = new UpdateCalibrations();
    private volatile Optional<JobParameters> updateFirmwareJob = Optional.empty();
    private volatile Optional<SerialPortScanner.PortResult> portToUpdateCalibrations = Optional.empty();

    public static void main(String[] args) {
        BasicStartupFrame.runTool(null);
    }

    public static void runTool(String[] args) {
        DefaultExceptionHandler.install();
        new BasicStartupFrame();
    }

    public BasicStartupFrame() {
        JPanel panel = new JPanel(new VerticalFlowLayout());
        if (FileLog.isWindows()) {
            panel.add(ToolButtons.createShowDeviceManagerButton());
            panel.add(StartupFrame.binaryModificationControl());
            this.updateFirmwareButton.addActionListener(this::onUpdateFirmwareButtonClicked);
            this.updateFirmwareButton.setEnabled(false);
            this.statusMessage.setForeground(Color.red);
            panel.add(this.statusMessage);
            panel.add(this.updateFirmwareButton);
        } else {
            panel.add(new JLabel("Sorry only works on Windows"));
        }
        SerialPortScanner.INSTANCE.addListener(currentHardware -> SwingUtilities.invokeLater(() -> this.onHardwareUpdated(currentHardware)));
        panel.add(new HorizontalLine());
        JLabel logoLabel = LogoHelper.createLogoLabel();
        if (logoLabel != null) {
            panel.add(logoLabel);
        }
        if (ConnectionAndMeta.isDefaultWhitelabel(this.whiteLabel)) {
            panel.add(LogoHelper.createUrlLabel());
        }
        this.updateCalibrationsButton.addActionListener(this::onUpdateCalibrationsButtonClicked);
        this.updateCalibrationsButton.setEnabled(false);
        if (ConnectionAndMeta.showUpdateCalibrations()) {
            panel.add(this.updateCalibrationsButton);
        }
        BasicLogoHelper.setGenericFrameIcon(this.frame.getFrame());
        this.frame.showFrame(panel, false);
        UiUtils.centerWindow(this.frame.getFrame());
        this.packFrame();
    }

    private void packFrame() {
        this.frame.getFrame().pack();
    }

    private void hideStatusMessage() {
        this.statusMessage.setText(" ");
    }

    private void updateStatus(String niceStatus) {
        this.statusMessage.setText(niceStatus);
        this.packFrame();
    }

    private void onHardwareUpdated(AvailableHardware currentHardware) {
        this.status.stop();
        this.hideStatusMessage();
        this.packFrame();
        this.updateUpdateFirmwareJob(currentHardware);
        this.updatePortToUpdateCalibrations(currentHardware);
    }

    private void updateUpdateFirmwareJob(AvailableHardware currentHardware) {
        if (currentHardware.isDfuFound()) {
            this.setUpdateFirmwareJob(new JobParameters(JobType.DFU_MANUAL, null));
        } else {
            Set<SerialPortScanner.SerialPortType> portTypesToUpdateFirmware = this.isObfuscated ? Set.of(SerialPortScanner.SerialPortType.EcuWithOpenblt, SerialPortScanner.SerialPortType.OpenBlt) : Set.of(SerialPortScanner.SerialPortType.Ecu, SerialPortScanner.SerialPortType.EcuWithOpenblt);
            List<SerialPortScanner.PortResult> portsToUpdateFirmware = currentHardware.getKnownPorts(portTypesToUpdateFirmware);
            switch (portsToUpdateFirmware.size()) {
                case 0: {
                    this.resetUpdateFirmwareJob("ECU not found");
                    break;
                }
                case 1: {
                    SerialPortScanner.PortResult portToUpdateFirmware = portsToUpdateFirmware.get(0);
                    JobType jobType = null;
                    if (this.isObfuscated) {
                        SerialPortScanner.SerialPortType portType = portToUpdateFirmware.type;
                        switch (portType) {
                            case EcuWithOpenblt: {
                                jobType = JobType.OPENBLT_AUTO;
                                break;
                            }
                            case OpenBlt: {
                                jobType = JobType.OPENBLT_MANUAL;
                                break;
                            }
                            default: {
                                log.error(String.format("Unexpected port type: %s", new Object[]{portType}));
                                break;
                            }
                        }
                    } else {
                        jobType = JobType.DFU_AUTO;
                    }
                    this.setUpdateFirmwareJob(new JobParameters(jobType, portToUpdateFirmware));
                    break;
                }
                default: {
                    this.resetUpdateFirmwareJob(String.format("Multiple ECUs found on: %s", portsToUpdateFirmware.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
                }
            }
        }
    }

    private void setUpdateFirmwareJob(JobParameters jobParams) {
        this.updateFirmwareJob = Optional.of(jobParams);
        this.hideStatusMessage();
        this.updateFirmwareButton.setEnabled(true);
        JobType jobType = jobParams.jobType;
        switch (jobType) {
            case OPENBLT_AUTO: {
                this.updateFirmwareButton.setText("Auto Update Firmware");
                break;
            }
            case OPENBLT_MANUAL: {
                this.updateFirmwareButton.setText("Blt Update Firmware");
                break;
            }
            case DFU_AUTO: {
                this.updateFirmwareButton.setText("Update Firmware");
                break;
            }
            case DFU_MANUAL: {
                this.updateFirmwareButton.setText("Update Firmware via DFU");
                break;
            }
            default: {
                log.error(String.format("Unexpected job type: %s", new Object[]{jobType}));
            }
        }
    }

    private void resetUpdateFirmwareJob(String reason) {
        this.updateFirmwareJob = Optional.empty();
        this.updateFirmwareButton.setEnabled(false);
        this.statusMessage.setText(reason);
    }

    private void updatePortToUpdateCalibrations(AvailableHardware currentHardware) {
        List<SerialPortScanner.PortResult> ecuPortsToUpdateCalibrations = currentHardware.getKnownPorts(Set.of(SerialPortScanner.SerialPortType.Ecu, SerialPortScanner.SerialPortType.EcuWithOpenblt));
        switch (ecuPortsToUpdateCalibrations.size()) {
            case 0: {
                this.resetPortToUpdateCalibrations();
                log.info("No ECU ports to update calibrations found");
                break;
            }
            case 1: {
                this.setPortToUpdateCalibrations(ecuPortsToUpdateCalibrations.get(0));
                break;
            }
            default: {
                this.resetPortToUpdateCalibrations();
                log.info(String.format("Multiple ECU ports to update calibrations found on: %s", ecuPortsToUpdateCalibrations.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
            }
        }
    }

    private void setPortToUpdateCalibrations(SerialPortScanner.PortResult port) {
        this.portToUpdateCalibrations = Optional.of(port);
        this.updateCalibrationsButton.setEnabled(true);
    }

    private void resetPortToUpdateCalibrations() {
        this.portToUpdateCalibrations = Optional.empty();
        this.updateCalibrationsButton.setEnabled(false);
    }

    private void onUpdateFirmwareButtonClicked(ActionEvent actionEvent) {
        this.updateFirmwareJob.ifPresentOrElse(job -> ProgramSelector.executeJob(this.updateFirmwareButton, job.jobType, job.port), () -> log.error("Update firmware job is is not defined."));
    }

    private void onUpdateCalibrationsButtonClicked(ActionEvent actionEvent) {
        this.portToUpdateCalibrations.ifPresentOrElse(port -> this.updateCalibrations.updateCalibrationsAction((SerialPortScanner.PortResult)port, this.updateCalibrationsButton), () -> JOptionPane.showMessageDialog(this.updateCalibrationsButton, "Device is not connected", "Error", 0));
    }
}

